/*
 * Copyright 2022 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.gradle.execution;

import org.gradle.api.internal.project.ProjectInternal;

import static org.gradle.internal.logging.text.StyledTextOutput.Style.UserInput;

/**
 * Thrown when the tasks to execute cannot be selected due to a problem resolving the project to select tasks from.
 */
public class ProjectSelectionException extends TaskSelectionException {
    public ProjectSelectionException(String message) {
        super(message);
    }

    @Override
    public void appendResolutions(Context context) {
        context.appendResolution(output -> {
            output.text("Run ");
            context.getClientMetaData().describeCommand(output.withStyle(UserInput), ProjectInternal.PROJECTS_TASK);
            output.text(" to get a list of available projects.");
        });
    }
}
