/*
 * Decompiled with CFR 0.152.
 */
package sun.util.locale.provider;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.text.BreakIterator;
import java.text.Collator;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.spi.BreakIteratorProvider;
import java.text.spi.CollatorProvider;
import java.text.spi.DateFormatProvider;
import java.text.spi.DateFormatSymbolsProvider;
import java.text.spi.DecimalFormatSymbolsProvider;
import java.text.spi.NumberFormatProvider;
import java.util.Locale;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.spi.CalendarDataProvider;
import java.util.spi.CalendarNameProvider;
import java.util.spi.CurrencyNameProvider;
import java.util.spi.LocaleNameProvider;
import java.util.spi.LocaleServiceProvider;
import java.util.spi.TimeZoneNameProvider;
import sun.util.locale.provider.AuxLocaleProviderAdapter;
import sun.util.locale.provider.LocaleProviderAdapter;
import sun.util.locale.provider.LocaleServiceProviderPool;

public class SPILocaleProviderAdapter
extends AuxLocaleProviderAdapter {
    @Override
    public LocaleProviderAdapter.Type getAdapterType() {
        return LocaleProviderAdapter.Type.SPI;
    }

    @Override
    protected <P extends LocaleServiceProvider> P findInstalledProvider(final Class<P> clazz) {
        try {
            return (P)((LocaleServiceProvider)AccessController.doPrivileged(new PrivilegedExceptionAction<P>(){

                @Override
                public P run() {
                    LocaleServiceProvider localeServiceProvider = null;
                    for (LocaleServiceProvider localeServiceProvider2 : ServiceLoader.loadInstalled(clazz)) {
                        if (localeServiceProvider == null) {
                            try {
                                localeServiceProvider = (LocaleServiceProvider)Class.forName(SPILocaleProviderAdapter.class.getCanonicalName() + "$" + clazz.getSimpleName() + "Delegate").newInstance();
                            }
                            catch (ClassNotFoundException | IllegalAccessException | InstantiationException reflectiveOperationException) {
                                LocaleServiceProviderPool.config(SPILocaleProviderAdapter.class, reflectiveOperationException.toString());
                                return null;
                            }
                        }
                        ((Delegate)((Object)localeServiceProvider)).addImpl(localeServiceProvider2);
                    }
                    return localeServiceProvider;
                }
            }));
        }
        catch (PrivilegedActionException privilegedActionException) {
            LocaleServiceProviderPool.config(SPILocaleProviderAdapter.class, privilegedActionException.toString());
            return null;
        }
    }

    private static <P extends LocaleServiceProvider> P getImpl(Map<Locale, P> map, Locale locale) {
        for (Locale locale2 : LocaleServiceProviderPool.getLookupLocales(locale)) {
            LocaleServiceProvider localeServiceProvider = (LocaleServiceProvider)map.get(locale2);
            if (localeServiceProvider == null) continue;
            return (P)localeServiceProvider;
        }
        return null;
    }

    static class TimeZoneNameProviderDelegate
    extends TimeZoneNameProvider
    implements Delegate<TimeZoneNameProvider> {
        private ConcurrentMap<Locale, TimeZoneNameProvider> map = new ConcurrentHashMap<Locale, TimeZoneNameProvider>();

        TimeZoneNameProviderDelegate() {
        }

        @Override
        public void addImpl(TimeZoneNameProvider timeZoneNameProvider) {
            for (Locale locale : timeZoneNameProvider.getAvailableLocales()) {
                this.map.putIfAbsent(locale, timeZoneNameProvider);
            }
        }

        @Override
        public TimeZoneNameProvider getImpl(Locale locale) {
            return (TimeZoneNameProvider)SPILocaleProviderAdapter.getImpl(this.map, locale);
        }

        @Override
        public Locale[] getAvailableLocales() {
            return this.map.keySet().toArray(new Locale[0]);
        }

        @Override
        public boolean isSupportedLocale(Locale locale) {
            return this.map.containsKey(locale);
        }

        @Override
        public String getDisplayName(String string, boolean bl, int n, Locale locale) {
            TimeZoneNameProvider timeZoneNameProvider = this.getImpl(locale);
            assert (timeZoneNameProvider != null);
            return timeZoneNameProvider.getDisplayName(string, bl, n, locale);
        }

        @Override
        public String getGenericDisplayName(String string, int n, Locale locale) {
            TimeZoneNameProvider timeZoneNameProvider = this.getImpl(locale);
            assert (timeZoneNameProvider != null);
            return timeZoneNameProvider.getGenericDisplayName(string, n, locale);
        }
    }

    static class LocaleNameProviderDelegate
    extends LocaleNameProvider
    implements Delegate<LocaleNameProvider> {
        private ConcurrentMap<Locale, LocaleNameProvider> map = new ConcurrentHashMap<Locale, LocaleNameProvider>();

        LocaleNameProviderDelegate() {
        }

        @Override
        public void addImpl(LocaleNameProvider localeNameProvider) {
            for (Locale locale : localeNameProvider.getAvailableLocales()) {
                this.map.putIfAbsent(locale, localeNameProvider);
            }
        }

        @Override
        public LocaleNameProvider getImpl(Locale locale) {
            return (LocaleNameProvider)SPILocaleProviderAdapter.getImpl(this.map, locale);
        }

        @Override
        public Locale[] getAvailableLocales() {
            return this.map.keySet().toArray(new Locale[0]);
        }

        @Override
        public boolean isSupportedLocale(Locale locale) {
            return this.map.containsKey(locale);
        }

        @Override
        public String getDisplayLanguage(String string, Locale locale) {
            LocaleNameProvider localeNameProvider = this.getImpl(locale);
            assert (localeNameProvider != null);
            return localeNameProvider.getDisplayLanguage(string, locale);
        }

        @Override
        public String getDisplayScript(String string, Locale locale) {
            LocaleNameProvider localeNameProvider = this.getImpl(locale);
            assert (localeNameProvider != null);
            return localeNameProvider.getDisplayScript(string, locale);
        }

        @Override
        public String getDisplayCountry(String string, Locale locale) {
            LocaleNameProvider localeNameProvider = this.getImpl(locale);
            assert (localeNameProvider != null);
            return localeNameProvider.getDisplayCountry(string, locale);
        }

        @Override
        public String getDisplayVariant(String string, Locale locale) {
            LocaleNameProvider localeNameProvider = this.getImpl(locale);
            assert (localeNameProvider != null);
            return localeNameProvider.getDisplayVariant(string, locale);
        }
    }

    static class CurrencyNameProviderDelegate
    extends CurrencyNameProvider
    implements Delegate<CurrencyNameProvider> {
        private ConcurrentMap<Locale, CurrencyNameProvider> map = new ConcurrentHashMap<Locale, CurrencyNameProvider>();

        CurrencyNameProviderDelegate() {
        }

        @Override
        public void addImpl(CurrencyNameProvider currencyNameProvider) {
            for (Locale locale : currencyNameProvider.getAvailableLocales()) {
                this.map.putIfAbsent(locale, currencyNameProvider);
            }
        }

        @Override
        public CurrencyNameProvider getImpl(Locale locale) {
            return (CurrencyNameProvider)SPILocaleProviderAdapter.getImpl(this.map, locale);
        }

        @Override
        public Locale[] getAvailableLocales() {
            return this.map.keySet().toArray(new Locale[0]);
        }

        @Override
        public boolean isSupportedLocale(Locale locale) {
            return this.map.containsKey(locale);
        }

        @Override
        public String getSymbol(String string, Locale locale) {
            CurrencyNameProvider currencyNameProvider = this.getImpl(locale);
            assert (currencyNameProvider != null);
            return currencyNameProvider.getSymbol(string, locale);
        }

        @Override
        public String getDisplayName(String string, Locale locale) {
            CurrencyNameProvider currencyNameProvider = this.getImpl(locale);
            assert (currencyNameProvider != null);
            return currencyNameProvider.getDisplayName(string, locale);
        }
    }

    static class CalendarNameProviderDelegate
    extends CalendarNameProvider
    implements Delegate<CalendarNameProvider> {
        private ConcurrentMap<Locale, CalendarNameProvider> map = new ConcurrentHashMap<Locale, CalendarNameProvider>();

        CalendarNameProviderDelegate() {
        }

        @Override
        public void addImpl(CalendarNameProvider calendarNameProvider) {
            for (Locale locale : calendarNameProvider.getAvailableLocales()) {
                this.map.putIfAbsent(locale, calendarNameProvider);
            }
        }

        @Override
        public CalendarNameProvider getImpl(Locale locale) {
            return (CalendarNameProvider)SPILocaleProviderAdapter.getImpl(this.map, locale);
        }

        @Override
        public Locale[] getAvailableLocales() {
            return this.map.keySet().toArray(new Locale[0]);
        }

        @Override
        public boolean isSupportedLocale(Locale locale) {
            return this.map.containsKey(locale);
        }

        @Override
        public String getDisplayName(String string, int n, int n2, int n3, Locale locale) {
            CalendarNameProvider calendarNameProvider = this.getImpl(locale);
            assert (calendarNameProvider != null);
            return calendarNameProvider.getDisplayName(string, n, n2, n3, locale);
        }

        @Override
        public Map<String, Integer> getDisplayNames(String string, int n, int n2, Locale locale) {
            CalendarNameProvider calendarNameProvider = this.getImpl(locale);
            assert (calendarNameProvider != null);
            return calendarNameProvider.getDisplayNames(string, n, n2, locale);
        }
    }

    static class CalendarDataProviderDelegate
    extends CalendarDataProvider
    implements Delegate<CalendarDataProvider> {
        private ConcurrentMap<Locale, CalendarDataProvider> map = new ConcurrentHashMap<Locale, CalendarDataProvider>();

        CalendarDataProviderDelegate() {
        }

        @Override
        public void addImpl(CalendarDataProvider calendarDataProvider) {
            for (Locale locale : calendarDataProvider.getAvailableLocales()) {
                this.map.putIfAbsent(locale, calendarDataProvider);
            }
        }

        @Override
        public CalendarDataProvider getImpl(Locale locale) {
            return (CalendarDataProvider)SPILocaleProviderAdapter.getImpl(this.map, locale);
        }

        @Override
        public Locale[] getAvailableLocales() {
            return this.map.keySet().toArray(new Locale[0]);
        }

        @Override
        public boolean isSupportedLocale(Locale locale) {
            return this.map.containsKey(locale);
        }

        @Override
        public int getFirstDayOfWeek(Locale locale) {
            CalendarDataProvider calendarDataProvider = this.getImpl(locale);
            assert (calendarDataProvider != null);
            return calendarDataProvider.getFirstDayOfWeek(locale);
        }

        @Override
        public int getMinimalDaysInFirstWeek(Locale locale) {
            CalendarDataProvider calendarDataProvider = this.getImpl(locale);
            assert (calendarDataProvider != null);
            return calendarDataProvider.getMinimalDaysInFirstWeek(locale);
        }
    }

    static class NumberFormatProviderDelegate
    extends NumberFormatProvider
    implements Delegate<NumberFormatProvider> {
        private ConcurrentMap<Locale, NumberFormatProvider> map = new ConcurrentHashMap<Locale, NumberFormatProvider>();

        NumberFormatProviderDelegate() {
        }

        @Override
        public void addImpl(NumberFormatProvider numberFormatProvider) {
            for (Locale locale : numberFormatProvider.getAvailableLocales()) {
                this.map.putIfAbsent(locale, numberFormatProvider);
            }
        }

        @Override
        public NumberFormatProvider getImpl(Locale locale) {
            return (NumberFormatProvider)SPILocaleProviderAdapter.getImpl(this.map, locale);
        }

        @Override
        public Locale[] getAvailableLocales() {
            return this.map.keySet().toArray(new Locale[0]);
        }

        @Override
        public boolean isSupportedLocale(Locale locale) {
            return this.map.containsKey(locale);
        }

        @Override
        public NumberFormat getCurrencyInstance(Locale locale) {
            NumberFormatProvider numberFormatProvider = this.getImpl(locale);
            assert (numberFormatProvider != null);
            return numberFormatProvider.getCurrencyInstance(locale);
        }

        @Override
        public NumberFormat getIntegerInstance(Locale locale) {
            NumberFormatProvider numberFormatProvider = this.getImpl(locale);
            assert (numberFormatProvider != null);
            return numberFormatProvider.getIntegerInstance(locale);
        }

        @Override
        public NumberFormat getNumberInstance(Locale locale) {
            NumberFormatProvider numberFormatProvider = this.getImpl(locale);
            assert (numberFormatProvider != null);
            return numberFormatProvider.getNumberInstance(locale);
        }

        @Override
        public NumberFormat getPercentInstance(Locale locale) {
            NumberFormatProvider numberFormatProvider = this.getImpl(locale);
            assert (numberFormatProvider != null);
            return numberFormatProvider.getPercentInstance(locale);
        }
    }

    static class DecimalFormatSymbolsProviderDelegate
    extends DecimalFormatSymbolsProvider
    implements Delegate<DecimalFormatSymbolsProvider> {
        private ConcurrentMap<Locale, DecimalFormatSymbolsProvider> map = new ConcurrentHashMap<Locale, DecimalFormatSymbolsProvider>();

        DecimalFormatSymbolsProviderDelegate() {
        }

        @Override
        public void addImpl(DecimalFormatSymbolsProvider decimalFormatSymbolsProvider) {
            for (Locale locale : decimalFormatSymbolsProvider.getAvailableLocales()) {
                this.map.putIfAbsent(locale, decimalFormatSymbolsProvider);
            }
        }

        @Override
        public DecimalFormatSymbolsProvider getImpl(Locale locale) {
            return (DecimalFormatSymbolsProvider)SPILocaleProviderAdapter.getImpl(this.map, locale);
        }

        @Override
        public Locale[] getAvailableLocales() {
            return this.map.keySet().toArray(new Locale[0]);
        }

        @Override
        public boolean isSupportedLocale(Locale locale) {
            return this.map.containsKey(locale);
        }

        @Override
        public DecimalFormatSymbols getInstance(Locale locale) {
            DecimalFormatSymbolsProvider decimalFormatSymbolsProvider = this.getImpl(locale);
            assert (decimalFormatSymbolsProvider != null);
            return decimalFormatSymbolsProvider.getInstance(locale);
        }
    }

    static class DateFormatSymbolsProviderDelegate
    extends DateFormatSymbolsProvider
    implements Delegate<DateFormatSymbolsProvider> {
        private ConcurrentMap<Locale, DateFormatSymbolsProvider> map = new ConcurrentHashMap<Locale, DateFormatSymbolsProvider>();

        DateFormatSymbolsProviderDelegate() {
        }

        @Override
        public void addImpl(DateFormatSymbolsProvider dateFormatSymbolsProvider) {
            for (Locale locale : dateFormatSymbolsProvider.getAvailableLocales()) {
                this.map.putIfAbsent(locale, dateFormatSymbolsProvider);
            }
        }

        @Override
        public DateFormatSymbolsProvider getImpl(Locale locale) {
            return (DateFormatSymbolsProvider)SPILocaleProviderAdapter.getImpl(this.map, locale);
        }

        @Override
        public Locale[] getAvailableLocales() {
            return this.map.keySet().toArray(new Locale[0]);
        }

        @Override
        public boolean isSupportedLocale(Locale locale) {
            return this.map.containsKey(locale);
        }

        @Override
        public DateFormatSymbols getInstance(Locale locale) {
            DateFormatSymbolsProvider dateFormatSymbolsProvider = this.getImpl(locale);
            assert (dateFormatSymbolsProvider != null);
            return dateFormatSymbolsProvider.getInstance(locale);
        }
    }

    static class DateFormatProviderDelegate
    extends DateFormatProvider
    implements Delegate<DateFormatProvider> {
        private ConcurrentMap<Locale, DateFormatProvider> map = new ConcurrentHashMap<Locale, DateFormatProvider>();

        DateFormatProviderDelegate() {
        }

        @Override
        public void addImpl(DateFormatProvider dateFormatProvider) {
            for (Locale locale : dateFormatProvider.getAvailableLocales()) {
                this.map.putIfAbsent(locale, dateFormatProvider);
            }
        }

        @Override
        public DateFormatProvider getImpl(Locale locale) {
            return (DateFormatProvider)SPILocaleProviderAdapter.getImpl(this.map, locale);
        }

        @Override
        public Locale[] getAvailableLocales() {
            return this.map.keySet().toArray(new Locale[0]);
        }

        @Override
        public boolean isSupportedLocale(Locale locale) {
            return this.map.containsKey(locale);
        }

        @Override
        public DateFormat getTimeInstance(int n, Locale locale) {
            DateFormatProvider dateFormatProvider = this.getImpl(locale);
            assert (dateFormatProvider != null);
            return dateFormatProvider.getTimeInstance(n, locale);
        }

        @Override
        public DateFormat getDateInstance(int n, Locale locale) {
            DateFormatProvider dateFormatProvider = this.getImpl(locale);
            assert (dateFormatProvider != null);
            return dateFormatProvider.getDateInstance(n, locale);
        }

        @Override
        public DateFormat getDateTimeInstance(int n, int n2, Locale locale) {
            DateFormatProvider dateFormatProvider = this.getImpl(locale);
            assert (dateFormatProvider != null);
            return dateFormatProvider.getDateTimeInstance(n, n2, locale);
        }
    }

    static class CollatorProviderDelegate
    extends CollatorProvider
    implements Delegate<CollatorProvider> {
        private ConcurrentMap<Locale, CollatorProvider> map = new ConcurrentHashMap<Locale, CollatorProvider>();

        CollatorProviderDelegate() {
        }

        @Override
        public void addImpl(CollatorProvider collatorProvider) {
            for (Locale locale : collatorProvider.getAvailableLocales()) {
                this.map.putIfAbsent(locale, collatorProvider);
            }
        }

        @Override
        public CollatorProvider getImpl(Locale locale) {
            return (CollatorProvider)SPILocaleProviderAdapter.getImpl(this.map, locale);
        }

        @Override
        public Locale[] getAvailableLocales() {
            return this.map.keySet().toArray(new Locale[0]);
        }

        @Override
        public boolean isSupportedLocale(Locale locale) {
            return this.map.containsKey(locale);
        }

        @Override
        public Collator getInstance(Locale locale) {
            CollatorProvider collatorProvider = this.getImpl(locale);
            assert (collatorProvider != null);
            return collatorProvider.getInstance(locale);
        }
    }

    static class BreakIteratorProviderDelegate
    extends BreakIteratorProvider
    implements Delegate<BreakIteratorProvider> {
        private ConcurrentMap<Locale, BreakIteratorProvider> map = new ConcurrentHashMap<Locale, BreakIteratorProvider>();

        BreakIteratorProviderDelegate() {
        }

        @Override
        public void addImpl(BreakIteratorProvider breakIteratorProvider) {
            for (Locale locale : breakIteratorProvider.getAvailableLocales()) {
                this.map.putIfAbsent(locale, breakIteratorProvider);
            }
        }

        @Override
        public BreakIteratorProvider getImpl(Locale locale) {
            return (BreakIteratorProvider)SPILocaleProviderAdapter.getImpl(this.map, locale);
        }

        @Override
        public Locale[] getAvailableLocales() {
            return this.map.keySet().toArray(new Locale[0]);
        }

        @Override
        public boolean isSupportedLocale(Locale locale) {
            return this.map.containsKey(locale);
        }

        @Override
        public BreakIterator getWordInstance(Locale locale) {
            BreakIteratorProvider breakIteratorProvider = this.getImpl(locale);
            assert (breakIteratorProvider != null);
            return breakIteratorProvider.getWordInstance(locale);
        }

        @Override
        public BreakIterator getLineInstance(Locale locale) {
            BreakIteratorProvider breakIteratorProvider = this.getImpl(locale);
            assert (breakIteratorProvider != null);
            return breakIteratorProvider.getLineInstance(locale);
        }

        @Override
        public BreakIterator getCharacterInstance(Locale locale) {
            BreakIteratorProvider breakIteratorProvider = this.getImpl(locale);
            assert (breakIteratorProvider != null);
            return breakIteratorProvider.getCharacterInstance(locale);
        }

        @Override
        public BreakIterator getSentenceInstance(Locale locale) {
            BreakIteratorProvider breakIteratorProvider = this.getImpl(locale);
            assert (breakIteratorProvider != null);
            return breakIteratorProvider.getSentenceInstance(locale);
        }
    }

    static interface Delegate<P extends LocaleServiceProvider> {
        public void addImpl(P var1);

        public P getImpl(Locale var1);
    }
}

