/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.controlcenter.notification.util;

import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.get.GetResponse;
import org.opensearch.client.node.NodeClient;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.tasks.TaskId;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.indexmanagement.controlcenter.notification.LRONConfigResponse;
import org.opensearch.indexmanagement.controlcenter.notification.model.LRONConfig;
import org.opensearch.indexmanagement.opensearchapi.OpenSearchExtensionsKt;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000B\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u001e\u0010\u000b\u001a\u00020\u00012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u0001\u001a,\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00012\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017\u001a\u001e\u0010\u0019\u001a\u00020\u00042\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u0001\u001a\u0010\u0010\u001a\u001a\u00020\u00102\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001\u001a\u001a\u0010\u001b\u001a\u00020\u00102\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001c"}, d2={"DEFAULT_LRON_CONFIG_SORT_FIELD", "", "LRON_DOC_ID_PREFIX", "PRIORITY_DEFAULT_ACTION", "", "PRIORITY_TASK_ID", "WITH_PRIORITY", "supportedActions", "", "getSupportedActions", "()Ljava/util/Set;", "getDocID", "taskId", "Lorg/opensearch/core/tasks/TaskId;", "actionName", "getLRONConfigAndParse", "", "client", "Lorg/opensearch/client/node/NodeClient;", "docId", "xContentRegistry", "Lorg/opensearch/core/xcontent/NamedXContentRegistry;", "actionListener", "Lorg/opensearch/core/action/ActionListener;", "Lorg/opensearch/indexmanagement/controlcenter/notification/LRONConfigResponse;", "getPriority", "validateActionName", "validateTaskIdAndActionName", "opensearch-index-management"})
@JvmName(name="LRONUtils")
@SourceDebugExtension(value={"SMAP\nLRONUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LRONUtils.kt\norg/opensearch/indexmanagement/controlcenter/notification/util/LRONUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,111:1\n1#2:112\n*E\n"})
public final class LRONUtils {
    @NotNull
    public static final String LRON_DOC_ID_PREFIX = "LRON:";
    @NotNull
    public static final String WITH_PRIORITY = "with_priority";
    public static final int PRIORITY_TASK_ID = 200;
    public static final int PRIORITY_DEFAULT_ACTION = 100;
    @NotNull
    public static final String DEFAULT_LRON_CONFIG_SORT_FIELD = "lron_config.priority";
    @NotNull
    private static final Set<String> supportedActions;

    @NotNull
    public static final Set<String> getSupportedActions() {
        return supportedActions;
    }

    public static final void validateTaskIdAndActionName(@Nullable TaskId taskId, @Nullable String actionName) {
        if (!(actionName != null || taskId != null)) {
            boolean bl = false;
            String string = "LRONConfig must contain taskID or actionName";
            throw new IllegalArgumentException(string.toString());
        }
        LRONUtils.validateActionName(actionName);
    }

    public static final void validateActionName(@Nullable String actionName) {
        if (actionName == null) {
            return;
        }
        if (!supportedActions.contains(actionName)) {
            boolean bl = false;
            String string = "Invalid action name. All supported actions: " + supportedActions;
            throw new IllegalArgumentException(string.toString());
        }
    }

    public static final int getPriority(@Nullable TaskId taskId, @Nullable String actionName) {
        LRONUtils.validateTaskIdAndActionName(taskId, actionName);
        return taskId != null ? 200 : 100;
    }

    public static /* synthetic */ int getPriority$default(TaskId taskId, String string, int n, Object object) {
        if ((n & 1) != 0) {
            taskId = null;
        }
        if ((n & 2) != 0) {
            string = null;
        }
        return LRONUtils.getPriority(taskId, string);
    }

    @NotNull
    public static final String getDocID(@Nullable TaskId taskId, @Nullable String actionName) {
        LRONUtils.validateTaskIdAndActionName(taskId, actionName);
        Object object = taskId;
        if (object == null || (object = object.toString()) == null) {
            object = actionName;
        }
        Object id2 = object;
        return LRON_DOC_ID_PREFIX + (String)id2;
    }

    public static /* synthetic */ String getDocID$default(TaskId taskId, String string, int n, Object object) {
        if ((n & 1) != 0) {
            taskId = null;
        }
        if ((n & 2) != 0) {
            string = null;
        }
        return LRONUtils.getDocID(taskId, string);
    }

    public static final void getLRONConfigAndParse(@NotNull NodeClient client, @NotNull String docId2, @NotNull NamedXContentRegistry xContentRegistry, @NotNull ActionListener<LRONConfigResponse> actionListener) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)docId2, (String)"docId");
        Intrinsics.checkNotNullParameter((Object)xContentRegistry, (String)"xContentRegistry");
        Intrinsics.checkNotNullParameter(actionListener, (String)"actionListener");
        GetRequest getRequest = new GetRequest(".opensearch-control-center", docId2);
        client.get(getRequest, (ActionListener)new ActionListener<GetResponse>(actionListener, docId2, xContentRegistry){
            final /* synthetic */ ActionListener<LRONConfigResponse> $actionListener;
            final /* synthetic */ String $docId;
            final /* synthetic */ NamedXContentRegistry $xContentRegistry;
            {
                this.$actionListener = $actionListener;
                this.$docId = $docId;
                this.$xContentRegistry = $xContentRegistry;
            }

            public void onResponse(@NotNull GetResponse response2) {
                Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                if (!response2.isExists()) {
                    this.$actionListener.onFailure((Exception)((Object)new OpenSearchStatusException("lronConfig " + this.$docId + " not found", RestStatus.NOT_FOUND, new Object[0])));
                    return;
                }
                LRONConfig lronConfig2 = null;
                try {
                    lronConfig2 = (LRONConfig)OpenSearchExtensionsKt.parseFromGetResponse(response2, this.$xContentRegistry, (Function4)new Function4<XContentParser, String, Long, Long, LRONConfig>((Object)LRONConfig.Companion){

                        @NotNull
                        public final LRONConfig invoke(@NotNull XContentParser p0, @NotNull String p1, long p2, long p3) {
                            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                            Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                            return ((LRONConfig.Companion)this.receiver).parse(p0, p1, p2, p3);
                        }
                    });
                }
                catch (IllegalArgumentException e) {
                    this.$actionListener.onFailure((Exception)e);
                    return;
                }
                String string = response2.getId();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"response.id");
                this.$actionListener.onResponse((Object)((Object)new LRONConfigResponse(string, lronConfig2)));
            }

            public void onFailure(@NotNull Exception t) {
                Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                this.$actionListener.onFailure(t);
            }
        });
    }

    static {
        Object[] objectArray = new String[]{"indices:data/write/reindex", "indices:admin/resize", "indices:admin/forcemerge", "indices:admin/open"};
        supportedActions = SetsKt.setOf((Object[])objectArray);
    }
}

