/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.search;

import java.util.Set;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.util.CollectionFactory;
import org.semanticweb.owlapi.util.OWLAxiomVisitorExAdapter;

class EquivalentVisitor<C extends OWLObject>
extends OWLAxiomVisitorExAdapter<Set<C>> {
    private final boolean equiv;

    EquivalentVisitor(boolean equiv) {
        super(CollectionFactory.emptySet());
        this.equiv = equiv;
    }

    @Override
    @Nonnull
    public Set<C> visit(@Nonnull OWLEquivalentClassesAxiom axiom) {
        if (this.equiv) {
            return axiom.getClassExpressions();
        }
        return (Set)this.doDefault(axiom);
    }

    @Override
    @Nonnull
    public Set<C> visit(@Nonnull OWLEquivalentDataPropertiesAxiom axiom) {
        if (this.equiv) {
            return axiom.getProperties();
        }
        return (Set)this.doDefault(axiom);
    }

    @Override
    @Nonnull
    public Set<C> visit(@Nonnull OWLEquivalentObjectPropertiesAxiom axiom) {
        if (this.equiv) {
            return axiom.getProperties();
        }
        return (Set)this.doDefault(axiom);
    }

    @Override
    @Nonnull
    public Set<C> visit(@Nonnull OWLDifferentIndividualsAxiom axiom) {
        if (!this.equiv) {
            return axiom.getIndividuals();
        }
        return (Set)this.doDefault(axiom);
    }

    @Override
    @Nonnull
    public Set<C> visit(@Nonnull OWLSameIndividualAxiom axiom) {
        if (this.equiv) {
            return axiom.getIndividuals();
        }
        return (Set)this.doDefault(axiom);
    }

    @Override
    @Nonnull
    public Set<C> visit(@Nonnull OWLDisjointClassesAxiom axiom) {
        if (!this.equiv) {
            return axiom.getClassExpressions();
        }
        return (Set)this.doDefault(axiom);
    }

    @Override
    @Nonnull
    public Set<C> visit(@Nonnull OWLDisjointDataPropertiesAxiom axiom) {
        if (!this.equiv) {
            return axiom.getProperties();
        }
        return (Set)this.doDefault(axiom);
    }

    @Override
    @Nonnull
    public Set<C> visit(@Nonnull OWLDisjointObjectPropertiesAxiom axiom) {
        if (!this.equiv) {
            return axiom.getProperties();
        }
        return (Set)this.doDefault(axiom);
    }
}

