/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.html;

import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXParserListener;
import com.dickimawbooks.texparserlib.TextualContentCommand;
import com.dickimawbooks.texparserlib.Writeable;
import com.dickimawbooks.texparserlib.generic.DefaultTeXParserListener;
import com.dickimawbooks.texparserlib.html.EndElement;
import com.dickimawbooks.texparserlib.html.L2HConverter;
import com.dickimawbooks.texparserlib.html.StartElement;
import com.dickimawbooks.texparserlib.latex.AlignHStyle;
import com.dickimawbooks.texparserlib.latex.AlignRow;
import com.dickimawbooks.texparserlib.latex.LaTeXParserListener;
import com.dickimawbooks.texparserlib.latex.Tabular;
import java.io.IOException;
import java.util.Collection;

public class L2HLongTable
extends Tabular {
    protected AlignHStyle horizontalAlignment = AlignHStyle.CENTER;
    protected String id = null;

    public L2HLongTable() {
        this("longtable");
    }

    public L2HLongTable(String string) {
        super(string);
    }

    @Override
    public Object clone() {
        return new L2HLongTable(this.getName());
    }

    @Override
    protected void startTabular(TeXParser teXParser, TeXObjectList teXObjectList, int n, TeXObject teXObject) throws IOException {
        teXParser.startGroup();
        super.startTabular(teXParser, teXObjectList, n, teXObject);
        Writeable writeable = teXParser.getListener().getWriteable();
        String string = "longtable-";
        switch (this.horizontalAlignment) {
            case LEFT: {
                string = string + "l";
                break;
            }
            case RIGHT: {
                string = string + "r";
                break;
            }
            case CENTER: {
                string = string + "c";
            }
        }
        if (this.id == null) {
            writeable.writeliteralln(String.format("<table class=\"%s\">", string));
        } else {
            writeable.writeliteralln(String.format("<table id=\"%s\" class=\"%s\">", this.id, string));
        }
    }

    protected void findLabel(TeXObjectList teXObjectList, TeXParser teXParser) throws IOException {
        TeXObjectList teXObjectList2 = teXParser.getListener().createStack();
        while (!teXObjectList.isEmpty()) {
            TeXObject teXObject = teXObjectList.popStack(teXParser);
            if (teXObject instanceof ControlSequence && ((ControlSequence)teXObject).getName().equals("label")) {
                this.id = this.popLabelString(teXParser, teXObjectList);
                continue;
            }
            if (teXObject instanceof TeXObjectList) {
                this.findLabel((TeXObjectList)teXObject, teXParser);
                teXObjectList2.add(teXObject);
                continue;
            }
            teXObjectList2.add(teXObject);
        }
        teXObjectList.addAll(teXObjectList2);
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        Object object;
        Object object2;
        String string = this.popOptLabelString(teXParser, teXObjectList);
        this.horizontalAlignment = AlignHStyle.CENTER;
        if (string != null) {
            if ((string = string.trim()).equals("l")) {
                this.horizontalAlignment = AlignHStyle.LEFT;
            } else if (string.equals("c")) {
                this.horizontalAlignment = AlignHStyle.CENTER;
            } else if (string.equals("r")) {
                this.horizontalAlignment = AlignHStyle.RIGHT;
            }
        }
        TeXObject teXObject = this.popArgExpandFully(teXParser, teXObjectList);
        this.id = null;
        TeXObject teXObject2 = null;
        TeXObject teXObject3 = null;
        TeXObject teXObject4 = null;
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = true;
        String string2 = null;
        String string3 = null;
        TeXObjectList teXObjectList2 = null;
        TeXObjectList teXObjectList3 = null;
        Collection collection = null;
        TeXObjectList teXObjectList4 = null;
        TeXObjectList teXObjectList5 = teXParser.getListener().createStack();
        boolean bl4 = false;
        while (!bl4) {
            object2 = teXObjectList.popStack(teXParser);
            boolean bl5 = false;
            if (object2 instanceof TeXObjectList && ((TeXObjectList)object2).isStack()) {
                teXObjectList.push((TeXObject)object2, true);
                object2 = teXObjectList.popStack(teXParser);
            }
            if (object2 instanceof ControlSequence) {
                object = ((ControlSequence)object2).getName();
                if (((String)object).equals("endhead")) {
                    if (teXObject2 != null) {
                        teXObject3 = teXObject2;
                        bl2 = bl;
                        teXObject2 = null;
                    }
                    if (this.id != null) {
                        string2 = this.id;
                        this.id = null;
                    }
                    teXObjectList3 = teXObjectList5;
                    teXObjectList5 = teXParser.getListener().createStack();
                    bl5 = true;
                } else if (((String)object).equals("endfirsthead")) {
                    if (teXObject2 != null) {
                        teXObject4 = teXObject2;
                        bl3 = bl;
                        teXObject2 = null;
                    }
                    if (this.id != null) {
                        string3 = this.id;
                        this.id = null;
                    }
                    teXObjectList2 = teXObjectList5;
                    teXObjectList5 = teXParser.getListener().createStack();
                    bl5 = true;
                } else if (((String)object).equals("endfoot")) {
                    teXObjectList4 = teXObjectList5;
                    teXObjectList5 = teXParser.getListener().createStack();
                    bl5 = true;
                } else if (((String)object).equals("endlastfoot")) {
                    teXObjectList4 = teXObjectList5;
                    teXObjectList5 = teXParser.getListener().createStack();
                    bl5 = true;
                } else if (((String)object).equals("label") && this.id == null) {
                    this.id = this.popLabelString(teXParser, teXObjectList);
                    bl5 = true;
                } else if (((String)object).equals("caption")) {
                    if (teXObject2 == null) {
                        bl = this.popModifier(teXParser, teXObjectList, 42) == -1;
                        this.popOptArg(teXParser, teXObjectList);
                        teXObject2 = this.popArg(teXParser, teXObjectList);
                        if (teXObject2 instanceof TeXObjectList) {
                            this.findLabel((TeXObjectList)teXObject2, teXParser);
                        }
                        bl5 = true;
                    }
                } else if (((String)object).equals("end")) {
                    String string4 = this.popLabelString(teXParser, teXObjectList);
                    bl5 = true;
                    if (string4.equals(this.getName())) {
                        bl4 = true;
                    }
                    teXObjectList5.add((TeXObject)object2);
                    teXObjectList5.add(teXParser.getListener().createGroup(string4));
                }
            }
            if (bl5) continue;
            teXObjectList5.add((TeXObject)object2);
        }
        if (collection != null) {
            teXObjectList5.addAll(collection);
        } else if (teXObjectList4 != null) {
            teXObjectList5.addAll(teXObjectList4);
        }
        if (teXObjectList2 != null) {
            teXObjectList5.addAll(0, teXObjectList2);
            this.id = string3;
        } else if (teXObjectList3 != null) {
            teXObjectList5.addAll(0, teXObjectList3);
            this.id = string2;
        }
        if (teXObject4 != null) {
            teXObject2 = teXObject4;
            bl = bl3;
        } else if (teXObject3 != null) {
            teXObject2 = teXObject3;
            bl = bl2;
        }
        teXParser.putControlSequence(true, new TextualContentCommand("@captype", "table"));
        this.startTabular(teXParser, teXObjectList, -1, teXObject);
        if (teXObject2 != null) {
            object2 = (L2HConverter)teXParser.getListener();
            TeXObjectList teXObjectList6 = ((DefaultTeXParserListener)object2).createStack();
            teXObjectList6.add(new StartElement("caption"));
            if (bl) {
                ((LaTeXParserListener)object2).stepcounter("table");
                teXObjectList6.add(((TeXParserListener)object2).getControlSequence("@makecaption"));
                object = ((DefaultTeXParserListener)object2).createGroup();
                teXObjectList6.add((TeXObject)object);
                ((TeXObjectList)object).add(((TeXParserListener)object2).getControlSequence("tablename"));
                ((TeXObjectList)object).add(((TeXParserListener)object2).getControlSequence("nobreakspace"));
                ((TeXObjectList)object).add(((TeXParserListener)object2).getControlSequence("thetable"));
                ((TeXObjectList)object).add(((TeXParserListener)object2).getControlSequence("space"));
                object = ((DefaultTeXParserListener)object2).createGroup();
                teXObjectList6.add((TeXObject)object);
                ((TeXObjectList)object).add(teXObject2, true);
            } else {
                teXObjectList6.add(teXObject2, true);
            }
            teXObjectList6.add(new EndElement("caption"));
            if (teXParser == teXObjectList) {
                teXObjectList6.process(teXParser);
            } else {
                teXObjectList6.process(teXParser, teXObjectList);
            }
        }
        teXObjectList.push(teXObjectList5, true);
        object2 = ((LaTeXParserListener)teXParser.getListener()).createAlignRow(teXObjectList);
        if (teXParser == teXObjectList) {
            ((AlignRow)object2).process(teXParser);
        } else {
            ((AlignRow)object2).process(teXParser, teXObjectList);
        }
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        this.process(teXParser, teXParser);
    }

    @Override
    public void end(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        Writeable writeable = teXParser.getListener().getWriteable();
        writeable.writeliteralln("</table>");
        super.end(teXParser, teXObjectList);
        teXParser.endGroup();
    }
}

