/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.rollup;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineName;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.SupervisorKt;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.bulk.BackoffPolicy;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.client.Client;
import org.opensearch.client.OpenSearchClient;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.indexmanagement.indexstatemanagement.SkipExecution;
import org.opensearch.indexmanagement.opensearchapi.IndexManagementSecurityContext;
import org.opensearch.indexmanagement.opensearchapi.OpenSearchExtensionsKt;
import org.opensearch.indexmanagement.rollup.MetadataResult;
import org.opensearch.indexmanagement.rollup.RollupIndexer;
import org.opensearch.indexmanagement.rollup.RollupJobResult;
import org.opensearch.indexmanagement.rollup.RollupMapperService;
import org.opensearch.indexmanagement.rollup.RollupMetadataException;
import org.opensearch.indexmanagement.rollup.RollupMetadataService;
import org.opensearch.indexmanagement.rollup.RollupRunner;
import org.opensearch.indexmanagement.rollup.RollupSearchService;
import org.opensearch.indexmanagement.rollup.action.index.IndexRollupAction;
import org.opensearch.indexmanagement.rollup.action.index.IndexRollupRequest;
import org.opensearch.indexmanagement.rollup.action.index.IndexRollupResponse;
import org.opensearch.indexmanagement.rollup.model.Rollup;
import org.opensearch.indexmanagement.rollup.model.RollupJobValidationResult;
import org.opensearch.indexmanagement.rollup.model.RollupMetadata;
import org.opensearch.indexmanagement.util.JobSchedulerUtilsKt;
import org.opensearch.jobscheduler.spi.JobExecutionContext;
import org.opensearch.jobscheduler.spi.LockModel;
import org.opensearch.jobscheduler.spi.ScheduledJobParameter;
import org.opensearch.jobscheduler.spi.ScheduledJobRunner;
import org.opensearch.script.ScriptService;
import org.opensearch.threadpool.ThreadPool;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00ac\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J!\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010)J\u0019\u0010*\u001a\u00020+2\u0006\u0010%\u001a\u00020&H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010,J\u000e\u0010-\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010.\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010/\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\fJ\u0006\u00100\u001a\u00020\u0000J\u000e\u00101\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u00102\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u00103\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u00104\u001a\u00020\u00002\u0006\u0010!\u001a\u00020\"J\u000e\u00105\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u00106\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u001aJ\u000e\u00107\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u001eJ\u000e\u00108\u001a\u00020\u00002\u0006\u0010\u001f\u001a\u00020 J\u0018\u00109\u001a\u00020:2\u0006\u0010%\u001a\u00020;2\u0006\u0010<\u001a\u00020=H\u0016J)\u0010>\u001a\u00020:2\u0006\u0010%\u001a\u00020&2\u0006\u0010<\u001a\u00020=2\u0006\u0010?\u001a\u00020@H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010AJ-\u0010B\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010C\u001a\u00020D2\n\b\u0002\u0010E\u001a\u0004\u0018\u00010(H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010FJ!\u0010G\u001a\u00020H2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010)R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u0012\u0010\r\u001a\u00020\u000eX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0016\u0010\u0011\u001a\n \u0006*\u0004\u0018\u00010\u00120\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082.\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006I"}, d2={"Lorg/opensearch/indexmanagement/rollup/RollupRunner;", "Lorg/opensearch/jobscheduler/spi/ScheduledJobRunner;", "Lkotlinx/coroutines/CoroutineScope;", "()V", "backoffPolicy", "Lorg/opensearch/action/bulk/BackoffPolicy;", "kotlin.jvm.PlatformType", "client", "Lorg/opensearch/client/Client;", "clusterConfigurationProvider", "Lorg/opensearch/indexmanagement/indexstatemanagement/SkipExecution;", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "coroutineContext", "Lkotlin/coroutines/CoroutineContext;", "getCoroutineContext", "()Lkotlin/coroutines/CoroutineContext;", "logger", "Lorg/apache/logging/log4j/Logger;", "rollupIndexer", "Lorg/opensearch/indexmanagement/rollup/RollupIndexer;", "rollupMapperService", "Lorg/opensearch/indexmanagement/rollup/RollupMapperService;", "rollupMetadataService", "Lorg/opensearch/indexmanagement/rollup/RollupMetadataService;", "rollupSearchService", "Lorg/opensearch/indexmanagement/rollup/RollupSearchService;", "scriptService", "Lorg/opensearch/script/ScriptService;", "settings", "Lorg/opensearch/common/settings/Settings;", "threadPool", "Lorg/opensearch/threadpool/ThreadPool;", "xContentRegistry", "Lorg/opensearch/core/xcontent/NamedXContentRegistry;", "disableJob", "", "job", "Lorg/opensearch/indexmanagement/rollup/model/Rollup;", "metadata", "Lorg/opensearch/indexmanagement/rollup/model/RollupMetadata;", "(Lorg/opensearch/indexmanagement/rollup/model/Rollup;Lorg/opensearch/indexmanagement/rollup/model/RollupMetadata;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "isJobValid", "Lorg/opensearch/indexmanagement/rollup/model/RollupJobValidationResult;", "(Lorg/opensearch/indexmanagement/rollup/model/Rollup;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "registerClient", "registerClusterConfigurationProvider", "registerClusterService", "registerConsumers", "registerIndexer", "registerMapperService", "registerMetadataServices", "registerNamedXContentRegistry", "registerScriptService", "registerSearcher", "registerSettings", "registerThreadPool", "runJob", "", "Lorg/opensearch/jobscheduler/spi/ScheduledJobParameter;", "context", "Lorg/opensearch/jobscheduler/spi/JobExecutionContext;", "runRollupJob", "lock", "Lorg/opensearch/jobscheduler/spi/LockModel;", "(Lorg/opensearch/indexmanagement/rollup/model/Rollup;Lorg/opensearch/jobscheduler/spi/JobExecutionContext;Lorg/opensearch/jobscheduler/spi/LockModel;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "setFailedMetadataAndDisableJob", "reason", "", "existingMetadata", "(Lorg/opensearch/indexmanagement/rollup/model/Rollup;Ljava/lang/String;Lorg/opensearch/indexmanagement/rollup/model/RollupMetadata;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "updateRollupJob", "Lorg/opensearch/indexmanagement/rollup/RollupJobResult;", "opensearch-index-management"})
public final class RollupRunner
implements ScheduledJobRunner,
CoroutineScope {
    @NotNull
    public static final RollupRunner INSTANCE = new RollupRunner();
    private final /* synthetic */ CoroutineScope $$delegate_0;
    private static final Logger logger = LogManager.getLogger(INSTANCE.getClass());
    private static final BackoffPolicy backoffPolicy = BackoffPolicy.exponentialBackoff((TimeValue)TimeValue.timeValueMillis((long)1000L), (int)3);
    private static ClusterService clusterService;
    private static Client client;
    private static NamedXContentRegistry xContentRegistry;
    private static ScriptService scriptService;
    private static Settings settings;
    private static ThreadPool threadPool;
    private static RollupMapperService rollupMapperService;
    private static RollupIndexer rollupIndexer;
    private static RollupSearchService rollupSearchService;
    private static RollupMetadataService rollupMetadataService;
    private static SkipExecution clusterConfigurationProvider;

    private RollupRunner() {
        this.$$delegate_0 = CoroutineScopeKt.CoroutineScope((CoroutineContext)SupervisorKt.SupervisorJob$default(null, (int)1, null).plus((CoroutineContext)Dispatchers.getDefault()).plus((CoroutineContext)new CoroutineName("RollupRunner")));
    }

    @NotNull
    public CoroutineContext getCoroutineContext() {
        return this.$$delegate_0.getCoroutineContext();
    }

    @NotNull
    public final RollupRunner registerClusterService(@NotNull ClusterService clusterService) {
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        RollupRunner.clusterService = clusterService;
        return this;
    }

    @NotNull
    public final RollupRunner registerClient(@NotNull Client client) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        RollupRunner.client = client;
        return this;
    }

    @NotNull
    public final RollupRunner registerNamedXContentRegistry(@NotNull NamedXContentRegistry xContentRegistry) {
        Intrinsics.checkNotNullParameter((Object)xContentRegistry, (String)"xContentRegistry");
        RollupRunner.xContentRegistry = xContentRegistry;
        return this;
    }

    @NotNull
    public final RollupRunner registerScriptService(@NotNull ScriptService scriptService) {
        Intrinsics.checkNotNullParameter((Object)scriptService, (String)"scriptService");
        RollupRunner.scriptService = scriptService;
        return this;
    }

    @NotNull
    public final RollupRunner registerSettings(@NotNull Settings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        RollupRunner.settings = settings;
        return this;
    }

    @NotNull
    public final RollupRunner registerThreadPool(@NotNull ThreadPool threadPool) {
        Intrinsics.checkNotNullParameter((Object)threadPool, (String)"threadPool");
        RollupRunner.threadPool = threadPool;
        return this;
    }

    @NotNull
    public final RollupRunner registerMapperService(@NotNull RollupMapperService rollupMapperService) {
        Intrinsics.checkNotNullParameter((Object)rollupMapperService, (String)"rollupMapperService");
        RollupRunner.rollupMapperService = rollupMapperService;
        return this;
    }

    @NotNull
    public final RollupRunner registerIndexer(@NotNull RollupIndexer rollupIndexer) {
        Intrinsics.checkNotNullParameter((Object)rollupIndexer, (String)"rollupIndexer");
        RollupRunner.rollupIndexer = rollupIndexer;
        return this;
    }

    @NotNull
    public final RollupRunner registerSearcher(@NotNull RollupSearchService rollupSearchService) {
        Intrinsics.checkNotNullParameter((Object)rollupSearchService, (String)"rollupSearchService");
        RollupRunner.rollupSearchService = rollupSearchService;
        return this;
    }

    @NotNull
    public final RollupRunner registerMetadataServices(@NotNull RollupMetadataService rollupMetadataService) {
        Intrinsics.checkNotNullParameter((Object)rollupMetadataService, (String)"rollupMetadataService");
        RollupRunner.rollupMetadataService = rollupMetadataService;
        return this;
    }

    @NotNull
    public final RollupRunner registerClusterConfigurationProvider(@NotNull SkipExecution clusterConfigurationProvider) {
        Intrinsics.checkNotNullParameter((Object)clusterConfigurationProvider, (String)"clusterConfigurationProvider");
        RollupRunner.clusterConfigurationProvider = clusterConfigurationProvider;
        return this;
    }

    @NotNull
    public final RollupRunner registerConsumers() {
        return this;
    }

    public void runJob(@NotNull ScheduledJobParameter job, @NotNull JobExecutionContext context) {
        Intrinsics.checkNotNullParameter((Object)job, (String)"job");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!(job instanceof Rollup)) {
            throw new IllegalArgumentException("Invalid job type, found " + job.getClass().getSimpleName() + " with id: " + context.getJobId());
        }
        BuildersKt.launch$default((CoroutineScope)this, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(job, context, null){
            Object L$0;
            int label;
            final /* synthetic */ ScheduledJobParameter $job;
            final /* synthetic */ JobExecutionContext $context;
            {
                this.$job = $job;
                this.$context = $context;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var5_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        metadata = null;
                        if (((Rollup)this.$job).getMetadataID() == null) ** GOTO lbl37
                        v0 = RollupRunner.access$getRollupMetadataService$p();
                        if (v0 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"rollupMetadataService");
                            v0 = null;
                        }
                        this.label = 1;
                        v1 = v0.getExistingMetadata((Rollup)this.$job, (Continuation<? super MetadataResult>)((Continuation)this));
                        ** if (v1 != var5_2) goto lbl17
lbl16:
                        // 1 sources

                        return var5_2;
lbl17:
                        // 1 sources

                        ** GOTO lbl23
                    }
                    case 1: {
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
lbl23:
                            // 2 sources

                            if ((getMetadataResult = (MetadataResult)v1) instanceof MetadataResult.Success) {
                                v2 = ((MetadataResult.Success)getMetadataResult).getMetadata();
                            } else if (getMetadataResult instanceof MetadataResult.NoMetadata) {
                                v2 = null;
                            } else {
                                if (getMetadataResult instanceof MetadataResult.Failure) {
                                    throw new RollupMetadataException("Failed to get existing rollup metadata [" + ((Rollup)this.$job).getMetadataID() + "]", ((MetadataResult.Failure)getMetadataResult).getCause());
                                }
                                throw new NoWhenBranchMatchedException();
                            }
                            metadata = v2;
                        }
                        catch (RollupMetadataException e) {
                            RollupRunner.access$getLogger$p().error(e.getMessage(), e.getCause());
                            return Unit.INSTANCE;
                        }
lbl37:
                        // 2 sources

                        if ((v3 = RollupRunner.access$getRollupSearchService$p()) == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"rollupSearchService");
                            v3 = null;
                        }
                        if (!v3.shouldProcessRollup((Rollup)this.$job, metadata)) break;
                        v4 = RollupRunner.access$getBackoffPolicy$p();
                        Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"backoffPolicy");
                        this.label = 2;
                        v5 = JobSchedulerUtilsKt.acquireLockForScheduledJob(this.$job, this.$context, v4, (Continuation<? super LockModel>)((Continuation)this));
                        if (v5 == var5_2) {
                            return var5_2;
                        }
                        ** GOTO lbl51
                    }
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        v5 = $result;
lbl51:
                        // 2 sources

                        if ((lock = (LockModel)v5) != null) ** GOTO lbl54
                        RollupRunner.access$getLogger$p().debug("Could not acquire lock for " + ((Rollup)this.$job).getId());
                        ** GOTO lbl117
lbl54:
                        // 1 sources

                        this.L$0 = lock;
                        this.label = 3;
                        v6 = RollupRunner.access$runRollupJob(RollupRunner.INSTANCE, (Rollup)this.$job, this.$context, lock, (Continuation)this);
                        if (v6 == var5_2) {
                            return var5_2;
                        }
                        ** GOTO lbl64
                    }
                    case 3: {
                        lock = (LockModel)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v6 = $result;
lbl64:
                        // 2 sources

                        this.L$0 = null;
                        this.label = 4;
                        v7 = JobSchedulerUtilsKt.releaseLockForScheduledJob(this.$context, lock, (Continuation<? super Boolean>)((Continuation)this));
                        if (v7 == var5_2) {
                            return var5_2;
                        }
                        ** GOTO lbl117
                    }
                    case 4: {
                        ResultKt.throwOnFailure((Object)$result);
                        v7 = $result;
                        ** GOTO lbl117
                    }
                }
                if (!((Rollup)this.$job).isEnabled()) ** GOTO lbl117
                this.label = 5;
                v8 = RollupRunner.access$isJobValid(RollupRunner.INSTANCE, (Rollup)this.$job, (Continuation)this);
                if (v8 == var5_2) {
                    return var5_2;
                }
                ** GOTO lbl83
                {
                    case 5: {
                        ResultKt.throwOnFailure((Object)$result);
                        v8 = $result;
lbl83:
                        // 2 sources

                        if (!((jobValidity = (RollupJobValidationResult)v8) instanceof RollupJobValidationResult.Invalid)) ** GOTO lbl117
                        v9 = RollupRunner.access$getBackoffPolicy$p();
                        Intrinsics.checkNotNullExpressionValue((Object)v9, (String)"backoffPolicy");
                        this.L$0 = jobValidity;
                        this.label = 6;
                        v10 = JobSchedulerUtilsKt.acquireLockForScheduledJob(this.$job, this.$context, v9, (Continuation<? super LockModel>)((Continuation)this));
                        if (v10 == var5_2) {
                            return var5_2;
                        }
                        ** GOTO lbl96
                    }
                    case 6: {
                        jobValidity = (RollupJobValidationResult)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v10 = $result;
lbl96:
                        // 2 sources

                        if ((lock = (LockModel)v10) == null) ** GOTO lbl117
                        this.L$0 = lock;
                        this.label = 7;
                        v11 = RollupRunner.setFailedMetadataAndDisableJob$default(RollupRunner.INSTANCE, (Rollup)this.$job, ((RollupJobValidationResult.Invalid)jobValidity).getReason(), null, (Continuation)this, 4, null);
                        if (v11 == var5_2) {
                            return var5_2;
                        }
                        ** GOTO lbl107
                    }
                    case 7: {
                        lock = (LockModel)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v11 = $result;
lbl107:
                        // 2 sources

                        RollupRunner.access$getLogger$p().info("updating metadata service to disable the job [" + ((Rollup)this.$job).getId() + "]");
                        this.L$0 = null;
                        this.label = 8;
                        v12 = JobSchedulerUtilsKt.releaseLockForScheduledJob(this.$context, lock, (Continuation<? super Boolean>)((Continuation)this));
                        if (v12 == var5_2) {
                            return var5_2;
                        }
                        ** GOTO lbl117
                    }
                    case 8: {
                        ResultKt.throwOnFailure((Object)$result);
                        v12 = $result;
lbl117:
                        // 8 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    /*
     * Exception decompiling
     */
    private final Object runRollupJob(Rollup var1_1, JobExecutionContext var2_2, LockModel var3_3, Continuation<? super Unit> var4_4) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [22[SWITCH], 25[CASE]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Unable to fully structure code
     */
    private final Object updateRollupJob(Rollup var1_1, RollupMetadata var2_2, Continuation<? super RollupJobResult> var3_3) {
        if (!(var3_3 instanceof updateRollupJob.1)) ** GOTO lbl-1000
        var8_4 = var3_3;
        if ((var8_4.label & -2147483648) != 0) {
            var8_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ RollupRunner this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return RollupRunner.access$updateRollupJob(this.this$0, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var9_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = job.getId();
                v1 = RollupRunner.settings;
                if (v1 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
                    v1 = null;
                }
                if ((v2 = RollupRunner.threadPool) == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"threadPool");
                    v2 = null;
                }
                v3 = v2.getThreadContext();
                Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"threadPool.threadContext");
                $continuation.L$0 = job;
                $continuation.L$1 = metadata;
                $continuation.label = 1;
                v4 = OpenSearchExtensionsKt.withClosableContext(new IndexManagementSecurityContext(v0, v1, v3, null), (Function2)new Function2<CoroutineScope, Continuation<? super RollupJobResult.Success>, Object>(job, null){
                    int label;
                    final /* synthetic */ Rollup $job;
                    {
                        this.$job = $job;
                        super(2, $completion);
                    }

                    /*
                     * Unable to fully structure code
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object var1_1) {
                        var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)var1_1);
                                req = new IndexRollupRequest(this.$job, WriteRequest.RefreshPolicy.IMMEDIATE);
                                v0 = RollupRunner.access$getClient$p();
                                if (v0 == null) {
                                    Intrinsics.throwUninitializedPropertyAccessException((String)"client");
                                    v0 = null;
                                }
                                this.label = 1;
                                v1 = OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)v0, (Function2)new Function2<Client, ActionListener<IndexRollupResponse>, Unit>(req){
                                    final /* synthetic */ IndexRollupRequest $req;
                                    {
                                        this.$req = $req;
                                        super(2);
                                    }

                                    public final void invoke(@NotNull Client $this$suspendUntil, @NotNull ActionListener<IndexRollupResponse> it) {
                                        Intrinsics.checkNotNullParameter((Object)$this$suspendUntil, (String)"$this$suspendUntil");
                                        Intrinsics.checkNotNullParameter(it, (String)"it");
                                        $this$suspendUntil.execute((ActionType)IndexRollupAction.Companion.getINSTANCE(), (ActionRequest)this.$req, it);
                                    }
                                }, (Continuation)this);
                                if (v1 == var4_2) {
                                    return var4_2;
                                }
                                ** GOTO lbl18
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                v1 = $result;
lbl18:
                                // 2 sources

                                res = (IndexRollupResponse)v1;
                                return new RollupJobResult.Success(res.getRollup());
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super RollupJobResult.Success> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }, $continuation);
                ** if (v4 != var9_6) goto lbl30
lbl29:
                // 1 sources

                return var9_6;
lbl30:
                // 1 sources

                ** GOTO lbl38
            }
            case 1: {
                metadata = (RollupMetadata)$continuation.L$1;
                job = (Rollup)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v4 = $result;
lbl38:
                    // 2 sources

                    return v4;
                }
                catch (Exception e) {
                    errorMessage = "An error occurred when updating rollup job [" + job.getId() + "]";
                    v5 = RollupRunner.rollupMetadataService;
                    if (v5 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"rollupMetadataService");
                        v5 = null;
                    }
                    $continuation.L$0 = e;
                    $continuation.L$1 = errorMessage;
                    $continuation.label = 2;
                    v6 = v5.setFailedMetadata(job, (String)errorMessage, metadata, (Continuation<? super MetadataResult>)$continuation);
                    if (v6 == var9_6) {
                        return var9_6;
                    }
                    ** GOTO lbl57
                }
            }
            case 2: {
                errorMessage = (String)$continuation.L$1;
                e = (Exception)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v6 = $result;
lbl57:
                // 2 sources

                if (!((setFailedMetadataResult = (MetadataResult)v6) instanceof MetadataResult.Success)) {
                    if (setFailedMetadataResult instanceof MetadataResult.Failure) {
                        throw new RollupMetadataException(((MetadataResult.Failure)setFailedMetadataResult).getMessage(), ((MetadataResult.Failure)setFailedMetadataResult).getCause());
                    }
                    if (setFailedMetadataResult instanceof MetadataResult.NoMetadata) {
                        throw new RollupMetadataException("Unexpected state when updating metadata", null);
                    }
                    throw new NoWhenBranchMatchedException();
                }
                return new RollupJobResult.Failure((String)errorMessage, e);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final Object isJobValid(Rollup job, Continuation<? super RollupJobValidationResult> $completion) {
        ThreadPool threadPool;
        String string = job.getId();
        Settings settings = RollupRunner.settings;
        if (settings == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"settings");
            settings = null;
        }
        if ((threadPool = RollupRunner.threadPool) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"threadPool");
            threadPool = null;
        }
        ThreadContext threadContext = threadPool.getThreadContext();
        Intrinsics.checkNotNullExpressionValue((Object)threadContext, (String)"threadPool.threadContext");
        return OpenSearchExtensionsKt.withClosableContext(new IndexManagementSecurityContext(string, settings, threadContext, job.getUser()), (Function2)new Function2<CoroutineScope, Continuation<? super RollupJobValidationResult>, Object>(job, null){
            Object L$0;
            int label;
            final /* synthetic */ Rollup $job;
            {
                this.$job = $job;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        metadata = null;
                        if (this.$job.getMetadataID() == null) ** GOTO lbl30
                        RollupRunner.access$getLogger$p().debug("Fetching associated metadata for rollup job [" + this.$job.getId() + "]");
                        v0 = RollupRunner.access$getRollupMetadataService$p();
                        if (v0 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"rollupMetadataService");
                            v0 = null;
                        }
                        this.label = 1;
                        v1 = v0.getExistingMetadata(this.$job, (Continuation<? super MetadataResult>)((Continuation)this));
                        if (v1 == var4_2) {
                            return var4_2;
                        }
                        ** GOTO lbl20
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl20:
                        // 2 sources

                        if ((getMetadataResult = (MetadataResult)v1) instanceof MetadataResult.Success) {
                            v2 = ((MetadataResult.Success)getMetadataResult).getMetadata();
                        } else if (getMetadataResult instanceof MetadataResult.NoMetadata) {
                            v2 = null;
                        } else {
                            if (getMetadataResult instanceof MetadataResult.Failure) {
                                throw new RollupMetadataException("Failed to get existing rollup metadata [" + this.$job.getMetadataID() + "]", ((MetadataResult.Failure)getMetadataResult).getCause());
                            }
                            throw new NoWhenBranchMatchedException();
                        }
                        metadata = v2;
lbl30:
                        // 2 sources

                        RollupRunner.access$getLogger$p().debug("Validating source index [" + this.$job.getSourceIndex() + "] for rollup job [" + this.$job.getId() + "]");
                        v3 = RollupRunner.access$getRollupMapperService$p();
                        if (v3 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"rollupMapperService");
                            v3 = null;
                        }
                        this.L$0 = metadata;
                        this.label = 2;
                        v4 = v3.isSourceIndexValid(this.$job, (Continuation<? super RollupJobValidationResult>)((Continuation)this));
                        if (v4 == var4_2) {
                            return var4_2;
                        }
                        ** GOTO lbl45
                    }
                    case 2: {
                        metadata = (RollupMetadata)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v4 = $result;
lbl45:
                        // 2 sources

                        if (!((sourceIndexValidationResult = (RollupJobValidationResult)v4) instanceof RollupJobValidationResult.Valid)) {
                            return sourceIndexValidationResult;
                        }
                        if (metadata == null) break;
                        RollupRunner.access$getLogger$p().debug("Attempting to create/validate target index [" + this.$job.getTargetIndex() + "] for rollup job [" + this.$job.getId() + "]");
                        v5 = RollupRunner.access$getRollupMapperService$p();
                        if (v5 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"rollupMapperService");
                            v5 = null;
                        }
                        if ((v6 = RollupRunner.access$getClusterConfigurationProvider$p()) == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"clusterConfigurationProvider");
                            v6 = null;
                        }
                        this.L$0 = null;
                        this.label = 3;
                        v7 = v5.attemptCreateRollupTargetIndex(this.$job, v6.getHasLegacyPlugin(), (Continuation<? super RollupJobValidationResult>)((Continuation)this));
                        if (v7 == var4_2) {
                            return var4_2;
                        }
                        ** GOTO lbl65
                    }
                    case 3: {
                        ResultKt.throwOnFailure((Object)$result);
                        v7 = $result;
lbl65:
                        // 2 sources

                        return v7;
                    }
                }
                return RollupJobValidationResult.Valid.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super RollupJobValidationResult> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, $completion);
    }

    /*
     * Unable to fully structure code
     */
    private final Object setFailedMetadataAndDisableJob(Rollup var1_1, String var2_2, RollupMetadata var3_3, Continuation<? super Boolean> var4_4) {
        if (!(var4_4 instanceof setFailedMetadataAndDisableJob.1)) ** GOTO lbl-1000
        var8_5 = var4_4;
        if ((var8_5.label & -2147483648) != 0) {
            var8_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var4_4){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ RollupRunner this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return RollupRunner.access$setFailedMetadataAndDisableJob(this.this$0, null, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var9_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = RollupRunner.rollupMetadataService;
                if (v0 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"rollupMetadataService");
                    v0 = null;
                }
                $continuation.L$0 = this;
                $continuation.L$1 = job;
                $continuation.label = 1;
                v1 = v0.setFailedMetadata(job, (String)reason, (RollupMetadata)existingMetadata, (Continuation<? super MetadataResult>)$continuation);
                if (v1 == var9_7) {
                    return var9_7;
                }
                ** GOTO lbl28
            }
            case 1: {
                job = (Rollup)$continuation.L$1;
                this = (RollupRunner)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl28:
                // 2 sources

                if (!((setFailedMetadataResult = (MetadataResult)v1) instanceof MetadataResult.Success)) {
                    if (setFailedMetadataResult instanceof MetadataResult.Failure) {
                        throw new RollupMetadataException(((MetadataResult.Failure)setFailedMetadataResult).getMessage(), ((MetadataResult.Failure)setFailedMetadataResult).getCause());
                    }
                    if (setFailedMetadataResult instanceof MetadataResult.NoMetadata) {
                        throw new RollupMetadataException("Unexpected state when setting failed metadata", null);
                    }
                    throw new NoWhenBranchMatchedException();
                }
                updatedMetadata = ((MetadataResult.Success)setFailedMetadataResult).getMetadata();
                $continuation.L$0 = null;
                $continuation.L$1 = null;
                $continuation.label = 2;
                v2 = this.disableJob(job, updatedMetadata, (Continuation<? super Boolean>)$continuation);
                if (v2 == var9_7) {
                    return var9_7;
                }
                ** GOTO lbl45
            }
            case 2: {
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl45:
                // 2 sources

                return v2;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    static /* synthetic */ Object setFailedMetadataAndDisableJob$default(RollupRunner rollupRunner, Rollup rollup2, String string, RollupMetadata rollupMetadata, Continuation continuation, int n, Object object) {
        if ((n & 4) != 0) {
            rollupMetadata = null;
        }
        return rollupRunner.setFailedMetadataAndDisableJob(rollup2, string, rollupMetadata, (Continuation<? super Boolean>)continuation);
    }

    /*
     * Unable to fully structure code
     */
    private final Object disableJob(Rollup var1_1, RollupMetadata var2_2, Continuation<? super Boolean> var3_3) {
        if (!(var3_3 instanceof disableJob.1)) ** GOTO lbl-1000
        var7_4 = var3_3;
        if ((var7_4.label & -2147483648) != 0) {
            var7_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ RollupRunner this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return RollupRunner.access$disableJob(this.this$0, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var8_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (!Intrinsics.areEqual((Object)metadata.getId(), (Object)job.getMetadataID())) {
                    var5_7 = metadata.getId();
                    v0 = Rollup.copy$default(job, null, 0L, 0L, false, 0L, null, null, null, null, null, null, var5_7, null, 0, null, false, null, null, null, 522103, null);
                } else {
                    v0 = Rollup.copy$default(job, null, 0L, 0L, false, 0L, null, null, null, null, null, null, null, null, 0, null, false, null, null, null, 524151, null);
                }
                updatedRollupJob = v0;
                $continuation.L$0 = job;
                $continuation.label = 1;
                v1 = this.updateRollupJob(updatedRollupJob, (RollupMetadata)metadata, (Continuation<? super RollupJobResult>)$continuation);
                if (v1 == var8_6) {
                    return var8_6;
                }
                ** GOTO lbl28
            }
            case 1: {
                job = (Rollup)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl28:
                // 2 sources

                if ((updateRollupJobResult = (RollupJobResult)v1) instanceof RollupJobResult.Success) {
                    v2 = true;
                } else if (updateRollupJobResult instanceof RollupJobResult.Failure) {
                    RollupRunner.logger.error("Failed to disable rollup job [" + job.getId() + "]", (Throwable)((RollupJobResult.Failure)updateRollupJobResult).getCause());
                    v2 = false;
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                return Boxing.boxBoolean((boolean)v2);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static final /* synthetic */ RollupMetadataService access$getRollupMetadataService$p() {
        return rollupMetadataService;
    }

    public static final /* synthetic */ Logger access$getLogger$p() {
        return logger;
    }

    public static final /* synthetic */ RollupSearchService access$getRollupSearchService$p() {
        return rollupSearchService;
    }

    public static final /* synthetic */ BackoffPolicy access$getBackoffPolicy$p() {
        return backoffPolicy;
    }

    public static final /* synthetic */ Object access$runRollupJob(RollupRunner $this, Rollup job, JobExecutionContext context, LockModel lock2, Continuation $completion) {
        return $this.runRollupJob(job, context, lock2, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$isJobValid(RollupRunner $this, Rollup job, Continuation $completion) {
        return $this.isJobValid(job, (Continuation<? super RollupJobValidationResult>)$completion);
    }

    public static final /* synthetic */ RollupMapperService access$getRollupMapperService$p() {
        return rollupMapperService;
    }

    public static final /* synthetic */ SkipExecution access$getClusterConfigurationProvider$p() {
        return clusterConfigurationProvider;
    }

    public static final /* synthetic */ RollupIndexer access$getRollupIndexer$p() {
        return rollupIndexer;
    }

    public static final /* synthetic */ Client access$getClient$p() {
        return client;
    }

    public static final /* synthetic */ Object access$updateRollupJob(RollupRunner $this, Rollup job, RollupMetadata metadata2, Continuation $completion) {
        return $this.updateRollupJob(job, metadata2, (Continuation<? super RollupJobResult>)$completion);
    }

    public static final /* synthetic */ Object access$setFailedMetadataAndDisableJob(RollupRunner $this, Rollup job, String reason, RollupMetadata existingMetadata, Continuation $completion) {
        return $this.setFailedMetadataAndDisableJob(job, reason, existingMetadata, (Continuation<? super Boolean>)$completion);
    }

    public static final /* synthetic */ Object access$disableJob(RollupRunner $this, Rollup job, RollupMetadata metadata2, Continuation $completion) {
        return $this.disableJob(job, metadata2, (Continuation<? super Boolean>)$completion);
    }
}

