/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.expression.function;

import java.io.Serializable;
import java.time.Clock;
import java.time.Instant;
import java.time.ZoneId;
import lombok.Generated;

public class FunctionProperties
implements Serializable {
    private final Instant nowInstant;
    private final ZoneId currentZoneId;
    public static final FunctionProperties None = new FunctionProperties(){

        @Override
        public Clock getSystemClock() {
            throw new UnexpectedCallException();
        }

        @Override
        public Clock getQueryStartClock() {
            throw new UnexpectedCallException();
        }
    };

    public FunctionProperties() {
        this.nowInstant = Instant.now();
        this.currentZoneId = ZoneId.systemDefault();
    }

    public Clock getSystemClock() {
        return Clock.system(this.currentZoneId);
    }

    public Clock getQueryStartClock() {
        return Clock.fixed(this.nowInstant, this.currentZoneId);
    }

    @Generated
    public FunctionProperties(Instant nowInstant, ZoneId currentZoneId) {
        this.nowInstant = nowInstant;
        this.currentZoneId = currentZoneId;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FunctionProperties)) {
            return false;
        }
        FunctionProperties other = (FunctionProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Instant this$nowInstant = this.nowInstant;
        Instant other$nowInstant = other.nowInstant;
        if (this$nowInstant == null ? other$nowInstant != null : !((Object)this$nowInstant).equals(other$nowInstant)) {
            return false;
        }
        ZoneId this$currentZoneId = this.currentZoneId;
        ZoneId other$currentZoneId = other.currentZoneId;
        return !(this$currentZoneId == null ? other$currentZoneId != null : !((Object)this$currentZoneId).equals(other$currentZoneId));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FunctionProperties;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Instant $nowInstant = this.nowInstant;
        result = result * 59 + ($nowInstant == null ? 43 : ((Object)$nowInstant).hashCode());
        ZoneId $currentZoneId = this.currentZoneId;
        result = result * 59 + ($currentZoneId == null ? 43 : ((Object)$currentZoneId).hashCode());
        return result;
    }

    class UnexpectedCallException
    extends RuntimeException {
        public UnexpectedCallException() {
            super("FunctionProperties.None is a null object and not meant to be accessed.");
        }
    }
}

