"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TIME_INTERVAL_OPTIONS = exports.TIME_FIELD = exports.TIMESTAMP = exports.TAB_TITLE = exports.TAB_ID_TXT_PFX = exports.TAB_EVENT_TITLE = exports.TAB_EVENT_ID_TXT_PFX = exports.TAB_EVENT_ID = exports.TAB_CREATED_TYPE = exports.TAB_CHART_TITLE = exports.TAB_CHART_ID_TXT_PFX = exports.TAB_CHART_ID = exports.SPAN = exports.SIMILAR_VIZ_TYPES = exports.SELECTED_TIMESTAMP = exports.SELECTED_QUERY_TAB = exports.SELECTED_PATTERN_FIELD = exports.SELECTED_FIELDS = exports.SELECTED_DATE_RANGE = exports.SAVED_VISUALIZATION = exports.SAVED_QUERY = exports.SAVED_OBJECT_TYPE = exports.SAVED_OBJECT_ID = exports.ROW_DENSITIES = exports.REDUX_EXPL_SLICE_VISUALIZATION = exports.REDUX_EXPL_SLICE_SEARCH_META_DATA = exports.REDUX_EXPL_SLICE_QUERY_TABS = exports.REDUX_EXPL_SLICE_QUERY_RESULT = exports.REDUX_EXPL_SLICE_QUERIES = exports.REDUX_EXPL_SLICE_PATTERNS = exports.REDUX_EXPL_SLICE_FIELDS = exports.REDUX_EXPL_SLICE_COUNT_DISTRIBUTION = exports.REDIRECT_TAB = exports.RAW_QUERY = exports.QUERY_TAB_IDS = exports.QUERIED_FIELDS = exports.PPL_DEFAULT_PATTERN_REGEX_FILETER = exports.PLOTLY_PIE_COLUMN_NUMBER = exports.PLOTLY_GAUGE_COLUMN_NUMBER = exports.PIE_YAXIS_GAP = exports.PIE_XAXIS_GAP = exports.PATTERN_REGEX = exports.PATTERNS_REGEX = exports.PATTERNS_EXTRACTOR_REGEX = exports.PARENTFIELDS = exports.PAGE_SIZE = exports.OTEL_TRACE_ID = exports.OPEN_TELEMETRY_LOG_CORRELATION_LINK = exports.OLLY_QUERY_ASSISTANT = exports.NUMERICAL_TYPES = exports.NUMBER_INPUT_MIN_LIMIT = exports.NEW_TAB = exports.NEW_SELECTED_QUERY_TAB = exports.METRICS_SERIES_UNIT_SUBSTRING_LENGTH = exports.METRICS_REDUCE_VALUE_SIZE_PERCENTAGE = exports.METRICS_REDUCE_TITLE_SIZE_PERCENTAGE = exports.METRICS_REDUCE_SERIES_UNIT_SIZE_PERCENTAGE = exports.METRICS_GRID_SPACE_BETWEEN_Y_AXIS = exports.METRICS_GRID_SPACE_BETWEEN_X_AXIS = exports.METRICS_AXIS_MARGIN = exports.METRICS_ANNOTATION = exports.LOG_EXPLORER_BASE_PATH = exports.JAEGER_TRACE_ID = exports.INDEX = exports.HEADER_HEIGHT = exports.HAS_SAVED_TIMESTAMP = exports.GROUPBY = exports.GRID_PAGE_SIZES = exports.GRID_PAGE_RANGE_DISPLAY = exports.GRID_HEADER_COLUMN_MAX_WIDTH = exports.FINAL_QUERY = exports.FILTER_OPTIONS = exports.FILTERED_PATTERN = exports.EVENT_ANALYTICS_DOCUMENTATION_URL = exports.DISABLED_COLOUR = exports.DEFAULT_TIMESTAMP_COLUMN = exports.DEFAULT_SOURCE_COLUMN = exports.DEFAULT_PIE_CHART_PARAMETERS = exports.DEFAULT_METRICS_CHART_PARAMETERS = exports.DEFAULT_GAUGE_CHART_PARAMETERS = exports.DEFAULT_EMPTY_EXPLORER_FIELDS = exports.DEFAULT_DATETIME_STRING = exports.DEFAULT_COLUMNS = exports.DEFAULT_BAR_CHART_STYLES = exports.DEFAULT_AVAILABILITY_QUERY = exports.DATE_PICKER_FORMAT = exports.DATE_DISPLAY_FORMAT = exports.DATA_CONFIG_HINTS_INFO = exports.ConfigChartOptionsEnum = exports.CUSTOM_LABEL = exports.CREATE_TAB_PARAM_KEY = exports.CREATE_TAB_PARAM = exports.COLUMN_DEFAULT_MIN_WIDTH = exports.CHILDFIELD = exports.BREAKDOWNS = exports.AVAILABLE_FIELDS = exports.APP_ANALYTICS_TAB_ID_REGEX = exports.AGGREGATION_OPTIONS = exports.AGGREGATIONS = exports.ADD_BUTTON_TEXT = void 0;
exports.sampleLogPatternData = exports.VIZ_CONTAIN_XY_AXIS = exports.VALUEFIELD = exports.UNSELECTED_FIELDS = exports.UNITS_OF_MEASURE = exports.TYPE_TAB_MAPPING = void 0;
var _eui = require("@elastic/eui");
var _shared = require("./shared");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

// URLs
const EVENT_ANALYTICS_DOCUMENTATION_URL = exports.EVENT_ANALYTICS_DOCUMENTATION_URL = 'https://opensearch.org/docs/latest/observing-your-data/event-analytics/';
const OPEN_TELEMETRY_LOG_CORRELATION_LINK = exports.OPEN_TELEMETRY_LOG_CORRELATION_LINK = 'https://opentelemetry.io/docs/reference/specification/logs/overview/#log-correlation';
const LOG_EXPLORER_BASE_PATH = exports.LOG_EXPLORER_BASE_PATH = 'observability-logs#/explorer/';
const RAW_QUERY = exports.RAW_QUERY = 'rawQuery';
const FINAL_QUERY = exports.FINAL_QUERY = 'finalQuery';
const SELECTED_DATE_RANGE = exports.SELECTED_DATE_RANGE = 'selectedDateRange';
const INDEX = exports.INDEX = 'index';
const OLLY_QUERY_ASSISTANT = exports.OLLY_QUERY_ASSISTANT = 'ollyQueryAssistant';
const SELECTED_PATTERN_FIELD = exports.SELECTED_PATTERN_FIELD = 'selectedPatternField';
const PATTERN_REGEX = exports.PATTERN_REGEX = 'patternRegex';
const FILTERED_PATTERN = exports.FILTERED_PATTERN = 'filteredPattern';
const SELECTED_TIMESTAMP = exports.SELECTED_TIMESTAMP = 'selectedTimestamp';
const SELECTED_FIELDS = exports.SELECTED_FIELDS = 'selectedFields';
const UNSELECTED_FIELDS = exports.UNSELECTED_FIELDS = 'unselectedFields';
const AVAILABLE_FIELDS = exports.AVAILABLE_FIELDS = 'availableFields';
const QUERIED_FIELDS = exports.QUERIED_FIELDS = 'queriedFields';
const TAB_ID_TXT_PFX = exports.TAB_ID_TXT_PFX = 'explorer-tab-';
const TAB_TITLE = exports.TAB_TITLE = 'New query';
const TAB_CHART_TITLE = exports.TAB_CHART_TITLE = 'Visualizations';
const TAB_EVENT_TITLE = exports.TAB_EVENT_TITLE = 'Events';
const TAB_EVENT_ID_TXT_PFX = exports.TAB_EVENT_ID_TXT_PFX = 'main-content-events-';
const TAB_CHART_ID_TXT_PFX = exports.TAB_CHART_ID_TXT_PFX = 'main-content-vis-';
const TAB_EVENT_ID = exports.TAB_EVENT_ID = 'main-content-events';
const TAB_CHART_ID = exports.TAB_CHART_ID = 'main-content-vis';
const CREATE_TAB_PARAM_KEY = exports.CREATE_TAB_PARAM_KEY = 'create';
const CREATE_TAB_PARAM = exports.CREATE_TAB_PARAM = {
  [TAB_EVENT_ID]: 'events',
  [TAB_CHART_ID]: 'visualizations'
};
const HAS_SAVED_TIMESTAMP = exports.HAS_SAVED_TIMESTAMP = 'hasSavedTimestamp';
const FILTER_OPTIONS = exports.FILTER_OPTIONS = ['Visualization', 'Query', 'Metric'];
const SAVED_QUERY = exports.SAVED_QUERY = 'savedQuery';
const SAVED_VISUALIZATION = exports.SAVED_VISUALIZATION = 'savedVisualization';
const SAVED_OBJECT_ID = exports.SAVED_OBJECT_ID = 'savedObjectId';
const SAVED_OBJECT_TYPE = exports.SAVED_OBJECT_TYPE = 'objectType';
const TAB_CREATED_TYPE = exports.TAB_CREATED_TYPE = 'tabCreatedType';
const NEW_TAB = exports.NEW_TAB = 'newTab';
const REDIRECT_TAB = exports.REDIRECT_TAB = 'redirect_tab';
const PAGE_SIZE = exports.PAGE_SIZE = 50;
const DEFAULT_COLUMNS = exports.DEFAULT_COLUMNS = ['', 'Time', '_source'];
const OTEL_TRACE_ID = exports.OTEL_TRACE_ID = 'traceId';
const JAEGER_TRACE_ID = exports.JAEGER_TRACE_ID = 'traceID';
const DATE_PICKER_FORMAT = exports.DATE_PICKER_FORMAT = 'YYYY-MM-DD HH:mm:ss';
const DATE_DISPLAY_FORMAT = exports.DATE_DISPLAY_FORMAT = 'MMM D, YYYY @ HH:mm:ss.SSS';
const DEFAULT_DATETIME_STRING = exports.DEFAULT_DATETIME_STRING = 'now';
const TIME_INTERVAL_OPTIONS = exports.TIME_INTERVAL_OPTIONS = [{
  text: 'Minute',
  value: 'm'
}, {
  text: 'Hour',
  value: 'h'
}, {
  text: 'Day',
  value: 'd'
}, {
  text: 'Week',
  value: 'w'
}, {
  text: 'Month',
  value: 'M'
}, {
  text: 'Year',
  value: 'y'
}];

// redux
const SELECTED_QUERY_TAB = exports.SELECTED_QUERY_TAB = 'selectedQueryTab';
const QUERY_TAB_IDS = exports.QUERY_TAB_IDS = 'queryTabIds';
const NEW_SELECTED_QUERY_TAB = exports.NEW_SELECTED_QUERY_TAB = 'newSelectedQueryTab';
const REDUX_EXPL_SLICE_QUERIES = exports.REDUX_EXPL_SLICE_QUERIES = 'queries';
const REDUX_EXPL_SLICE_QUERY_RESULT = exports.REDUX_EXPL_SLICE_QUERY_RESULT = 'queryResults';
const REDUX_EXPL_SLICE_FIELDS = exports.REDUX_EXPL_SLICE_FIELDS = 'fields';
const REDUX_EXPL_SLICE_QUERY_TABS = exports.REDUX_EXPL_SLICE_QUERY_TABS = 'queryTabs';
const REDUX_EXPL_SLICE_VISUALIZATION = exports.REDUX_EXPL_SLICE_VISUALIZATION = 'explorerVisualization';
const REDUX_EXPL_SLICE_COUNT_DISTRIBUTION = exports.REDUX_EXPL_SLICE_COUNT_DISTRIBUTION = 'countDistributionVisualization';
const REDUX_EXPL_SLICE_PATTERNS = exports.REDUX_EXPL_SLICE_PATTERNS = 'patterns';
const REDUX_EXPL_SLICE_SEARCH_META_DATA = exports.REDUX_EXPL_SLICE_SEARCH_META_DATA = 'searchMetaData';
const PLOTLY_GAUGE_COLUMN_NUMBER = exports.PLOTLY_GAUGE_COLUMN_NUMBER = 4;
const APP_ANALYTICS_TAB_ID_REGEX = exports.APP_ANALYTICS_TAB_ID_REGEX = /application-analytics-tab.+/;
const DEFAULT_AVAILABILITY_QUERY = exports.DEFAULT_AVAILABILITY_QUERY = 'stats count() by span( timestamp, 1h )';
const PPL_DEFAULT_PATTERN_REGEX_FILETER = exports.PPL_DEFAULT_PATTERN_REGEX_FILETER = '[a-zA-Z\\d]';
// Greedily matches the longest substring for example (patterns referer | patterns pattern='[0-9]' message | where ...) used to modify the query for patterns table
const PATTERNS_REGEX = exports.PATTERNS_REGEX = /\|\s*patterns.+?\|.*\s*where\s+patterns_field\s*\=\s*'[^a-zA-Z0-9]+'/;
// Used to extract the initial pattern applied
const PATTERNS_EXTRACTOR_REGEX = exports.PATTERNS_EXTRACTOR_REGEX = /patterns\s+(?<pattern>\S+)/;
const ADD_BUTTON_TEXT = exports.ADD_BUTTON_TEXT = '+ Add color theme';
const NUMBER_INPUT_MIN_LIMIT = exports.NUMBER_INPUT_MIN_LIMIT = 1;
const VIZ_CONTAIN_XY_AXIS = exports.VIZ_CONTAIN_XY_AXIS = [_shared.VIS_CHART_TYPES.Bar, _shared.VIS_CHART_TYPES.Histogram, _shared.VIS_CHART_TYPES.Line, _shared.VIS_CHART_TYPES.Pie, _shared.VIS_CHART_TYPES.Scatter, _shared.VIS_CHART_TYPES.HorizontalBar];

// default ppl aggregation method options
const AGGREGATION_OPTIONS = exports.AGGREGATION_OPTIONS = [{
  label: 'count'
}, {
  label: 'sum'
}, {
  label: 'avg'
}, {
  label: 'max'
}, {
  label: 'min'
}, {
  label: 'var_samp'
}, {
  label: 'var_pop'
}, {
  label: 'stddev_samp'
}, {
  label: 'stddev_pop'
}];

// numeric fields type for metrics
const NUMERICAL_TYPES = exports.NUMERICAL_TYPES = ['float', 'double', 'bigint', 'long', 'octet', 'short', 'byte', 'integer'];
// Data table constants
const GRID_HEADER_COLUMN_MAX_WIDTH = exports.GRID_HEADER_COLUMN_MAX_WIDTH = '150px';
const GRID_PAGE_RANGE_DISPLAY = exports.GRID_PAGE_RANGE_DISPLAY = 5;
const COLUMN_DEFAULT_MIN_WIDTH = exports.COLUMN_DEFAULT_MIN_WIDTH = 100;
const GRID_PAGE_SIZES = exports.GRID_PAGE_SIZES = [10, 50, 100];
const ROW_DENSITIES = exports.ROW_DENSITIES = [{
  icon: 'tableDensityExpanded',
  height: 55,
  selected: false
}, {
  icon: 'tableDensityNormal',
  height: 45,
  selected: false
}, {
  icon: 'tableDensityCompact',
  height: 35,
  selected: true
}];
const HEADER_HEIGHT = exports.HEADER_HEIGHT = 35;

// gauge chart default parameters

const DEFAULT_GAUGE_CHART_PARAMETERS = exports.DEFAULT_GAUGE_CHART_PARAMETERS = {
  GaugeTitleSize: 14,
  DisplayDefaultGauges: 1,
  OrientationDefault: 'h',
  TickLength: 5,
  LegendPlacement: 'center',
  ThresholdsMaxLimit: 1
};

// pie chart default parameters
const PLOTLY_PIE_COLUMN_NUMBER = exports.PLOTLY_PIE_COLUMN_NUMBER = 2;
const PIE_XAXIS_GAP = exports.PIE_XAXIS_GAP = 0.2;
const PIE_YAXIS_GAP = exports.PIE_YAXIS_GAP = 0.1;
const DEFAULT_PIE_CHART_PARAMETERS = exports.DEFAULT_PIE_CHART_PARAMETERS = {
  DefaultMode: 'pie'
};
const GROUPBY = exports.GROUPBY = 'dimensions';
const AGGREGATIONS = exports.AGGREGATIONS = 'series';
const PARENTFIELDS = exports.PARENTFIELDS = 'parentFields';
const VALUEFIELD = exports.VALUEFIELD = 'valueField';
const CHILDFIELD = exports.CHILDFIELD = 'childField';
const TIMESTAMP = exports.TIMESTAMP = 'timestamp';

// metrics constants
const METRICS_GRID_SPACE_BETWEEN_X_AXIS = exports.METRICS_GRID_SPACE_BETWEEN_X_AXIS = 0.01;
const METRICS_GRID_SPACE_BETWEEN_Y_AXIS = exports.METRICS_GRID_SPACE_BETWEEN_Y_AXIS = 100;
const METRICS_REDUCE_VALUE_SIZE_PERCENTAGE = exports.METRICS_REDUCE_VALUE_SIZE_PERCENTAGE = 0.08;
const METRICS_REDUCE_TITLE_SIZE_PERCENTAGE = exports.METRICS_REDUCE_TITLE_SIZE_PERCENTAGE = 0.05;
const METRICS_REDUCE_SERIES_UNIT_SIZE_PERCENTAGE = exports.METRICS_REDUCE_SERIES_UNIT_SIZE_PERCENTAGE = 0.2;
const METRICS_SERIES_UNIT_SUBSTRING_LENGTH = exports.METRICS_SERIES_UNIT_SUBSTRING_LENGTH = 3;
const METRICS_AXIS_MARGIN = exports.METRICS_AXIS_MARGIN = {
  l: 0,
  r: 0,
  b: 0,
  t: 80
};
const METRICS_ANNOTATION = exports.METRICS_ANNOTATION = {
  xref: 'paper',
  yref: 'paper',
  showarrow: false
};
const DEFAULT_METRICS_CHART_PARAMETERS = exports.DEFAULT_METRICS_CHART_PARAMETERS = {
  DefaultTextMode: 'auto',
  DefaultOrientation: 'auto',
  DefaultTitleSize: 30,
  DefaultValueSize: 80,
  DefaultChartType: 'auto',
  TextAlignment: 'auto',
  DefaultPrecision: 1,
  BaseThreshold: {
    thid: (0, _eui.htmlIdGenerator)('thr')(),
    name: 'Base',
    color: '#3CA1C7',
    value: 0,
    isReadOnly: true
  },
  DefaultTextColor: '#FFFFFF'
};
const DEFAULT_BAR_CHART_STYLES = exports.DEFAULT_BAR_CHART_STYLES = {
  BarMode: 'group',
  GroupWidth: 0.7,
  BarWidth: 0.97,
  LabelSize: 12
};
const SIMILAR_VIZ_TYPES = exports.SIMILAR_VIZ_TYPES = [_shared.VIS_CHART_TYPES.Line, _shared.VIS_CHART_TYPES.Scatter, _shared.VIS_CHART_TYPES.HorizontalBar, _shared.VIS_CHART_TYPES.Bar];
let ConfigChartOptionsEnum = exports.ConfigChartOptionsEnum = /*#__PURE__*/function (ConfigChartOptionsEnum) {
  ConfigChartOptionsEnum["palettePicker"] = "palettePicker";
  ConfigChartOptionsEnum["singleColorPicker"] = "singleColorPicker";
  ConfigChartOptionsEnum["colorpicker"] = "colorpicker";
  ConfigChartOptionsEnum["treemapColorPicker"] = "treemapColorPicker";
  ConfigChartOptionsEnum["input"] = "input";
  ConfigChartOptionsEnum["textInput"] = "textInput";
  ConfigChartOptionsEnum["slider"] = "slider";
  ConfigChartOptionsEnum["switchButton"] = "switchButton";
  ConfigChartOptionsEnum["buttons"] = "buttons";
  return ConfigChartOptionsEnum;
}({});
const CUSTOM_LABEL = exports.CUSTOM_LABEL = 'customLabel';
const BREAKDOWNS = exports.BREAKDOWNS = 'breakdowns';
const SPAN = exports.SPAN = 'span';
const TIME_FIELD = exports.TIME_FIELD = 'time_field';
const DISABLED_COLOUR = exports.DISABLED_COLOUR = '#fafbfd';
const DATA_CONFIG_HINTS_INFO = exports.DATA_CONFIG_HINTS_INFO = {
  [AGGREGATIONS]: 'Series is an aggregation function (mandatory). The argument of an aggregation must be a field.',
  [GROUPBY]: "Dimensions are 'by' clauses. They are fields or expressions like scalar and aggregation functions. Besides, the span clause for a dimension can be used to split a specific field into buckets in the same interval, the stats then does the aggregation by these span buckets.",
  [BREAKDOWNS]: "Defines how each series is broken down. Breakdowns are 'by' clauses that subdivide the existing series."
};

// Metrics constants
const UNITS_OF_MEASURE = exports.UNITS_OF_MEASURE = ['seconds (s)', 'hours (h)', 'celsius (C)', 'farenheit (F)', 'meters (m)', 'kilometers (k)'];
const sampleLogPatternData = exports.sampleLogPatternData = {
  count: 5,
  pattern: '[a-zA-Zd]',
  sampleLog: '218.148.135.12 - - [2018-07-22T04:18:12.345Z] "GET /beats/filebeat/filebeat-6.3.2-linux-x86_64.tar.gz_1 HTTP/1.1" 200 4531 "-" \
           "Mozilla/5.0 (X11; Linux x86_64; rv:6.0a1) Gecko/20110421 Firefox/6.0a1"',
  anomalyCount: 0
};
const TYPE_TAB_MAPPING = exports.TYPE_TAB_MAPPING = {
  [SAVED_QUERY]: TAB_EVENT_ID,
  [SAVED_VISUALIZATION]: TAB_CHART_ID
};
const DEFAULT_EMPTY_EXPLORER_FIELDS = exports.DEFAULT_EMPTY_EXPLORER_FIELDS = [{
  name: 'timestamp',
  type: 'timestamp'
}, {
  name: '_source',
  type: 'string'
}];
const DEFAULT_TIMESTAMP_COLUMN = exports.DEFAULT_TIMESTAMP_COLUMN = {
  id: 'timestamp',
  isSortable: true,
  display: 'Time',
  schema: 'datetime',
  initialWidth: 200
};
const DEFAULT_SOURCE_COLUMN = exports.DEFAULT_SOURCE_COLUMN = {
  id: '_source',
  isSortable: false,
  display: 'Source',
  schema: '_source'
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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