"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.queryWorkbenchPluginID = exports.pageStyles = exports.observabilityTracesTitle = exports.observabilityTracesPluginOrder = exports.observabilityTracesID = exports.observabilityTitle = exports.observabilityPluginOrder = exports.observabilityPanelsTitle = exports.observabilityPanelsPluginOrder = exports.observabilityPanelsID = exports.observabilityNotebookTitle = exports.observabilityNotebookPluginOrder = exports.observabilityNotebookID = exports.observabilityMetricsTitle = exports.observabilityMetricsPluginOrder = exports.observabilityMetricsID = exports.observabilityLogsTitle = exports.observabilityLogsPluginOrder = exports.observabilityLogsID = exports.observabilityIntegrationsTitle = exports.observabilityIntegrationsPluginOrder = exports.observabilityIntegrationsID = exports.observabilityID = exports.observabilityDataConnectionsTitle = exports.observabilityDataConnectionsPluginOrder = exports.observabilityDataConnectionsID = exports.observabilityApplicationsTitle = exports.observabilityApplicationsPluginOrder = exports.observabilityApplicationsID = exports.WAITING_TIME_ON_USER_ACTIONS = exports.VIS_CHART_TYPES = exports.VISUALIZATION_ERROR = exports.UI_DATE_FORMAT = exports.THRESHOLD_LINE_WIDTH = exports.THRESHOLD_LINE_OPACITY = exports.SQL_ENDPOINT = exports.SQL_DOCUMENTATION_URL = exports.SPAN_REGEX = exports.SLIDER_STEP = exports.SLIDER_MIN_VALUE = exports.SLIDER_MAX_VALUE = exports.SECURITY_ROLES = exports.SAVED_VISUALIZATION = exports.SAVED_QUERY = exports.SAVED_OBJECTS = exports.SAVED_OBJECT = exports.S3_DATASOURCE_TYPE = exports.QUERY_ASSIST_START_TIME = exports.QUERY_ASSIST_END_TIME = exports.PROMQL_METRIC_SUBTYPE = exports.PPL_WHERE_CLAUSE_REGEX = exports.PPL_STATS_REGEX = exports.PPL_SPAN_REGEX = exports.PPL_SEARCH = exports.PPL_PATTERNS_DOCUMENTATION_URL = exports.PPL_NEWLINE_REGEX = exports.PPL_METRIC_SUBTYPE = exports.PPL_INDEX_REGEX = exports.PPL_INDEX_INSERT_POINT_REGEX = exports.PPL_ENDPOINT = exports.PPL_DOCUMENTATION_URL = exports.PPL_DATE_FORMAT = exports.PPL_BASE = exports.PLOT_MARGIN = exports.PLOTLY_COLOR = exports.OPENSEARCH_PANELS_API = exports.OPENSEARCH_DATACONNECTIONS_API = exports.OBSERVABILITY_BASE = exports.NUMERICAL_FIELDS = exports.MAX_BUCKET_LENGTH = exports.LONG_CHART_COLOR = exports.LIVE_OPTIONS = exports.LIVE_END_TIME = exports.JOB_RESULT_ENDPOINT = exports.JOBS_ENDPOINT_BASE = exports.JOBS_BASE = exports.INTEGRATIONS_BASE = exports.FILLOPACITY_DIV_FACTOR = exports.EVENT_ANALYTICS = exports.ENABLED_VIS_TYPES = exports.EDIT = exports.DSL_SEARCH = exports.DSL_MAPPING = exports.DSL_ENDPOINT = exports.DSL_CAT = exports.DSL_BASE = exports.DIRECT_DUMMY_QUERY = exports.DEFAULT_START_TIME = exports.DEFAULT_CHART_STYLES = exports.DATACONNECTIONS_ENDPOINT = exports.DATACONNECTIONS_BASE = exports.CONSOLE_PROXY = exports.BarOrientation = exports.ASYNC_QUERY_SESSION_ID = void 0;
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

// Client route
const PPL_BASE = exports.PPL_BASE = '/api/ppl';
const PPL_SEARCH = exports.PPL_SEARCH = '/search';
const DSL_BASE = exports.DSL_BASE = '/api/dsl';
const DSL_SEARCH = exports.DSL_SEARCH = '/search';
const DSL_CAT = exports.DSL_CAT = '/cat.indices';
const DSL_MAPPING = exports.DSL_MAPPING = '/indices.getFieldMapping';
const OBSERVABILITY_BASE = exports.OBSERVABILITY_BASE = '/api/observability';
const INTEGRATIONS_BASE = exports.INTEGRATIONS_BASE = '/api/integrations';
const JOBS_BASE = exports.JOBS_BASE = '/query/jobs';
const DATACONNECTIONS_BASE = exports.DATACONNECTIONS_BASE = '/api/dataconnections';
const EDIT = exports.EDIT = '/edit';
const SECURITY_ROLES = exports.SECURITY_ROLES = '/api/v1/configuration/roles';
const EVENT_ANALYTICS = exports.EVENT_ANALYTICS = '/event_analytics';
const SAVED_OBJECTS = exports.SAVED_OBJECTS = '/saved_objects';
const SAVED_QUERY = exports.SAVED_QUERY = '/query';
const SAVED_VISUALIZATION = exports.SAVED_VISUALIZATION = '/vis';
const CONSOLE_PROXY = exports.CONSOLE_PROXY = '/api/console/proxy';

// Server route
const PPL_ENDPOINT = exports.PPL_ENDPOINT = '/_plugins/_ppl';
const SQL_ENDPOINT = exports.SQL_ENDPOINT = '/_plugins/_sql';
const DSL_ENDPOINT = exports.DSL_ENDPOINT = '/_plugins/_dsl';
const DATACONNECTIONS_ENDPOINT = exports.DATACONNECTIONS_ENDPOINT = '/_plugins/_query/_datasources';
const JOBS_ENDPOINT_BASE = exports.JOBS_ENDPOINT_BASE = '/_plugins/_async_query';
const JOB_RESULT_ENDPOINT = exports.JOB_RESULT_ENDPOINT = '/result';
const observabilityID = exports.observabilityID = 'observability-logs';
const observabilityTitle = exports.observabilityTitle = 'Observability';
const observabilityPluginOrder = exports.observabilityPluginOrder = 1500;
const observabilityApplicationsID = exports.observabilityApplicationsID = 'observability-applications';
const observabilityApplicationsTitle = exports.observabilityApplicationsTitle = 'Applications';
const observabilityApplicationsPluginOrder = exports.observabilityApplicationsPluginOrder = 5090;
const observabilityLogsID = exports.observabilityLogsID = 'observability-logs';
const observabilityLogsTitle = exports.observabilityLogsTitle = 'Logs';
const observabilityLogsPluginOrder = exports.observabilityLogsPluginOrder = 5091;
const observabilityMetricsID = exports.observabilityMetricsID = 'observability-metrics';
const observabilityMetricsTitle = exports.observabilityMetricsTitle = 'Metrics';
const observabilityMetricsPluginOrder = exports.observabilityMetricsPluginOrder = 5092;
const observabilityTracesID = exports.observabilityTracesID = 'observability-traces';
const observabilityTracesTitle = exports.observabilityTracesTitle = 'Traces';
const observabilityTracesPluginOrder = exports.observabilityTracesPluginOrder = 5093;
const observabilityNotebookID = exports.observabilityNotebookID = 'observability-notebooks';
const observabilityNotebookTitle = exports.observabilityNotebookTitle = 'Notebooks';
const observabilityNotebookPluginOrder = exports.observabilityNotebookPluginOrder = 5094;
const observabilityPanelsID = exports.observabilityPanelsID = 'observability-dashboards';
const observabilityPanelsTitle = exports.observabilityPanelsTitle = 'Dashboards';
const observabilityPanelsPluginOrder = exports.observabilityPanelsPluginOrder = 5095;
const observabilityIntegrationsID = exports.observabilityIntegrationsID = 'integrations';
const observabilityIntegrationsTitle = exports.observabilityIntegrationsTitle = 'Integrations';
const observabilityIntegrationsPluginOrder = exports.observabilityIntegrationsPluginOrder = 9020;
const observabilityDataConnectionsID = exports.observabilityDataConnectionsID = 'datasources';
const observabilityDataConnectionsTitle = exports.observabilityDataConnectionsTitle = 'Data sources';
const observabilityDataConnectionsPluginOrder = exports.observabilityDataConnectionsPluginOrder = 9030;
const queryWorkbenchPluginID = exports.queryWorkbenchPluginID = 'opensearch-query-workbench';

// Shared Constants
const SQL_DOCUMENTATION_URL = exports.SQL_DOCUMENTATION_URL = 'https://opensearch.org/docs/latest/search-plugins/sql/index/';
const PPL_DOCUMENTATION_URL = exports.PPL_DOCUMENTATION_URL = 'https://opensearch.org/docs/latest/search-plugins/sql/ppl/index';
const PPL_PATTERNS_DOCUMENTATION_URL = exports.PPL_PATTERNS_DOCUMENTATION_URL = 'https://github.com/opensearch-project/sql/blob/2.x/docs/user/ppl/cmd/patterns.rst#description';
const UI_DATE_FORMAT = exports.UI_DATE_FORMAT = 'MM/DD/YYYY hh:mm A';
const PPL_DATE_FORMAT = exports.PPL_DATE_FORMAT = 'YYYY-MM-DD HH:mm:ss.SSSSSS';
const SPAN_REGEX = exports.SPAN_REGEX = /span/;
const PROMQL_METRIC_SUBTYPE = exports.PROMQL_METRIC_SUBTYPE = 'promqlmetric';
const PPL_METRIC_SUBTYPE = exports.PPL_METRIC_SUBTYPE = 'metric';
const PPL_SPAN_REGEX = exports.PPL_SPAN_REGEX = /by\s*span/i;
const PPL_STATS_REGEX = exports.PPL_STATS_REGEX = /\|\s*stats/i;
const PPL_INDEX_INSERT_POINT_REGEX = exports.PPL_INDEX_INSERT_POINT_REGEX = /(search source|source|index)\s*=\s*([^|\s]+)(.*)/i;
const PPL_INDEX_REGEX = exports.PPL_INDEX_REGEX = /(search source|source|index)\s*=\s*([^|\s]+)/i;
const PPL_WHERE_CLAUSE_REGEX = exports.PPL_WHERE_CLAUSE_REGEX = /\s*where\s+/i;
const PPL_NEWLINE_REGEX = exports.PPL_NEWLINE_REGEX = /[\n\r]+/g;

// Observability plugin URI
const BASE_OBSERVABILITY_URI = '/_plugins/_observability';
const BASE_DATACONNECTIONS_URI = '/_plugins/_query/_datasources';
const OPENSEARCH_PANELS_API = exports.OPENSEARCH_PANELS_API = {
  OBJECT: `${BASE_OBSERVABILITY_URI}/object`
};
const OPENSEARCH_DATACONNECTIONS_API = exports.OPENSEARCH_DATACONNECTIONS_API = {
  DATACONNECTION: `${BASE_DATACONNECTIONS_URI}`
};

// Saved Objects
const SAVED_OBJECT = exports.SAVED_OBJECT = '/object';

// Color Constants
const PLOTLY_COLOR = exports.PLOTLY_COLOR = ['#3CA1C7', '#54B399', '#DB748A', '#F2BE4B', '#68CCC2', '#2A7866', '#843769', '#374FB8', '#BD6F26', '#4C636F'];
const LONG_CHART_COLOR = exports.LONG_CHART_COLOR = PLOTLY_COLOR[1];
const pageStyles = exports.pageStyles = {
  float: 'left',
  width: '100%',
  maxWidth: '1130px'
};
let VIS_CHART_TYPES = exports.VIS_CHART_TYPES = /*#__PURE__*/function (VIS_CHART_TYPES) {
  VIS_CHART_TYPES["Bar"] = "bar";
  VIS_CHART_TYPES["HorizontalBar"] = "horizontal_bar";
  VIS_CHART_TYPES["Line"] = "line";
  VIS_CHART_TYPES["Pie"] = "pie";
  VIS_CHART_TYPES["HeatMap"] = "heatmap";
  VIS_CHART_TYPES["Text"] = "text";
  return VIS_CHART_TYPES;
}({});
const NUMERICAL_FIELDS = exports.NUMERICAL_FIELDS = ['short', 'integer', 'long', 'float', 'double'];
const ENABLED_VIS_TYPES = exports.ENABLED_VIS_TYPES = [VIS_CHART_TYPES.Bar, VIS_CHART_TYPES.HorizontalBar, VIS_CHART_TYPES.Line, VIS_CHART_TYPES.Pie, VIS_CHART_TYPES.HeatMap, VIS_CHART_TYPES.Text];

// Live tail constants
const LIVE_OPTIONS = exports.LIVE_OPTIONS = [{
  label: '5s',
  startTime: 'now-5s',
  delayTime: 5000
}, {
  label: '10s',
  startTime: 'now-10s',
  delayTime: 10000
}, {
  label: '30s',
  startTime: 'now-30s',
  delayTime: 30000
}, {
  label: '1m',
  startTime: 'now-1m',
  delayTime: 60000
}, {
  label: '5m',
  startTime: 'now-5m',
  delayTime: 60000 * 5
}, {
  label: '15m',
  startTime: 'now-15m',
  delayTime: 60000 * 15
}, {
  label: '30m',
  startTime: 'now-30m',
  delayTime: 60000 * 30
}, {
  label: '1h',
  startTime: 'now-1h',
  delayTime: 60000 * 60
}, {
  label: '2h',
  startTime: 'now-2h',
  delayTime: 60000 * 120
}];
const LIVE_END_TIME = exports.LIVE_END_TIME = 'now';
const DEFAULT_CHART_STYLES = exports.DEFAULT_CHART_STYLES = {
  DefaultModeLine: 'lines',
  Interpolation: 'spline',
  LineWidth: 0,
  FillOpacity: 100,
  MarkerSize: 5,
  ShowLegend: 'show',
  LegendPosition: 'v',
  LabelAngle: 0,
  DefaultSortSectors: 'largest_to_smallest',
  DefaultModeScatter: 'markers'
};
const FILLOPACITY_DIV_FACTOR = exports.FILLOPACITY_DIV_FACTOR = 200;
const SLIDER_MIN_VALUE = exports.SLIDER_MIN_VALUE = 0;
const SLIDER_MAX_VALUE = exports.SLIDER_MAX_VALUE = 100;
const SLIDER_STEP = exports.SLIDER_STEP = 1;
const THRESHOLD_LINE_WIDTH = exports.THRESHOLD_LINE_WIDTH = 3;
const THRESHOLD_LINE_OPACITY = exports.THRESHOLD_LINE_OPACITY = 0.7;
const MAX_BUCKET_LENGTH = exports.MAX_BUCKET_LENGTH = 16;
let BarOrientation = exports.BarOrientation = /*#__PURE__*/function (BarOrientation) {
  BarOrientation["horizontal"] = "h";
  BarOrientation["vertical"] = "v";
  return BarOrientation;
}({});
const PLOT_MARGIN = exports.PLOT_MARGIN = {
  l: 30,
  r: 5,
  b: 30,
  t: 50,
  pad: 4
};
const WAITING_TIME_ON_USER_ACTIONS = exports.WAITING_TIME_ON_USER_ACTIONS = 300;
const VISUALIZATION_ERROR = exports.VISUALIZATION_ERROR = {
  NO_DATA: 'No data found.',
  INVALID_DATA: 'Invalid visualization data',
  NO_SERIES: 'Add a field to start',
  NO_METRIC: 'Invalid Metric MetaData'
};
const S3_DATASOURCE_TYPE = exports.S3_DATASOURCE_TYPE = 'S3_DATASOURCE';
const ASYNC_QUERY_SESSION_ID = exports.ASYNC_QUERY_SESSION_ID = 'async-query-session-id';
const DIRECT_DUMMY_QUERY = exports.DIRECT_DUMMY_QUERY = 'select 1';
const DEFAULT_START_TIME = exports.DEFAULT_START_TIME = 'now-15m';
const QUERY_ASSIST_START_TIME = exports.QUERY_ASSIST_START_TIME = 'now-40y';
const QUERY_ASSIST_END_TIME = exports.QUERY_ASSIST_END_TIME = 'now';
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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