"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setAsyncSessionId = exports.getAsyncSessionId = void 0;
var _shared = require("../constants/shared");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const setAsyncSessionId = value => {
  if (value !== null) {
    sessionStorage.setItem(_shared.ASYNC_QUERY_SESSION_ID, value);
  }
};
exports.setAsyncSessionId = setAsyncSessionId;
const getAsyncSessionId = () => {
  return sessionStorage.getItem(_shared.ASYNC_QUERY_SESSION_ID);
};
exports.getAsyncSessionId = getAsyncSessionId;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJuYW1lcyI6WyJfc2hhcmVkIiwicmVxdWlyZSIsInNldEFzeW5jU2Vzc2lvbklkIiwidmFsdWUiLCJzZXNzaW9uU3RvcmFnZSIsInNldEl0ZW0iLCJBU1lOQ19RVUVSWV9TRVNTSU9OX0lEIiwiZXhwb3J0cyIsImdldEFzeW5jU2Vzc2lvbklkIiwiZ2V0SXRlbSJdLCJzb3VyY2VzIjpbInF1ZXJ5X3Nlc3Npb25fdXRpbHMudHMiXSwic291cmNlc0NvbnRlbnQiOlsiLypcbiAqIENvcHlyaWdodCBPcGVuU2VhcmNoIENvbnRyaWJ1dG9yc1xuICogU1BEWC1MaWNlbnNlLUlkZW50aWZpZXI6IEFwYWNoZS0yLjBcbiAqL1xuXG5pbXBvcnQgeyBBU1lOQ19RVUVSWV9TRVNTSU9OX0lEIH0gZnJvbSAnLi4vY29uc3RhbnRzL3NoYXJlZCc7XG5cbmV4cG9ydCBjb25zdCBzZXRBc3luY1Nlc3Npb25JZCA9ICh2YWx1ZTogc3RyaW5nIHwgbnVsbCkgPT4ge1xuICBpZiAodmFsdWUgIT09IG51bGwpIHtcbiAgICBzZXNzaW9uU3RvcmFnZS5zZXRJdGVtKEFTWU5DX1FVRVJZX1NFU1NJT05fSUQsIHZhbHVlKTtcbiAgfVxufTtcblxuZXhwb3J0IGNvbnN0IGdldEFzeW5jU2Vzc2lvbklkID0gKCkgPT4ge1xuICByZXR1cm4gc2Vzc2lvblN0b3JhZ2UuZ2V0SXRlbShBU1lOQ19RVUVSWV9TRVNTSU9OX0lEKTtcbn07XG4iXSwibWFwcGluZ3MiOiI7Ozs7OztBQUtBLElBQUFBLE9BQUEsR0FBQUMsT0FBQTtBQUxBO0FBQ0E7QUFDQTtBQUNBOztBQUlPLE1BQU1DLGlCQUFpQixHQUFJQyxLQUFvQixJQUFLO0VBQ3pELElBQUlBLEtBQUssS0FBSyxJQUFJLEVBQUU7SUFDbEJDLGNBQWMsQ0FBQ0MsT0FBTyxDQUFDQyw4QkFBc0IsRUFBRUgsS0FBSyxDQUFDO0VBQ3ZEO0FBQ0YsQ0FBQztBQUFDSSxPQUFBLENBQUFMLGlCQUFBLEdBQUFBLGlCQUFBO0FBRUssTUFBTU0saUJBQWlCLEdBQUdBLENBQUEsS0FBTTtFQUNyQyxPQUFPSixjQUFjLENBQUNLLE9BQU8sQ0FBQ0gsOEJBQXNCLENBQUM7QUFDdkQsQ0FBQztBQUFDQyxPQUFBLENBQUFDLGlCQUFBLEdBQUFBLGlCQUFBIn0=