"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "ObservabilityPluginSetup", {
  enumerable: true,
  get: function () {
    return _types.ObservabilityPluginSetup;
  }
});
Object.defineProperty(exports, "ObservabilityPluginStart", {
  enumerable: true,
  get: function () {
    return _types.ObservabilityPluginStart;
  }
});
exports.config = void 0;
exports.plugin = plugin;
var _configSchema = require("@osd/config-schema");
var _plugin = require("./plugin");
var _types = require("./types");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function plugin(initializerContext) {
  return new _plugin.ObservabilityPlugin(initializerContext);
}
const observabilityConfig = {
  schema: _configSchema.schema.object({
    query_assist: _configSchema.schema.object({
      enabled: _configSchema.schema.boolean({
        defaultValue: false
      }),
      ppl_agent_name: _configSchema.schema.conditional(_configSchema.schema.siblingRef('enabled'), true, _configSchema.schema.string(), _configSchema.schema.maybe(_configSchema.schema.string()))
    }),
    summarize: _configSchema.schema.object({
      enabled: _configSchema.schema.boolean({
        defaultValue: false
      }),
      response_summary_agent_name: _configSchema.schema.conditional(_configSchema.schema.siblingRef('enabled'), true, _configSchema.schema.string(), _configSchema.schema.maybe(_configSchema.schema.string())),
      error_summary_agent_name: _configSchema.schema.conditional(_configSchema.schema.siblingRef('enabled'), true, _configSchema.schema.string(), _configSchema.schema.maybe(_configSchema.schema.string()))
    })
  })
};
const config = exports.config = {
  schema: observabilityConfig.schema,
  exposeToBrowser: {
    query_assist: true,
    summarize: true
  }
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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