"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerDataConnectionsRoute = registerDataConnectionsRoute;
var _configSchema = require("@osd/config-schema");
var _shared = require("../../../common/constants/shared");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function registerDataConnectionsRoute(router) {
  router.get({
    path: `${_shared.DATACONNECTIONS_BASE}/{name}`,
    validate: {
      params: _configSchema.schema.object({
        name: _configSchema.schema.string()
      })
    }
  }, async (context, request, response) => {
    try {
      const dataConnectionsresponse = await context.observability_plugin.observabilityClient.asScoped(request).callAsCurrentUser('ppl.getDataConnectionById', {
        dataconnection: request.params.name
      });
      return response.ok({
        body: dataConnectionsresponse
      });
    } catch (error) {
      console.error('Issue in fetching data connection:', error);
      return response.custom({
        statusCode: error.statusCode || 500,
        body: error.message
      });
    }
  });
  router.delete({
    path: `${_shared.DATACONNECTIONS_BASE}/{name}`,
    validate: {
      params: _configSchema.schema.object({
        name: _configSchema.schema.string()
      })
    }
  }, async (context, request, response) => {
    try {
      const dataConnectionsresponse = await context.observability_plugin.observabilityClient.asScoped(request).callAsCurrentUser('ppl.deleteDataConnection', {
        dataconnection: request.params.name
      });
      return response.ok({
        body: dataConnectionsresponse
      });
    } catch (error) {
      console.error('Issue in deleting data connection:', error);
      return response.custom({
        statusCode: error.statusCode || 500,
        body: error.message
      });
    }
  });
  router.post({
    path: `${_shared.DATACONNECTIONS_BASE}${_shared.EDIT}`,
    validate: {
      body: _configSchema.schema.object({
        name: _configSchema.schema.string(),
        allowedRoles: _configSchema.schema.arrayOf(_configSchema.schema.string())
      })
    }
  }, async (context, request, response) => {
    try {
      const dataConnectionsresponse = await context.observability_plugin.observabilityClient.asScoped(request).callAsCurrentUser('ppl.modifyDataConnection', {
        body: {
          name: request.body.name,
          allowedRoles: request.body.allowedRoles
        }
      });
      return response.ok({
        body: dataConnectionsresponse
      });
    } catch (error) {
      console.error('Issue in modifying data connection:', error);
      return response.custom({
        statusCode: error.statusCode || 500,
        body: error.message
      });
    }
  });
  router.post({
    path: `${_shared.DATACONNECTIONS_BASE}`,
    validate: {
      body: _configSchema.schema.object({
        name: _configSchema.schema.string(),
        connector: _configSchema.schema.string(),
        allowedRoles: _configSchema.schema.arrayOf(_configSchema.schema.string()),
        properties: _configSchema.schema.any()
      })
    }
  }, async (context, request, response) => {
    try {
      const dataConnectionsresponse = await context.observability_plugin.observabilityClient.asScoped(request).callAsCurrentUser('ppl.createDataSource', {
        body: {
          name: request.body.name,
          connector: request.body.connector,
          allowedRoles: request.body.allowedRoles,
          properties: request.body.properties
        }
      });
      return response.ok({
        body: dataConnectionsresponse
      });
    } catch (error) {
      console.error('Issue in creating data source:', error);
      return response.custom({
        statusCode: error.statusCode || 500,
        body: error.response
      });
    }
  });
  router.get({
    path: `${_shared.DATACONNECTIONS_BASE}`,
    validate: false
  }, async (context, request, response) => {
    try {
      const dataConnectionsresponse = await context.observability_plugin.observabilityClient.asScoped(request).callAsCurrentUser('ppl.getDataConnections');
      return response.ok({
        body: dataConnectionsresponse
      });
    } catch (error) {
      console.error('Issue in fetching data sources:', error);
      return response.custom({
        statusCode: error.statusCode || 500,
        body: error.response
      });
    }
  });
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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