"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerDslRoute = registerDslRoute;
var _configSchema = require("@osd/config-schema");
var _shared = require("../../common/constants/shared");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function registerDslRoute({
  router,
  facet
}) {
  router.post({
    path: `${_shared.DSL_BASE}${_shared.DSL_SEARCH}`,
    validate: {
      body: _configSchema.schema.any()
    }
  }, async (context, request, response) => {
    const {
      index,
      size,
      ...rest
    } = request.body;
    const params = {
      index,
      size,
      body: rest
    };
    try {
      const resp = await context.core.opensearch.legacy.client.callAsCurrentUser('search', params);
      return response.ok({
        body: resp
      });
    } catch (error) {
      if (error.statusCode !== 404) console.error(error);
      return response.custom({
        statusCode: error.statusCode || 500,
        body: error.message
      });
    }
  });
  router.get({
    path: `${_shared.DSL_BASE}${_shared.DSL_CAT}`,
    validate: {
      query: _configSchema.schema.object({
        format: _configSchema.schema.string()
      })
    }
  }, async (context, request, response) => {
    try {
      const resp = await context.core.opensearch.legacy.client.callAsCurrentUser('cat.indices', request.query);
      return response.ok({
        body: resp
      });
    } catch (error) {
      if (error.statusCode !== 404) console.error(error);
      return response.custom({
        statusCode: error.statusCode || 500,
        body: error.message
      });
    }
  });
  router.get({
    path: `${_shared.DSL_BASE}${_shared.DSL_MAPPING}`,
    validate: {
      query: _configSchema.schema.any()
    }
  }, async (context, request, response) => {
    try {
      const resp = await context.core.opensearch.legacy.client.callAsCurrentUser('indices.getMapping', {
        index: request.query.index
      });
      return response.ok({
        body: resp
      });
    } catch (error) {
      if (error.statusCode !== 404) console.error(error);
      return response.custom({
        statusCode: error.statusCode || 500,
        body: error.message
      });
    }
  });
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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