"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setupRoutes = setupRoutes;
var _dsl_facet = require("../services/facets/dsl_facet");
var _ppl_facet = require("../services/facets/ppl_facet");
var _saved_objects = _interopRequireDefault(require("../services/facets/saved_objects"));
var _queryService = require("../services/queryService");
var _app_analytics_router = require("./application_analytics/app_analytics_router");
var _panels_router = require("./custom_panels/panels_router");
var _visualizations_router = require("./custom_panels/visualizations_router");
var _data_connections_router = require("./data_connections/data_connections_router");
var _datasources_router = require("./datasources/datasources_router");
var _dsl = require("./dsl");
var _event_analytics_router = require("./event_analytics/event_analytics_router");
var _integrations_router = require("./integrations/integrations_router");
var _metrics_rounter = require("./metrics/metrics_rounter");
var _noteRouter = require("./notebooks/noteRouter");
var _paraRouter = require("./notebooks/paraRouter");
var _sqlRouter = require("./notebooks/sqlRouter");
var _vizRouter = require("./notebooks/vizRouter");
var _ppl = require("./ppl");
var _routes = require("./query_assist/routes");
var _trace_analytics_dsl_router = require("./trace_analytics_dsl_router");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function setupRoutes({
  router,
  client,
  config
}) {
  (0, _panels_router.PanelsRouter)(router);
  (0, _visualizations_router.VisualizationsRouter)(router);
  (0, _ppl.registerPplRoute)({
    router,
    facet: new _ppl_facet.PPLFacet(client)
  });
  (0, _dsl.registerDslRoute)({
    router,
    facet: new _dsl_facet.DSLFacet(client)
  });
  (0, _event_analytics_router.registerEventAnalyticsRouter)({
    router,
    savedObjectFacet: new _saved_objects.default(client)
  });
  (0, _app_analytics_router.registerAppAnalyticsRouter)(router);

  // TODO remove trace analytics route when DSL route for autocomplete is added
  (0, _trace_analytics_dsl_router.registerTraceAnalyticsDslRouter)(router);

  // notebooks routes
  (0, _paraRouter.registerParaRoute)(router);
  (0, _noteRouter.registerNoteRoute)(router);
  (0, _vizRouter.registerVizRoute)(router);
  const queryService = new _queryService.QueryService(client);
  (0, _sqlRouter.registerSqlRoute)(router, queryService);
  (0, _metrics_rounter.registerMetricsRoute)(router);
  (0, _integrations_router.registerIntegrationsRoute)(router);
  (0, _data_connections_router.registerDataConnectionsRoute)(router);
  (0, _datasources_router.registerDatasourcesRoute)(router);
  (0, _routes.registerQueryAssistRoutes)(router, config);
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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