"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.replaceBlockedKeywords = exports.WINDOW = exports.TRIGGER_TYPE = exports.SECURITY_CONSTANTS = exports.SCHEDULE_TYPE = exports.REPORT_TYPE = exports.REPORT_STATE = exports.REPORT_DEFINITION_STATUS = exports.INTERVAL = exports.GLOBAL_BASIC_COUNTER = exports.FORMAT = exports.EXTRA_HEADERS = exports.DELIVERY_TYPE = exports.DELIVERY_CHANNEL = exports.DEFAULT_ROLLING_COUNTER = exports.DEFAULT_MAX_SIZE = exports.DATA_REPORT_CONFIG = exports.CAPACITY = exports.ALLOWED_HOSTS = void 0;
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
let FORMAT = exports.FORMAT = /*#__PURE__*/function (FORMAT) {
  FORMAT["pdf"] = "pdf";
  FORMAT["png"] = "png";
  FORMAT["csv"] = "csv";
  return FORMAT;
}({});
let REPORT_STATE = exports.REPORT_STATE = /*#__PURE__*/function (REPORT_STATE) {
  REPORT_STATE["created"] = "Created";
  REPORT_STATE["error"] = "Error";
  REPORT_STATE["pending"] = "Pending";
  REPORT_STATE["shared"] = "Shared";
  return REPORT_STATE;
}({});
let REPORT_DEFINITION_STATUS = exports.REPORT_DEFINITION_STATUS = /*#__PURE__*/function (REPORT_DEFINITION_STATUS) {
  REPORT_DEFINITION_STATUS["active"] = "Active";
  REPORT_DEFINITION_STATUS["disabled"] = "Disabled";
  return REPORT_DEFINITION_STATUS;
}({});
let DELIVERY_CHANNEL = exports.DELIVERY_CHANNEL = /*#__PURE__*/function (DELIVERY_CHANNEL) {
  DELIVERY_CHANNEL["email"] = "Email";
  DELIVERY_CHANNEL["slack"] = "Slack";
  DELIVERY_CHANNEL["chime"] = "Chime";
  DELIVERY_CHANNEL["opensearchDashboards"] = "OpenSearch Dashboards user";
  return DELIVERY_CHANNEL;
}({});
let SCHEDULE_TYPE = exports.SCHEDULE_TYPE = /*#__PURE__*/function (SCHEDULE_TYPE) {
  SCHEDULE_TYPE["recurring"] = "Recurring";
  SCHEDULE_TYPE["cron"] = "Cron based";
  return SCHEDULE_TYPE;
}({});
let REPORT_TYPE = exports.REPORT_TYPE = /*#__PURE__*/function (REPORT_TYPE) {
  REPORT_TYPE["savedSearch"] = "Saved search";
  REPORT_TYPE["dashboard"] = "Dashboard";
  REPORT_TYPE["visualization"] = "Visualization";
  REPORT_TYPE["notebook"] = "Notebook";
  return REPORT_TYPE;
}({});
let DATA_REPORT_CONFIG = exports.DATA_REPORT_CONFIG = /*#__PURE__*/function (DATA_REPORT_CONFIG) {
  DATA_REPORT_CONFIG["excelDateFormat"] = "MM/DD/YYYY h:mm:ss.SSS a";
  return DATA_REPORT_CONFIG;
}({});
let TRIGGER_TYPE = exports.TRIGGER_TYPE = /*#__PURE__*/function (TRIGGER_TYPE) {
  TRIGGER_TYPE["schedule"] = "Schedule";
  TRIGGER_TYPE["onDemand"] = "On demand";
  return TRIGGER_TYPE;
}({});
let DELIVERY_TYPE = exports.DELIVERY_TYPE = /*#__PURE__*/function (DELIVERY_TYPE) {
  DELIVERY_TYPE["opensearchDashboardsUser"] = "OpenSearch Dashboards user";
  DELIVERY_TYPE["channel"] = "Channel";
  return DELIVERY_TYPE;
}({}); // https://www.elastic.co/guide/en/elasticsearch/reference/6.8/search-request-from-size.html
const DEFAULT_MAX_SIZE = exports.DEFAULT_MAX_SIZE = 10000;
const SECURITY_CONSTANTS = exports.SECURITY_CONSTANTS = {
  TENANT_LOCAL_STORAGE_KEY: 'opendistro::security::tenant::show_popup'
};
const EXTRA_HEADERS = exports.EXTRA_HEADERS = ['cookie', 'x-proxy-user', 'x-proxy-roles', 'x-forwarded-for'];
const BLOCKED_KEYWORD = 'BLOCKED_KEYWORD';
const ipv4Regex = /(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?):([1-9][0-9]{0,3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])/g;
const ipv6Regex = /(([0-9a-fA-F]{1,4}:){7,7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:)|fe80:(:[0-9a-fA-F]{0,4}){0,4}%[0-9a-zA-Z]{1,}|::(ffff(:0{1,4}){0,1}:){0,1}((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])|([0-9a-fA-F]{1,4}:){1,4}:((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9]))/g;
const localhostRegex = /localhost:([1-9][0-9]{0,3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])/g;
const iframeRegex = /iframe/g;
const ALLOWED_HOSTS = exports.ALLOWED_HOSTS = /^(0|0.0.0.0|127.0.0.1|localhost|(.*\.)?(opensearch.org|aws.a2z.com))$/;
const replaceBlockedKeywords = htmlString => {
  // replace <ipv4>:<port>
  htmlString = htmlString.replace(ipv4Regex, BLOCKED_KEYWORD);
  // replace ipv6 addresses
  htmlString = htmlString.replace(ipv6Regex, BLOCKED_KEYWORD);
  // replace iframe keyword
  htmlString = htmlString.replace(iframeRegex, BLOCKED_KEYWORD);
  // replace localhost:<port>
  htmlString = htmlString.replace(localhostRegex, BLOCKED_KEYWORD);
  return htmlString;
};

/**
 * Metric constants
 */
exports.replaceBlockedKeywords = replaceBlockedKeywords;
const WINDOW = exports.WINDOW = 3600;
const INTERVAL = exports.INTERVAL = 60;
const CAPACITY = exports.CAPACITY = WINDOW / INTERVAL * 2;
const GLOBAL_BASIC_COUNTER = exports.GLOBAL_BASIC_COUNTER = {
  report: {
    create: {
      total: 0
    },
    create_from_definition: {
      total: 0
    },
    download: {
      total: 0
    },
    list: {
      total: 0
    },
    info: {
      total: 0
    }
  },
  report_definition: {
    create: {
      total: 0
    },
    list: {
      total: 0
    },
    info: {
      total: 0
    },
    update: {
      total: 0
    },
    delete: {
      total: 0
    }
  },
  report_source: {
    list: {
      total: 0
    }
  },
  dashboard: {
    pdf: {
      download: {
        total: 0
      }
    },
    png: {
      download: {
        total: 0
      }
    }
  },
  visualization: {
    pdf: {
      download: {
        total: 0
      }
    },
    png: {
      download: {
        total: 0
      }
    }
  },
  notebook: {
    pdf: {
      download: {
        count: 0
      }
    },
    png: {
      download: {
        count: 0
      }
    }
  },
  saved_search: {
    csv: {
      download: {
        total: 0
      }
    }
  }
};
const DEFAULT_ROLLING_COUNTER = exports.DEFAULT_ROLLING_COUNTER = {
  report: {
    create: {
      count: 0,
      system_error: 0,
      user_error: 0
    },
    create_from_definition: {
      count: 0,
      system_error: 0,
      user_error: 0
    },
    download: {
      count: 0,
      system_error: 0,
      user_error: 0
    },
    list: {
      count: 0,
      system_error: 0,
      user_error: 0
    },
    info: {
      count: 0,
      system_error: 0,
      user_error: 0
    }
  },
  report_definition: {
    create: {
      count: 0,
      system_error: 0,
      user_error: 0
    },
    list: {
      count: 0,
      system_error: 0,
      user_error: 0
    },
    info: {
      count: 0,
      system_error: 0,
      user_error: 0
    },
    update: {
      count: 0,
      system_error: 0,
      user_error: 0
    },
    delete: {
      count: 0,
      system_error: 0,
      user_error: 0
    }
  },
  report_source: {
    list: {
      count: 0,
      system_error: 0,
      user_error: 0
    }
  },
  dashboard: {
    pdf: {
      download: {
        count: 0
      }
    },
    png: {
      download: {
        count: 0
      }
    }
  },
  visualization: {
    pdf: {
      download: {
        count: 0
      }
    },
    png: {
      download: {
        count: 0
      }
    }
  },
  notebook: {
    pdf: {
      download: {
        count: 0
      }
    },
    png: {
      download: {
        count: 0
      }
    }
  },
  saved_search: {
    csv: {
      download: {
        count: 0
      }
    }
  }
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJuYW1lcyI6WyJGT1JNQVQiLCJleHBvcnRzIiwiUkVQT1JUX1NUQVRFIiwiUkVQT1JUX0RFRklOSVRJT05fU1RBVFVTIiwiREVMSVZFUllfQ0hBTk5FTCIsIlNDSEVEVUxFX1RZUEUiLCJSRVBPUlRfVFlQRSIsIkRBVEFfUkVQT1JUX0NPTkZJRyIsIlRSSUdHRVJfVFlQRSIsIkRFTElWRVJZX1RZUEUiLCJERUZBVUxUX01BWF9TSVpFIiwiU0VDVVJJVFlfQ09OU1RBTlRTIiwiVEVOQU5UX0xPQ0FMX1NUT1JBR0VfS0VZIiwiRVhUUkFfSEVBREVSUyIsIkJMT0NLRURfS0VZV09SRCIsImlwdjRSZWdleCIsImlwdjZSZWdleCIsImxvY2FsaG9zdFJlZ2V4IiwiaWZyYW1lUmVnZXgiLCJBTExPV0VEX0hPU1RTIiwicmVwbGFjZUJsb2NrZWRLZXl3b3JkcyIsImh0bWxTdHJpbmciLCJyZXBsYWNlIiwiV0lORE9XIiwiSU5URVJWQUwiLCJDQVBBQ0lUWSIsIkdMT0JBTF9CQVNJQ19DT1VOVEVSIiwicmVwb3J0IiwiY3JlYXRlIiwidG90YWwiLCJjcmVhdGVfZnJvbV9kZWZpbml0aW9uIiwiZG93bmxvYWQiLCJsaXN0IiwiaW5mbyIsInJlcG9ydF9kZWZpbml0aW9uIiwidXBkYXRlIiwiZGVsZXRlIiwicmVwb3J0X3NvdXJjZSIsImRhc2hib2FyZCIsInBkZiIsInBuZyIsInZpc3VhbGl6YXRpb24iLCJub3RlYm9vayIsImNvdW50Iiwic2F2ZWRfc2VhcmNoIiwiY3N2IiwiREVGQVVMVF9ST0xMSU5HX0NPVU5URVIiLCJzeXN0ZW1fZXJyb3IiLCJ1c2VyX2Vycm9yIl0sInNvdXJjZXMiOlsiY29uc3RhbnRzLnRzIl0sInNvdXJjZXNDb250ZW50IjpbIi8qXG4gKiBDb3B5cmlnaHQgT3BlblNlYXJjaCBDb250cmlidXRvcnNcbiAqIFNQRFgtTGljZW5zZS1JZGVudGlmaWVyOiBBcGFjaGUtMi4wXG4gKi9cblxuaW1wb3J0IHsgQ291bnRlcnNUeXBlIH0gZnJvbSAnLi90eXBlcyc7XG5pbXBvcnQgU2hvd2Rvd24gZnJvbSAnc2hvd2Rvd24nO1xuXG5leHBvcnQgZW51bSBGT1JNQVQge1xuICBwZGYgPSAncGRmJyxcbiAgcG5nID0gJ3BuZycsXG4gIGNzdiA9ICdjc3YnLFxufVxuXG5leHBvcnQgZW51bSBSRVBPUlRfU1RBVEUge1xuICBjcmVhdGVkID0gJ0NyZWF0ZWQnLFxuICBlcnJvciA9ICdFcnJvcicsXG4gIHBlbmRpbmcgPSAnUGVuZGluZycsXG4gIHNoYXJlZCA9ICdTaGFyZWQnLFxufVxuXG5leHBvcnQgZW51bSBSRVBPUlRfREVGSU5JVElPTl9TVEFUVVMge1xuICBhY3RpdmUgPSAnQWN0aXZlJyxcbiAgZGlzYWJsZWQgPSAnRGlzYWJsZWQnLFxufVxuXG5leHBvcnQgZW51bSBERUxJVkVSWV9DSEFOTkVMIHtcbiAgZW1haWwgPSAnRW1haWwnLFxuICBzbGFjayA9ICdTbGFjaycsXG4gIGNoaW1lID0gJ0NoaW1lJyxcbiAgb3BlbnNlYXJjaERhc2hib2FyZHMgPSAnT3BlblNlYXJjaCBEYXNoYm9hcmRzIHVzZXInLFxufVxuXG5leHBvcnQgZW51bSBTQ0hFRFVMRV9UWVBFIHtcbiAgcmVjdXJyaW5nID0gJ1JlY3VycmluZycsXG4gIGNyb24gPSAnQ3JvbiBiYXNlZCcsXG59XG5cbmV4cG9ydCBlbnVtIFJFUE9SVF9UWVBFIHtcbiAgc2F2ZWRTZWFyY2ggPSAnU2F2ZWQgc2VhcmNoJyxcbiAgZGFzaGJvYXJkID0gJ0Rhc2hib2FyZCcsXG4gIHZpc3VhbGl6YXRpb24gPSAnVmlzdWFsaXphdGlvbicsXG4gIG5vdGVib29rID0gJ05vdGVib29rJyxcbn1cblxuZXhwb3J0IGVudW0gREFUQV9SRVBPUlRfQ09ORklHIHtcbiAgZXhjZWxEYXRlRm9ybWF0ID0gJ01NL0REL1lZWVkgaDptbTpzcy5TU1MgYScsXG59XG5cbmV4cG9ydCBlbnVtIFRSSUdHRVJfVFlQRSB7XG4gIHNjaGVkdWxlID0gJ1NjaGVkdWxlJyxcbiAgb25EZW1hbmQgPSAnT24gZGVtYW5kJyxcbn1cblxuZXhwb3J0IGVudW0gREVMSVZFUllfVFlQRSB7XG4gIG9wZW5zZWFyY2hEYXNoYm9hcmRzVXNlciA9ICdPcGVuU2VhcmNoIERhc2hib2FyZHMgdXNlcicsXG4gIGNoYW5uZWwgPSAnQ2hhbm5lbCcsXG59XG5cbi8vIGh0dHBzOi8vd3d3LmVsYXN0aWMuY28vZ3VpZGUvZW4vZWxhc3RpY3NlYXJjaC9yZWZlcmVuY2UvNi44L3NlYXJjaC1yZXF1ZXN0LWZyb20tc2l6ZS5odG1sXG5leHBvcnQgY29uc3QgREVGQVVMVF9NQVhfU0laRSA9IDEwMDAwO1xuXG5leHBvcnQgY29uc3QgU0VDVVJJVFlfQ09OU1RBTlRTID0ge1xuICBURU5BTlRfTE9DQUxfU1RPUkFHRV9LRVk6ICdvcGVuZGlzdHJvOjpzZWN1cml0eTo6dGVuYW50OjpzaG93X3BvcHVwJyxcbn07XG5cbmV4cG9ydCBjb25zdCBFWFRSQV9IRUFERVJTID0gW1xuICAnY29va2llJyxcbiAgJ3gtcHJveHktdXNlcicsXG4gICd4LXByb3h5LXJvbGVzJyxcbiAgJ3gtZm9yd2FyZGVkLWZvcicsXG5dO1xuXG5jb25zdCBCTE9DS0VEX0tFWVdPUkQgPSAnQkxPQ0tFRF9LRVlXT1JEJztcbmNvbnN0IGlwdjRSZWdleCA9IC8oMjVbMC01XXwyWzAtNF1bMC05XXxbMDFdP1swLTldWzAtOV0/KVxcLigyNVswLTVdfDJbMC00XVswLTldfFswMV0/WzAtOV1bMC05XT8pXFwuKDI1WzAtNV18MlswLTRdWzAtOV18WzAxXT9bMC05XVswLTldPylcXC4oMjVbMC01XXwyWzAtNF1bMC05XXxbMDFdP1swLTldWzAtOV0/KTooWzEtOV1bMC05XXswLDN9fFsxLTVdWzAtOV17NH18NlswLTRdWzAtOV17M318NjVbMC00XVswLTldezJ9fDY1NVswLTJdWzAtOV18NjU1M1swLTVdKS9nXG5jb25zdCBpcHY2UmVnZXggPSAvKChbMC05YS1mQS1GXXsxLDR9Oil7Nyw3fVswLTlhLWZBLUZdezEsNH18KFswLTlhLWZBLUZdezEsNH06KXsxLDd9OnwoWzAtOWEtZkEtRl17MSw0fTopezEsNn06WzAtOWEtZkEtRl17MSw0fXwoWzAtOWEtZkEtRl17MSw0fTopezEsNX0oOlswLTlhLWZBLUZdezEsNH0pezEsMn18KFswLTlhLWZBLUZdezEsNH06KXsxLDR9KDpbMC05YS1mQS1GXXsxLDR9KXsxLDN9fChbMC05YS1mQS1GXXsxLDR9Oil7MSwzfSg6WzAtOWEtZkEtRl17MSw0fSl7MSw0fXwoWzAtOWEtZkEtRl17MSw0fTopezEsMn0oOlswLTlhLWZBLUZdezEsNH0pezEsNX18WzAtOWEtZkEtRl17MSw0fTooKDpbMC05YS1mQS1GXXsxLDR9KXsxLDZ9KXw6KCg6WzAtOWEtZkEtRl17MSw0fSl7MSw3fXw6KXxmZTgwOig6WzAtOWEtZkEtRl17MCw0fSl7MCw0fSVbMC05YS16QS1aXXsxLH18OjooZmZmZig6MHsxLDR9KXswLDF9Oil7MCwxfSgoMjVbMC01XXwoMlswLTRdfDF7MCwxfVswLTldKXswLDF9WzAtOV0pXFwuKXszLDN9KDI1WzAtNV18KDJbMC00XXwxezAsMX1bMC05XSl7MCwxfVswLTldKXwoWzAtOWEtZkEtRl17MSw0fTopezEsNH06KCgyNVswLTVdfCgyWzAtNF18MXswLDF9WzAtOV0pezAsMX1bMC05XSlcXC4pezMsM30oMjVbMC01XXwoMlswLTRdfDF7MCwxfVswLTldKXswLDF9WzAtOV0pKS9nO1xuY29uc3QgbG9jYWxob3N0UmVnZXggPSAvbG9jYWxob3N0OihbMS05XVswLTldezAsM318WzEtNV1bMC05XXs0fXw2WzAtNF1bMC05XXszfXw2NVswLTRdWzAtOV17Mn18NjU1WzAtMl1bMC05XXw2NTUzWzAtNV0pL2c7XG5jb25zdCBpZnJhbWVSZWdleCA9IC9pZnJhbWUvZztcblxuZXhwb3J0IGNvbnN0IEFMTE9XRURfSE9TVFMgPSAvXigwfDAuMC4wLjB8MTI3LjAuMC4xfGxvY2FsaG9zdHwoLipcXC4pPyhvcGVuc2VhcmNoLm9yZ3xhd3MuYTJ6LmNvbSkpJC87XG5cbmV4cG9ydCBjb25zdCByZXBsYWNlQmxvY2tlZEtleXdvcmRzID0gKGh0bWxTdHJpbmc6IHN0cmluZykgPT4ge1xuICAvLyByZXBsYWNlIDxpcHY0Pjo8cG9ydD5cbiAgaHRtbFN0cmluZyA9IGh0bWxTdHJpbmcucmVwbGFjZShpcHY0UmVnZXgsIEJMT0NLRURfS0VZV09SRCk7XG4gIC8vIHJlcGxhY2UgaXB2NiBhZGRyZXNzZXNcbiAgaHRtbFN0cmluZyA9IGh0bWxTdHJpbmcucmVwbGFjZShpcHY2UmVnZXgsIEJMT0NLRURfS0VZV09SRCk7XG4gIC8vIHJlcGxhY2UgaWZyYW1lIGtleXdvcmRcbiAgaHRtbFN0cmluZyA9IGh0bWxTdHJpbmcucmVwbGFjZShpZnJhbWVSZWdleCwgQkxPQ0tFRF9LRVlXT1JEKTtcbiAgLy8gcmVwbGFjZSBsb2NhbGhvc3Q6PHBvcnQ+XG4gIGh0bWxTdHJpbmcgPSBodG1sU3RyaW5nLnJlcGxhY2UobG9jYWxob3N0UmVnZXgsIEJMT0NLRURfS0VZV09SRCk7XG4gIHJldHVybiBodG1sU3RyaW5nO1xufVxuXG5cbi8qKlxuICogTWV0cmljIGNvbnN0YW50c1xuICovXG5leHBvcnQgY29uc3QgV0lORE9XID0gMzYwMDtcbmV4cG9ydCBjb25zdCBJTlRFUlZBTCA9IDYwO1xuZXhwb3J0IGNvbnN0IENBUEFDSVRZID0gKFdJTkRPVyAvIElOVEVSVkFMKSAqIDI7XG5cbmV4cG9ydCBjb25zdCBHTE9CQUxfQkFTSUNfQ09VTlRFUjogQ291bnRlcnNUeXBlID0ge1xuICByZXBvcnQ6IHtcbiAgICBjcmVhdGU6IHtcbiAgICAgIHRvdGFsOiAwLFxuICAgIH0sXG4gICAgY3JlYXRlX2Zyb21fZGVmaW5pdGlvbjoge1xuICAgICAgdG90YWw6IDAsXG4gICAgfSxcbiAgICBkb3dubG9hZDoge1xuICAgICAgdG90YWw6IDAsXG4gICAgfSxcbiAgICBsaXN0OiB7XG4gICAgICB0b3RhbDogMCxcbiAgICB9LFxuICAgIGluZm86IHtcbiAgICAgIHRvdGFsOiAwLFxuICAgIH0sXG4gIH0sXG4gIHJlcG9ydF9kZWZpbml0aW9uOiB7XG4gICAgY3JlYXRlOiB7XG4gICAgICB0b3RhbDogMCxcbiAgICB9LFxuICAgIGxpc3Q6IHtcbiAgICAgIHRvdGFsOiAwLFxuICAgIH0sXG4gICAgaW5mbzoge1xuICAgICAgdG90YWw6IDAsXG4gICAgfSxcbiAgICB1cGRhdGU6IHtcbiAgICAgIHRvdGFsOiAwLFxuICAgIH0sXG4gICAgZGVsZXRlOiB7XG4gICAgICB0b3RhbDogMCxcbiAgICB9LFxuICB9LFxuICByZXBvcnRfc291cmNlOiB7XG4gICAgbGlzdDoge1xuICAgICAgdG90YWw6IDAsXG4gICAgfSxcbiAgfSxcbiAgZGFzaGJvYXJkOiB7XG4gICAgcGRmOiB7XG4gICAgICBkb3dubG9hZDoge1xuICAgICAgICB0b3RhbDogMCxcbiAgICAgIH0sXG4gICAgfSxcbiAgICBwbmc6IHtcbiAgICAgIGRvd25sb2FkOiB7XG4gICAgICAgIHRvdGFsOiAwLFxuICAgICAgfSxcbiAgICB9LFxuICB9LFxuICB2aXN1YWxpemF0aW9uOiB7XG4gICAgcGRmOiB7XG4gICAgICBkb3dubG9hZDoge1xuICAgICAgICB0b3RhbDogMCxcbiAgICAgIH0sXG4gICAgfSxcbiAgICBwbmc6IHtcbiAgICAgIGRvd25sb2FkOiB7XG4gICAgICAgIHRvdGFsOiAwLFxuICAgICAgfSxcbiAgICB9LFxuICB9LFxuICBub3RlYm9vazoge1xuICAgIHBkZjoge1xuICAgICAgZG93bmxvYWQ6IHtcbiAgICAgICAgY291bnQ6IDAsXG4gICAgICB9LFxuICAgIH0sXG4gICAgcG5nOiB7XG4gICAgICBkb3dubG9hZDoge1xuICAgICAgICBjb3VudDogMCxcbiAgICAgIH0sXG4gICAgfSxcbiAgfSxcbiAgc2F2ZWRfc2VhcmNoOiB7XG4gICAgY3N2OiB7XG4gICAgICBkb3dubG9hZDoge1xuICAgICAgICB0b3RhbDogMCxcbiAgICAgIH0sXG4gICAgfSxcbiAgfSxcbn07XG5cbmV4cG9ydCBjb25zdCBERUZBVUxUX1JPTExJTkdfQ09VTlRFUjogQ291bnRlcnNUeXBlID0ge1xuICByZXBvcnQ6IHtcbiAgICBjcmVhdGU6IHtcbiAgICAgIGNvdW50OiAwLFxuICAgICAgc3lzdGVtX2Vycm9yOiAwLFxuICAgICAgdXNlcl9lcnJvcjogMCxcbiAgICB9LFxuICAgIGNyZWF0ZV9mcm9tX2RlZmluaXRpb246IHtcbiAgICAgIGNvdW50OiAwLFxuICAgICAgc3lzdGVtX2Vycm9yOiAwLFxuICAgICAgdXNlcl9lcnJvcjogMCxcbiAgICB9LFxuICAgIGRvd25sb2FkOiB7XG4gICAgICBjb3VudDogMCxcbiAgICAgIHN5c3RlbV9lcnJvcjogMCxcbiAgICAgIHVzZXJfZXJyb3I6IDAsXG4gICAgfSxcbiAgICBsaXN0OiB7XG4gICAgICBjb3VudDogMCxcbiAgICAgIHN5c3RlbV9lcnJvcjogMCxcbiAgICAgIHVzZXJfZXJyb3I6IDAsXG4gICAgfSxcbiAgICBpbmZvOiB7XG4gICAgICBjb3VudDogMCxcbiAgICAgIHN5c3RlbV9lcnJvcjogMCxcbiAgICAgIHVzZXJfZXJyb3I6IDAsXG4gICAgfSxcbiAgfSxcbiAgcmVwb3J0X2RlZmluaXRpb246IHtcbiAgICBjcmVhdGU6IHtcbiAgICAgIGNvdW50OiAwLFxuICAgICAgc3lzdGVtX2Vycm9yOiAwLFxuICAgICAgdXNlcl9lcnJvcjogMCxcbiAgICB9LFxuICAgIGxpc3Q6IHtcbiAgICAgIGNvdW50OiAwLFxuICAgICAgc3lzdGVtX2Vycm9yOiAwLFxuICAgICAgdXNlcl9lcnJvcjogMCxcbiAgICB9LFxuICAgIGluZm86IHtcbiAgICAgIGNvdW50OiAwLFxuICAgICAgc3lzdGVtX2Vycm9yOiAwLFxuICAgICAgdXNlcl9lcnJvcjogMCxcbiAgICB9LFxuICAgIHVwZGF0ZToge1xuICAgICAgY291bnQ6IDAsXG4gICAgICBzeXN0ZW1fZXJyb3I6IDAsXG4gICAgICB1c2VyX2Vycm9yOiAwLFxuICAgIH0sXG4gICAgZGVsZXRlOiB7XG4gICAgICBjb3VudDogMCxcbiAgICAgIHN5c3RlbV9lcnJvcjogMCxcbiAgICAgIHVzZXJfZXJyb3I6IDAsXG4gICAgfSxcbiAgfSxcbiAgcmVwb3J0X3NvdXJjZToge1xuICAgIGxpc3Q6IHtcbiAgICAgIGNvdW50OiAwLFxuICAgICAgc3lzdGVtX2Vycm9yOiAwLFxuICAgICAgdXNlcl9lcnJvcjogMCxcbiAgICB9LFxuICB9LFxuICBkYXNoYm9hcmQ6IHtcbiAgICBwZGY6IHtcbiAgICAgIGRvd25sb2FkOiB7XG4gICAgICAgIGNvdW50OiAwLFxuICAgICAgfSxcbiAgICB9LFxuICAgIHBuZzoge1xuICAgICAgZG93bmxvYWQ6IHtcbiAgICAgICAgY291bnQ6IDAsXG4gICAgICB9LFxuICAgIH0sXG4gIH0sXG4gIHZpc3VhbGl6YXRpb246IHtcbiAgICBwZGY6IHtcbiAgICAgIGRvd25sb2FkOiB7XG4gICAgICAgIGNvdW50OiAwLFxuICAgICAgfSxcbiAgICB9LFxuICAgIHBuZzoge1xuICAgICAgZG93bmxvYWQ6IHtcbiAgICAgICAgY291bnQ6IDAsXG4gICAgICB9LFxuICAgIH0sXG4gIH0sXG4gIG5vdGVib29rOiB7XG4gICAgcGRmOiB7XG4gICAgICBkb3dubG9hZDoge1xuICAgICAgICBjb3VudDogMCxcbiAgICAgIH0sXG4gICAgfSxcbiAgICBwbmc6IHtcbiAgICAgIGRvd25sb2FkOiB7XG4gICAgICAgIGNvdW50OiAwLFxuICAgICAgfSxcbiAgICB9LFxuICB9LFxuICBzYXZlZF9zZWFyY2g6IHtcbiAgICBjc3Y6IHtcbiAgICAgIGRvd25sb2FkOiB7XG4gICAgICAgIGNvdW50OiAwLFxuICAgICAgfSxcbiAgICB9LFxuICB9LFxufTtcbiJdLCJtYXBwaW5ncyI6Ijs7Ozs7O0FBQUE7QUFDQTtBQUNBO0FBQ0E7QUFIQSxJQVFZQSxNQUFNLEdBQUFDLE9BQUEsQ0FBQUQsTUFBQSwwQkFBTkEsTUFBTTtFQUFOQSxNQUFNO0VBQU5BLE1BQU07RUFBTkEsTUFBTTtFQUFBLE9BQU5BLE1BQU07QUFBQTtBQUFBLElBTU5FLFlBQVksR0FBQUQsT0FBQSxDQUFBQyxZQUFBLDBCQUFaQSxZQUFZO0VBQVpBLFlBQVk7RUFBWkEsWUFBWTtFQUFaQSxZQUFZO0VBQVpBLFlBQVk7RUFBQSxPQUFaQSxZQUFZO0FBQUE7QUFBQSxJQU9aQyx3QkFBd0IsR0FBQUYsT0FBQSxDQUFBRSx3QkFBQSwwQkFBeEJBLHdCQUF3QjtFQUF4QkEsd0JBQXdCO0VBQXhCQSx3QkFBd0I7RUFBQSxPQUF4QkEsd0JBQXdCO0FBQUE7QUFBQSxJQUt4QkMsZ0JBQWdCLEdBQUFILE9BQUEsQ0FBQUcsZ0JBQUEsMEJBQWhCQSxnQkFBZ0I7RUFBaEJBLGdCQUFnQjtFQUFoQkEsZ0JBQWdCO0VBQWhCQSxnQkFBZ0I7RUFBaEJBLGdCQUFnQjtFQUFBLE9BQWhCQSxnQkFBZ0I7QUFBQTtBQUFBLElBT2hCQyxhQUFhLEdBQUFKLE9BQUEsQ0FBQUksYUFBQSwwQkFBYkEsYUFBYTtFQUFiQSxhQUFhO0VBQWJBLGFBQWE7RUFBQSxPQUFiQSxhQUFhO0FBQUE7QUFBQSxJQUtiQyxXQUFXLEdBQUFMLE9BQUEsQ0FBQUssV0FBQSwwQkFBWEEsV0FBVztFQUFYQSxXQUFXO0VBQVhBLFdBQVc7RUFBWEEsV0FBVztFQUFYQSxXQUFXO0VBQUEsT0FBWEEsV0FBVztBQUFBO0FBQUEsSUFPWEMsa0JBQWtCLEdBQUFOLE9BQUEsQ0FBQU0sa0JBQUEsMEJBQWxCQSxrQkFBa0I7RUFBbEJBLGtCQUFrQjtFQUFBLE9BQWxCQSxrQkFBa0I7QUFBQTtBQUFBLElBSWxCQyxZQUFZLEdBQUFQLE9BQUEsQ0FBQU8sWUFBQSwwQkFBWkEsWUFBWTtFQUFaQSxZQUFZO0VBQVpBLFlBQVk7RUFBQSxPQUFaQSxZQUFZO0FBQUE7QUFBQSxJQUtaQyxhQUFhLEdBQUFSLE9BQUEsQ0FBQVEsYUFBQSwwQkFBYkEsYUFBYTtFQUFiQSxhQUFhO0VBQWJBLGFBQWE7RUFBQSxPQUFiQSxhQUFhO0FBQUEsT0FLekI7QUFDTyxNQUFNQyxnQkFBZ0IsR0FBQVQsT0FBQSxDQUFBUyxnQkFBQSxHQUFHLEtBQUs7QUFFOUIsTUFBTUMsa0JBQWtCLEdBQUFWLE9BQUEsQ0FBQVUsa0JBQUEsR0FBRztFQUNoQ0Msd0JBQXdCLEVBQUU7QUFDNUIsQ0FBQztBQUVNLE1BQU1DLGFBQWEsR0FBQVosT0FBQSxDQUFBWSxhQUFBLEdBQUcsQ0FDM0IsUUFBUSxFQUNSLGNBQWMsRUFDZCxlQUFlLEVBQ2YsaUJBQWlCLENBQ2xCO0FBRUQsTUFBTUMsZUFBZSxHQUFHLGlCQUFpQjtBQUN6QyxNQUFNQyxTQUFTLEdBQUcsd1BBQXdQO0FBQzFRLE1BQU1DLFNBQVMsR0FBRyxzcEJBQXNwQjtBQUN4cUIsTUFBTUMsY0FBYyxHQUFHLG1HQUFtRztBQUMxSCxNQUFNQyxXQUFXLEdBQUcsU0FBUztBQUV0QixNQUFNQyxhQUFhLEdBQUFsQixPQUFBLENBQUFrQixhQUFBLEdBQUcsdUVBQXVFO0FBRTdGLE1BQU1DLHNCQUFzQixHQUFJQyxVQUFrQixJQUFLO0VBQzVEO0VBQ0FBLFVBQVUsR0FBR0EsVUFBVSxDQUFDQyxPQUFPLENBQUNQLFNBQVMsRUFBRUQsZUFBZSxDQUFDO0VBQzNEO0VBQ0FPLFVBQVUsR0FBR0EsVUFBVSxDQUFDQyxPQUFPLENBQUNOLFNBQVMsRUFBRUYsZUFBZSxDQUFDO0VBQzNEO0VBQ0FPLFVBQVUsR0FBR0EsVUFBVSxDQUFDQyxPQUFPLENBQUNKLFdBQVcsRUFBRUosZUFBZSxDQUFDO0VBQzdEO0VBQ0FPLFVBQVUsR0FBR0EsVUFBVSxDQUFDQyxPQUFPLENBQUNMLGNBQWMsRUFBRUgsZUFBZSxDQUFDO0VBQ2hFLE9BQU9PLFVBQVU7QUFDbkIsQ0FBQzs7QUFHRDtBQUNBO0FBQ0E7QUFGQXBCLE9BQUEsQ0FBQW1CLHNCQUFBLEdBQUFBLHNCQUFBO0FBR08sTUFBTUcsTUFBTSxHQUFBdEIsT0FBQSxDQUFBc0IsTUFBQSxHQUFHLElBQUk7QUFDbkIsTUFBTUMsUUFBUSxHQUFBdkIsT0FBQSxDQUFBdUIsUUFBQSxHQUFHLEVBQUU7QUFDbkIsTUFBTUMsUUFBUSxHQUFBeEIsT0FBQSxDQUFBd0IsUUFBQSxHQUFJRixNQUFNLEdBQUdDLFFBQVEsR0FBSSxDQUFDO0FBRXhDLE1BQU1FLG9CQUFrQyxHQUFBekIsT0FBQSxDQUFBeUIsb0JBQUEsR0FBRztFQUNoREMsTUFBTSxFQUFFO0lBQ05DLE1BQU0sRUFBRTtNQUNOQyxLQUFLLEVBQUU7SUFDVCxDQUFDO0lBQ0RDLHNCQUFzQixFQUFFO01BQ3RCRCxLQUFLLEVBQUU7SUFDVCxDQUFDO0lBQ0RFLFFBQVEsRUFBRTtNQUNSRixLQUFLLEVBQUU7SUFDVCxDQUFDO0lBQ0RHLElBQUksRUFBRTtNQUNKSCxLQUFLLEVBQUU7SUFDVCxDQUFDO0lBQ0RJLElBQUksRUFBRTtNQUNKSixLQUFLLEVBQUU7SUFDVDtFQUNGLENBQUM7RUFDREssaUJBQWlCLEVBQUU7SUFDakJOLE1BQU0sRUFBRTtNQUNOQyxLQUFLLEVBQUU7SUFDVCxDQUFDO0lBQ0RHLElBQUksRUFBRTtNQUNKSCxLQUFLLEVBQUU7SUFDVCxDQUFDO0lBQ0RJLElBQUksRUFBRTtNQUNKSixLQUFLLEVBQUU7SUFDVCxDQUFDO0lBQ0RNLE1BQU0sRUFBRTtNQUNOTixLQUFLLEVBQUU7SUFDVCxDQUFDO0lBQ0RPLE1BQU0sRUFBRTtNQUNOUCxLQUFLLEVBQUU7SUFDVDtFQUNGLENBQUM7RUFDRFEsYUFBYSxFQUFFO0lBQ2JMLElBQUksRUFBRTtNQUNKSCxLQUFLLEVBQUU7SUFDVDtFQUNGLENBQUM7RUFDRFMsU0FBUyxFQUFFO0lBQ1RDLEdBQUcsRUFBRTtNQUNIUixRQUFRLEVBQUU7UUFDUkYsS0FBSyxFQUFFO01BQ1Q7SUFDRixDQUFDO0lBQ0RXLEdBQUcsRUFBRTtNQUNIVCxRQUFRLEVBQUU7UUFDUkYsS0FBSyxFQUFFO01BQ1Q7SUFDRjtFQUNGLENBQUM7RUFDRFksYUFBYSxFQUFFO0lBQ2JGLEdBQUcsRUFBRTtNQUNIUixRQUFRLEVBQUU7UUFDUkYsS0FBSyxFQUFFO01BQ1Q7SUFDRixDQUFDO0lBQ0RXLEdBQUcsRUFBRTtNQUNIVCxRQUFRLEVBQUU7UUFDUkYsS0FBSyxFQUFFO01BQ1Q7SUFDRjtFQUNGLENBQUM7RUFDRGEsUUFBUSxFQUFFO0lBQ1JILEdBQUcsRUFBRTtNQUNIUixRQUFRLEVBQUU7UUFDUlksS0FBSyxFQUFFO01BQ1Q7SUFDRixDQUFDO0lBQ0RILEdBQUcsRUFBRTtNQUNIVCxRQUFRLEVBQUU7UUFDUlksS0FBSyxFQUFFO01BQ1Q7SUFDRjtFQUNGLENBQUM7RUFDREMsWUFBWSxFQUFFO0lBQ1pDLEdBQUcsRUFBRTtNQUNIZCxRQUFRLEVBQUU7UUFDUkYsS0FBSyxFQUFFO01BQ1Q7SUFDRjtFQUNGO0FBQ0YsQ0FBQztBQUVNLE1BQU1pQix1QkFBcUMsR0FBQTdDLE9BQUEsQ0FBQTZDLHVCQUFBLEdBQUc7RUFDbkRuQixNQUFNLEVBQUU7SUFDTkMsTUFBTSxFQUFFO01BQ05lLEtBQUssRUFBRSxDQUFDO01BQ1JJLFlBQVksRUFBRSxDQUFDO01BQ2ZDLFVBQVUsRUFBRTtJQUNkLENBQUM7SUFDRGxCLHNCQUFzQixFQUFFO01BQ3RCYSxLQUFLLEVBQUUsQ0FBQztNQUNSSSxZQUFZLEVBQUUsQ0FBQztNQUNmQyxVQUFVLEVBQUU7SUFDZCxDQUFDO0lBQ0RqQixRQUFRLEVBQUU7TUFDUlksS0FBSyxFQUFFLENBQUM7TUFDUkksWUFBWSxFQUFFLENBQUM7TUFDZkMsVUFBVSxFQUFFO0lBQ2QsQ0FBQztJQUNEaEIsSUFBSSxFQUFFO01BQ0pXLEtBQUssRUFBRSxDQUFDO01BQ1JJLFlBQVksRUFBRSxDQUFDO01BQ2ZDLFVBQVUsRUFBRTtJQUNkLENBQUM7SUFDRGYsSUFBSSxFQUFFO01BQ0pVLEtBQUssRUFBRSxDQUFDO01BQ1JJLFlBQVksRUFBRSxDQUFDO01BQ2ZDLFVBQVUsRUFBRTtJQUNkO0VBQ0YsQ0FBQztFQUNEZCxpQkFBaUIsRUFBRTtJQUNqQk4sTUFBTSxFQUFFO01BQ05lLEtBQUssRUFBRSxDQUFDO01BQ1JJLFlBQVksRUFBRSxDQUFDO01BQ2ZDLFVBQVUsRUFBRTtJQUNkLENBQUM7SUFDRGhCLElBQUksRUFBRTtNQUNKVyxLQUFLLEVBQUUsQ0FBQztNQUNSSSxZQUFZLEVBQUUsQ0FBQztNQUNmQyxVQUFVLEVBQUU7SUFDZCxDQUFDO0lBQ0RmLElBQUksRUFBRTtNQUNKVSxLQUFLLEVBQUUsQ0FBQztNQUNSSSxZQUFZLEVBQUUsQ0FBQztNQUNmQyxVQUFVLEVBQUU7SUFDZCxDQUFDO0lBQ0RiLE1BQU0sRUFBRTtNQUNOUSxLQUFLLEVBQUUsQ0FBQztNQUNSSSxZQUFZLEVBQUUsQ0FBQztNQUNmQyxVQUFVLEVBQUU7SUFDZCxDQUFDO0lBQ0RaLE1BQU0sRUFBRTtNQUNOTyxLQUFLLEVBQUUsQ0FBQztNQUNSSSxZQUFZLEVBQUUsQ0FBQztNQUNmQyxVQUFVLEVBQUU7SUFDZDtFQUNGLENBQUM7RUFDRFgsYUFBYSxFQUFFO0lBQ2JMLElBQUksRUFBRTtNQUNKVyxLQUFLLEVBQUUsQ0FBQztNQUNSSSxZQUFZLEVBQUUsQ0FBQztNQUNmQyxVQUFVLEVBQUU7SUFDZDtFQUNGLENBQUM7RUFDRFYsU0FBUyxFQUFFO0lBQ1RDLEdBQUcsRUFBRTtNQUNIUixRQUFRLEVBQUU7UUFDUlksS0FBSyxFQUFFO01BQ1Q7SUFDRixDQUFDO0lBQ0RILEdBQUcsRUFBRTtNQUNIVCxRQUFRLEVBQUU7UUFDUlksS0FBSyxFQUFFO01BQ1Q7SUFDRjtFQUNGLENBQUM7RUFDREYsYUFBYSxFQUFFO0lBQ2JGLEdBQUcsRUFBRTtNQUNIUixRQUFRLEVBQUU7UUFDUlksS0FBSyxFQUFFO01BQ1Q7SUFDRixDQUFDO0lBQ0RILEdBQUcsRUFBRTtNQUNIVCxRQUFRLEVBQUU7UUFDUlksS0FBSyxFQUFFO01BQ1Q7SUFDRjtFQUNGLENBQUM7RUFDREQsUUFBUSxFQUFFO0lBQ1JILEdBQUcsRUFBRTtNQUNIUixRQUFRLEVBQUU7UUFDUlksS0FBSyxFQUFFO01BQ1Q7SUFDRixDQUFDO0lBQ0RILEdBQUcsRUFBRTtNQUNIVCxRQUFRLEVBQUU7UUFDUlksS0FBSyxFQUFFO01BQ1Q7SUFDRjtFQUNGLENBQUM7RUFDREMsWUFBWSxFQUFFO0lBQ1pDLEdBQUcsRUFBRTtNQUNIZCxRQUFRLEVBQUU7UUFDUlksS0FBSyxFQUFFO01BQ1Q7SUFDRjtFQUNGO0FBQ0YsQ0FBQyJ9