/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.geo.algorithm;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import java.util.stream.IntStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.core.common.util.CollectionUtils;

public class PolygonGenerator {
    private static final Logger LOG = LogManager.getLogger(PolygonGenerator.class);

    public static List<double[]> generatePolygon(List<Double> xPool, List<Double> yPool, Random random) {
        if (CollectionUtils.isEmpty(xPool) || CollectionUtils.isEmpty(yPool)) {
            LOG.debug("One of the X or Y list is empty or null. X.size : {} Y.size : {}", xPool, yPool);
            return Collections.emptyList();
        }
        List<Point2D.Double> generatedPolygonPointsList = ValtrAlgorithm.generateRandomConvexPolygon(xPool, yPool, random);
        double[] x = new double[generatedPolygonPointsList.size()];
        double[] y = new double[generatedPolygonPointsList.size()];
        IntStream.range(0, generatedPolygonPointsList.size()).forEach(iterator -> {
            x[iterator] = ((Point2D.Double)generatedPolygonPointsList.get(iterator)).getX();
            y[iterator] = ((Point2D.Double)generatedPolygonPointsList.get(iterator)).getY();
        });
        ArrayList<double[]> pointsList = new ArrayList<double[]>();
        pointsList.add(x);
        pointsList.add(y);
        return pointsList;
    }

    private static class ValtrAlgorithm {
        private ValtrAlgorithm() {
        }

        private static List<Point2D.Double> generateRandomConvexPolygon(List<Double> xPool, List<Double> yPool, Random random) {
            int n = xPool.size();
            Collections.sort(xPool);
            Collections.sort(yPool);
            Double minX = xPool.get(0);
            Double maxX = xPool.get(n - 1);
            Double minY = yPool.get(0);
            Double maxY = yPool.get(n - 1);
            ArrayList<Double> xVec = new ArrayList<Double>(n);
            ArrayList<Double> yVec = new ArrayList<Double>(n);
            double lastTop = minX;
            double lastBot = minX;
            for (int i = 1; i < n - 1; ++i) {
                double x = xPool.get(i);
                if (random.nextBoolean()) {
                    xVec.add(x - lastTop);
                    lastTop = x;
                    continue;
                }
                xVec.add(lastBot - x);
                lastBot = x;
            }
            xVec.add(maxX - lastTop);
            xVec.add(lastBot - maxX);
            double lastLeft = minY;
            double lastRight = minY;
            for (int i = 1; i < n - 1; ++i) {
                double y = yPool.get(i);
                if (random.nextBoolean()) {
                    yVec.add(y - lastLeft);
                    lastLeft = y;
                    continue;
                }
                yVec.add(lastRight - y);
                lastRight = y;
            }
            yVec.add(maxY - lastLeft);
            yVec.add(lastRight - maxY);
            Collections.shuffle(yVec, random);
            ArrayList<Point2D.Double> vec = new ArrayList<Point2D.Double>(n);
            for (int i = 0; i < n; ++i) {
                vec.add(new Point2D.Double((Double)xVec.get(i), (Double)yVec.get(i)));
            }
            Collections.sort(vec, Comparator.comparingDouble(v -> Math.atan2(v.getY(), v.getX())));
            double x = 0.0;
            double y = 0.0;
            double minPolygonX = 0.0;
            double minPolygonY = 0.0;
            ArrayList<Point2D.Double> points = new ArrayList<Point2D.Double>(n);
            for (int i = 0; i < n; ++i) {
                points.add(new Point2D.Double(x, y));
                minPolygonX = Math.min(minPolygonX, x += ((Point2D.Double)vec.get(i)).getX());
                minPolygonY = Math.min(minPolygonY, y += ((Point2D.Double)vec.get(i)).getY());
            }
            double xShift = minX - minPolygonX;
            double yShift = minY - minPolygonY;
            for (int i = 0; i < n; ++i) {
                Point2D.Double p = (Point2D.Double)points.get(i);
                points.set(i, new Point2D.Double(p.x + xShift, p.y + yShift));
            }
            return points;
        }
    }
}

