from enum import IntEnum
from typing import overload, NewType, Optional, Tuple

from OCC.Core.Standard import *
from OCC.Core.NCollection import *
from OCC.Core.GccEnt import *
from OCC.Core.gp import *
from OCC.Core.GccInt import *


class GccAna_Circ2d2TanOn:
    @overload
    def __init__(self, Qualified1: GccEnt_QualifiedCirc, Qualified2: GccEnt_QualifiedCirc, OnLine: gp_Lin2d, Tolerance: float) -> None: ...
    @overload
    def __init__(self, Qualified1: GccEnt_QualifiedCirc, Qualified2: GccEnt_QualifiedLin, OnLine: gp_Lin2d, Tolerance: float) -> None: ...
    @overload
    def __init__(self, Qualified1: GccEnt_QualifiedLin, Qualified2: GccEnt_QualifiedLin, OnLine: gp_Lin2d, Tolerance: float) -> None: ...
    @overload
    def __init__(self, Qualified1: GccEnt_QualifiedCirc, Point2: gp_Pnt2d, OnLine: gp_Lin2d, Tolerance: float) -> None: ...
    @overload
    def __init__(self, Qualified1: GccEnt_QualifiedLin, Point2: gp_Pnt2d, OnLine: gp_Lin2d, Tolerance: float) -> None: ...
    @overload
    def __init__(self, Point1: gp_Pnt2d, Point2: gp_Pnt2d, OnLine: gp_Lin2d, Tolerance: float) -> None: ...
    @overload
    def __init__(self, Qualified1: GccEnt_QualifiedCirc, Qualified2: GccEnt_QualifiedCirc, OnCirc: gp_Circ2d, Tolerance: float) -> None: ...
    @overload
    def __init__(self, Qualified1: GccEnt_QualifiedCirc, Qualified2: GccEnt_QualifiedLin, OnCirc: gp_Circ2d, Tolerance: float) -> None: ...
    @overload
    def __init__(self, Qualified1: GccEnt_QualifiedCirc, Point2: gp_Pnt2d, OnCirc: gp_Circ2d, Tolerance: float) -> None: ...
    @overload
    def __init__(self, Qualified1: GccEnt_QualifiedLin, Qualified2: GccEnt_QualifiedLin, OnCirc: gp_Circ2d, Tolerance: float) -> None: ...
    @overload
    def __init__(self, Qualified1: GccEnt_QualifiedLin, Point2: gp_Pnt2d, OnCirc: gp_Circ2d, Tolerance: float) -> None: ...
    @overload
    def __init__(self, Point1: gp_Pnt2d, Point2: gp_Pnt2d, OnCirc: gp_Circ2d, Tolerance: float) -> None: ...
    def CenterOn3(self, Index: int, PntArg: gp_Pnt2d) -> float: ...
    def IsDone(self) -> bool: ...
    def IsTheSame1(self, Index: int) -> bool: ...
    def IsTheSame2(self, Index: int) -> bool: ...
    def NbSolutions(self) -> int: ...
    def Tangency1(self, Index: int, PntSol: gp_Pnt2d) -> Tuple[float, float]: ...
    def Tangency2(self, Index: int, PntSol: gp_Pnt2d) -> Tuple[float, float]: ...
    def ThisSolution(self, Index: int) -> gp_Circ2d: ...
    def WhichQualifier(self, Index: int, Qualif1: GccEnt_Position, Qualif2: GccEnt_Position) -> None: ...

class GccAna_Circ2d2TanRad:
    @overload
    def __init__(self, Qualified1: GccEnt_QualifiedCirc, Qualified2: GccEnt_QualifiedCirc, Radius: float, Tolerance: float) -> None: ...
    @overload
    def __init__(self, Qualified1: GccEnt_QualifiedCirc, Qualified2: GccEnt_QualifiedLin, Radius: float, Tolerance: float) -> None: ...
    @overload
    def __init__(self, Qualified1: GccEnt_QualifiedCirc, Point2: gp_Pnt2d, Radius: float, Tolerance: float) -> None: ...
    @overload
    def __init__(self, Qualified1: GccEnt_QualifiedLin, Point2: gp_Pnt2d, Radius: float, Tolerance: float) -> None: ...
    @overload
    def __init__(self, Qualified1: GccEnt_QualifiedLin, Qualified2: GccEnt_QualifiedLin, Radius: float, Tolerance: float) -> None: ...
    @overload
    def __init__(self, Point1: gp_Pnt2d, Point2: gp_Pnt2d, Radius: float, Tolerance: float) -> None: ...
    def IsDone(self) -> bool: ...
    def IsTheSame1(self, Index: int) -> bool: ...
    def IsTheSame2(self, Index: int) -> bool: ...
    def NbSolutions(self) -> int: ...
    def Tangency1(self, Index: int, PntSol: gp_Pnt2d) -> Tuple[float, float]: ...
    def Tangency2(self, Index: int, PntSol: gp_Pnt2d) -> Tuple[float, float]: ...
    def ThisSolution(self, Index: int) -> gp_Circ2d: ...
    def WhichQualifier(self, Index: int, Qualif1: GccEnt_Position, Qualif2: GccEnt_Position) -> None: ...

class GccAna_Circ2d3Tan:
    @overload
    def __init__(self, Qualified1: GccEnt_QualifiedCirc, Qualified2: GccEnt_QualifiedCirc, Qualified3: GccEnt_QualifiedCirc, Tolerance: float) -> None: ...
    @overload
    def __init__(self, Qualified1: GccEnt_QualifiedCirc, Qualified2: GccEnt_QualifiedCirc, Qualified3: GccEnt_QualifiedLin, Tolerance: float) -> None: ...
    @overload
    def __init__(self, Qualified1: GccEnt_QualifiedCirc, Qualified2: GccEnt_QualifiedLin, Qualified3: GccEnt_QualifiedLin, Tolerance: float) -> None: ...
    @overload
    def __init__(self, Qualified1: GccEnt_QualifiedLin, Qualified2: GccEnt_QualifiedLin, Qualified3: GccEnt_QualifiedLin, Tolerance: float) -> None: ...
    @overload
    def __init__(self, Qualified1: GccEnt_QualifiedCirc, Qualified2: GccEnt_QualifiedCirc, Point3: gp_Pnt2d, Tolerance: float) -> None: ...
    @overload
    def __init__(self, Qualified1: GccEnt_QualifiedCirc, Qualified2: GccEnt_QualifiedLin, Point3: gp_Pnt2d, Tolerance: float) -> None: ...
    @overload
    def __init__(self, Qualified1: GccEnt_QualifiedLin, Qualified2: GccEnt_QualifiedLin, Point3: gp_Pnt2d, Tolerance: float) -> None: ...
    @overload
    def __init__(self, Qualified1: GccEnt_QualifiedCirc, Point2: gp_Pnt2d, Point3: gp_Pnt2d, Tolerance: float) -> None: ...
    @overload
    def __init__(self, Qualified1: GccEnt_QualifiedLin, Point2: gp_Pnt2d, Point3: gp_Pnt2d, Tolerance: float) -> None: ...
    @overload
    def __init__(self, Point1: gp_Pnt2d, Point2: gp_Pnt2d, Point3: gp_Pnt2d, Tolerance: float) -> None: ...
    def IsDone(self) -> bool: ...
    def IsTheSame1(self, Index: int) -> bool: ...
    def IsTheSame2(self, Index: int) -> bool: ...
    def IsTheSame3(self, Index: int) -> bool: ...
    def NbSolutions(self) -> int: ...
    def Tangency1(self, Index: int, PntSol: gp_Pnt2d) -> Tuple[float, float]: ...
    def Tangency2(self, Index: int, PntSol: gp_Pnt2d) -> Tuple[float, float]: ...
    def Tangency3(self, Index: int, PntSol: gp_Pnt2d) -> Tuple[float, float]: ...
    def ThisSolution(self, Index: int) -> gp_Circ2d: ...
    def WhichQualifier(self, Index: int, Qualif1: GccEnt_Position, Qualif2: GccEnt_Position, Qualif3: GccEnt_Position) -> None: ...

class GccAna_Circ2dBisec:
    def __init__(self, Circ1: gp_Circ2d, Circ2: gp_Circ2d) -> None: ...
    def IsDone(self) -> bool: ...
    def NbSolutions(self) -> int: ...
    def ThisSolution(self, Index: int) -> GccInt_Bisec: ...

class GccAna_Circ2dTanCen:
    @overload
    def __init__(self, Qualified1: GccEnt_QualifiedCirc, Pcenter: gp_Pnt2d, Tolerance: float) -> None: ...
    @overload
    def __init__(self, Linetan: gp_Lin2d, Pcenter: gp_Pnt2d) -> None: ...
    @overload
    def __init__(self, Point1: gp_Pnt2d, Pcenter: gp_Pnt2d) -> None: ...
    def IsDone(self) -> bool: ...
    def IsTheSame1(self, Index: int) -> bool: ...
    def NbSolutions(self) -> int: ...
    def Tangency1(self, Index: int, PntSol: gp_Pnt2d) -> Tuple[float, float]: ...
    def ThisSolution(self, Index: int) -> gp_Circ2d: ...
    def WhichQualifier(self, Index: int, Qualif1: GccEnt_Position) -> None: ...

class GccAna_Circ2dTanOnRad:
    @overload
    def __init__(self, Qualified1: GccEnt_QualifiedCirc, OnLine: gp_Lin2d, Radius: float, Tolerance: float) -> None: ...
    @overload
    def __init__(self, Qualified1: GccEnt_QualifiedLin, OnLine: gp_Lin2d, Radius: float, Tolerance: float) -> None: ...
    @overload
    def __init__(self, Point1: gp_Pnt2d, OnLine: gp_Lin2d, Radius: float, Tolerance: float) -> None: ...
    @overload
    def __init__(self, Qualified1: GccEnt_QualifiedCirc, OnCirc: gp_Circ2d, Radius: float, Tolerance: float) -> None: ...
    @overload
    def __init__(self, Qualified1: GccEnt_QualifiedLin, OnCirc: gp_Circ2d, Radius: float, Tolerance: float) -> None: ...
    @overload
    def __init__(self, Point1: gp_Pnt2d, OnCirc: gp_Circ2d, Radius: float, Tolerance: float) -> None: ...
    def CenterOn3(self, Index: int, PntSol: gp_Pnt2d) -> float: ...
    def IsDone(self) -> bool: ...
    def IsTheSame1(self, Index: int) -> bool: ...
    def NbSolutions(self) -> int: ...
    def Tangency1(self, Index: int, PntSol: gp_Pnt2d) -> Tuple[float, float]: ...
    def ThisSolution(self, Index: int) -> gp_Circ2d: ...
    def WhichQualifier(self, Index: int, Qualif1: GccEnt_Position) -> None: ...

class GccAna_CircLin2dBisec:
    def __init__(self, Circle: gp_Circ2d, Line: gp_Lin2d) -> None: ...
    def IsDone(self) -> bool: ...
    def NbSolutions(self) -> int: ...
    def ThisSolution(self, Index: int) -> GccInt_Bisec: ...

class GccAna_CircPnt2dBisec:
    @overload
    def __init__(self, Circle1: gp_Circ2d, Point2: gp_Pnt2d) -> None: ...
    @overload
    def __init__(self, Circle1: gp_Circ2d, Point2: gp_Pnt2d, Tolerance: float) -> None: ...
    def IsDone(self) -> bool: ...
    def NbSolutions(self) -> int: ...
    def ThisSolution(self, Index: int) -> GccInt_Bisec: ...

class GccAna_Lin2d2Tan:
    @overload
    def __init__(self, ThePoint1: gp_Pnt2d, ThePoint2: gp_Pnt2d, Tolerance: float) -> None: ...
    @overload
    def __init__(self, Qualified1: GccEnt_QualifiedCirc, ThePoint: gp_Pnt2d, Tolerance: float) -> None: ...
    @overload
    def __init__(self, Qualified1: GccEnt_QualifiedCirc, Qualified2: GccEnt_QualifiedCirc, Tolerance: float) -> None: ...
    def IsDone(self) -> bool: ...
    def NbSolutions(self) -> int: ...
    def Tangency1(self, Index: int, PntSol: gp_Pnt2d) -> Tuple[float, float]: ...
    def Tangency2(self, Index: int, PntSol: gp_Pnt2d) -> Tuple[float, float]: ...
    def ThisSolution(self, Index: int) -> gp_Lin2d: ...
    def WhichQualifier(self, Index: int, Qualif1: GccEnt_Position, Qualif2: GccEnt_Position) -> None: ...

class GccAna_Lin2dBisec:
    def __init__(self, Lin1: gp_Lin2d, Lin2: gp_Lin2d) -> None: ...
    def Intersection1(self, Index: int, PntSol: gp_Pnt2d) -> Tuple[float, float]: ...
    def Intersection2(self, Index: int, PntSol: gp_Pnt2d) -> Tuple[float, float]: ...
    def IsDone(self) -> bool: ...
    def NbSolutions(self) -> int: ...
    def ThisSolution(self, Index: int) -> gp_Lin2d: ...

class GccAna_Lin2dTanObl:
    @overload
    def __init__(self, ThePoint: gp_Pnt2d, TheLine: gp_Lin2d, TheAngle: float) -> None: ...
    @overload
    def __init__(self, Qualified1: GccEnt_QualifiedCirc, TheLine: gp_Lin2d, TheAngle: float) -> None: ...
    def Intersection2(self, Index: int, PntSol: gp_Pnt2d) -> Tuple[float, float]: ...
    def IsDone(self) -> bool: ...
    def NbSolutions(self) -> int: ...
    def Tangency1(self, Index: int, PntSol: gp_Pnt2d) -> Tuple[float, float]: ...
    def ThisSolution(self, Index: int) -> gp_Lin2d: ...
    def WhichQualifier(self, Index: int, Qualif1: GccEnt_Position) -> None: ...

class GccAna_Lin2dTanPar:
    @overload
    def __init__(self, ThePoint: gp_Pnt2d, Lin1: gp_Lin2d) -> None: ...
    @overload
    def __init__(self, Qualified1: GccEnt_QualifiedCirc, Lin1: gp_Lin2d) -> None: ...
    def IsDone(self) -> bool: ...
    def NbSolutions(self) -> int: ...
    def Tangency1(self, Index: int, Pnt: gp_Pnt2d) -> Tuple[float, float]: ...
    def ThisSolution(self, Index: int) -> gp_Lin2d: ...
    def WhichQualifier(self, Index: int, Qualif1: GccEnt_Position) -> None: ...

class GccAna_Lin2dTanPer:
    @overload
    def __init__(self, ThePnt: gp_Pnt2d, TheLin: gp_Lin2d) -> None: ...
    @overload
    def __init__(self, ThePnt: gp_Pnt2d, TheCircle: gp_Circ2d) -> None: ...
    @overload
    def __init__(self, Qualified1: GccEnt_QualifiedCirc, TheLin: gp_Lin2d) -> None: ...
    @overload
    def __init__(self, Qualified1: GccEnt_QualifiedCirc, TheCircle: gp_Circ2d) -> None: ...
    def Intersection2(self, Index: int, PntSol: gp_Pnt2d) -> Tuple[float, float]: ...
    def IsDone(self) -> bool: ...
    def NbSolutions(self) -> int: ...
    def Tangency1(self, Index: int, Pnt: gp_Pnt2d) -> Tuple[float, float]: ...
    def ThisSolution(self, Index: int) -> gp_Lin2d: ...
    def WhichQualifier(self, Index: int, Qualif1: GccEnt_Position) -> None: ...

class GccAna_LinPnt2dBisec:
    def __init__(self, Line1: gp_Lin2d, Point2: gp_Pnt2d) -> None: ...
    def IsDone(self) -> bool: ...
    def ThisSolution(self) -> GccInt_Bisec: ...

class GccAna_Pnt2dBisec:
    def __init__(self, Point1: gp_Pnt2d, Point2: gp_Pnt2d) -> None: ...
    def HasSolution(self) -> bool: ...
    def IsDone(self) -> bool: ...
    def ThisSolution(self) -> gp_Lin2d: ...

# harray1 classes
# harray2 classes
# hsequence classes

