"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SerialPort = void 0;
/* istanbul ignore file */
/* eslint-disable max-len */
/* eslint-disable @typescript-eslint/semi */
// This file was copied from https://github.com/serialport/node-serialport/blob/master/packages/serialport/lib/serialport.ts.
const stream_1 = require("@serialport/stream");
const bindings_cpp_1 = require("@serialport/bindings-cpp");
const DetectedBinding = (0, bindings_cpp_1.autoDetect)();
class SerialPort extends stream_1.SerialPortStream {
    static list = DetectedBinding.list;
    static binding = DetectedBinding;
    constructor(options, openCallback) {
        const opts = {
            binding: DetectedBinding,
            ...options,
        };
        super(opts, openCallback);
    }
    async asyncOpen() {
        return new Promise((resolve, reject) => {
            this.open((error) => {
                if (error) {
                    reject(new Error(`Error while opening serialport '${error}'`));
                }
                else {
                    resolve();
                }
            });
        });
    }
    async asyncFlushAndClose() {
        return new Promise((resolve, reject) => {
            this.flush((flushError) => {
                if (flushError) {
                    reject(new Error(`Error while flushing serialport '${flushError}'`));
                }
                else {
                    this.close((closeError) => {
                        if (closeError) {
                            reject(new Error(`Error while closing serialport '${closeError}'`));
                        }
                        else {
                            resolve();
                        }
                    });
                }
            });
        });
    }
}
exports.SerialPort = SerialPort;
//# sourceMappingURL=serialPort.js.map