/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.git;

import javax.annotation.Nonnull;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.protege.editor.core.Fonts;
import org.protege.editor.owl.model.git.GitStatusView;

public class GitStatusViewImpl
implements GitStatusView {
    private final JLabel label = new JLabel();
    private String branchName = "";
    private boolean modified = false;

    public GitStatusViewImpl() {
        this.label.setFont(Fonts.getSmallDialogFont());
    }

    @Override
    public void clear() {
        this.branchName = "";
        this.modified = false;
        this.label.setText("");
    }

    @Override
    public void setBranch(@Nonnull String branchName) {
        if (!this.branchName.equals(branchName)) {
            this.branchName = branchName;
            this.rebuildView();
        }
    }

    @Override
    public void setModified(boolean modified) {
        if (this.modified != modified) {
            this.modified = modified;
            this.rebuildView();
        }
    }

    @Override
    public JComponent asJComponent() {
        return this.label;
    }

    private void rebuildView() {
        StringBuilder sb = new StringBuilder();
        sb.append("<html><body>Git: <span style=\"font-weight: bold;\">");
        sb.append(this.branchName);
        sb.append("</span>");
        if (this.modified) {
            sb.append(" (uncommitted changes to ontologies)");
        }
        sb.append("</body></html>");
        this.label.setText(sb.toString());
    }
}

