/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.view;

import java.awt.Component;
import java.awt.event.HierarchyListener;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.protege.editor.core.ProtegeProperties;
import org.protege.editor.core.ui.RefreshableComponent;
import org.protege.editor.core.ui.view.DisposableAction;
import org.protege.editor.core.ui.view.ViewComponentPlugin;
import org.protege.editor.core.util.HandlerRegistration;
import org.protege.editor.owl.model.event.EventType;
import org.protege.editor.owl.model.event.OWLModelManagerListener;
import org.protege.editor.owl.model.selection.OWLSelectionModelListener;
import org.protege.editor.owl.model.selection.SelectionDriver;
import org.protege.editor.owl.model.selection.SelectionPlane;
import org.protege.editor.owl.ui.renderer.OWLEntityRendererListener;
import org.protege.editor.owl.ui.renderer.RenderingEscapeUtils;
import org.protege.editor.owl.ui.view.AbstractOWLViewComponent;
import org.protege.editor.owl.ui.view.OWLSelectionViewAction;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEntityVisitor;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;

public abstract class AbstractOWLSelectionViewComponent
extends AbstractOWLViewComponent
implements RefreshableComponent {
    private OWLSelectionModelListener listener;
    private Set<OWLSelectionViewAction> registeredActions;
    private boolean initialUpdatePerformed;
    private OWLModelManagerListener modelManagerListener;
    private OWLObject lastDisplayedObject;
    private OWLEntityRendererListener entityRendererListener;
    private HierarchyListener hierarchyListener;
    private boolean needsRefresh;

    @Override
    public final void initialiseOWLView() throws Exception {
        this.registeredActions = new HashSet<OWLSelectionViewAction>();
        this.listener = () -> {
            OWLObject owlObject = this.getOWLWorkspace().getOWLSelectionModel().getSelectedObject();
            if (owlObject instanceof OWLEntity && this.canShowEntity((OWLEntity)owlObject)) {
                this.updateViewContentAndHeader();
            }
        };
        this.entityRendererListener = (entity, renderer) -> {
            if (this.lastDisplayedObject != null && this.lastDisplayedObject.equals((Object)entity)) {
                this.updateHeader(this.lastDisplayedObject);
            }
        };
        this.hierarchyListener = e -> {
            if (this.needsRefresh && this.isShowing()) {
                this.updateViewContentAndHeader();
            }
        };
        this.modelManagerListener = event -> {
            if (event.isType(EventType.ENTITY_RENDERER_CHANGED)) {
                this.getOWLModelManager().getOWLEntityRenderer().addListener(this.entityRendererListener);
            }
        };
        this.addHierarchyListener(this.hierarchyListener);
        this.getOWLModelManager().addListener(this.modelManagerListener);
        this.getOWLModelManager().getOWLEntityRenderer().addListener(this.entityRendererListener);
        this.getOWLWorkspace().getOWLSelectionModel().addListener(this.listener);
        this.initialiseView();
        this.updateViewContentAndHeader();
        if (this instanceof SelectionDriver) {
            this.getSelectionPlane().ifPresent(plane -> {
                HandlerRegistration registration = plane.registerSelectionDriver((SelectionDriver)((Object)this));
                this.addHandlerRegistration(registration);
            });
        }
    }

    private Optional<SelectionPlane> getSelectionPlane() {
        return Optional.ofNullable((SelectionPlane)((Object)SwingUtilities.getAncestorOfClass(SelectionPlane.class, (Component)((Object)this))));
    }

    public void refreshComponent() {
        this.updateHeader(this.lastDisplayedObject);
    }

    protected void setGlobalSelection(OWLEntity owlEntity) {
        if (this.getView() != null && this.getView().isSyncronizing()) {
            if (this instanceof SelectionDriver) {
                this.getSelectionPlane().ifPresent(d -> d.transmitSelection((SelectionDriver)((Object)this), (OWLObject)owlEntity));
            } else {
                this.getOWLWorkspace().getOWLSelectionModel().setSelectedEntity(owlEntity);
            }
        }
    }

    protected void registerSelectionAction(OWLSelectionViewAction action) {
        this.registeredActions.add(action);
    }

    protected void addAction(OWLSelectionViewAction action, String group, String groupIndex) {
        this.registerSelectionAction(action);
        super.addAction((DisposableAction)action, group, groupIndex);
    }

    public abstract void initialiseView() throws Exception;

    @Override
    public final void disposeOWLView() {
        this.registeredActions.clear();
        if (this.listener != null) {
            this.getOWLWorkspace().getOWLSelectionModel().removeListener(this.listener);
        }
        this.removeHierarchyListener(this.hierarchyListener);
        this.getOWLModelManager().removeListener(this.modelManagerListener);
        this.getOWLModelManager().getOWLEntityRenderer().removeListener(this.entityRendererListener);
        this.disposeView();
    }

    public abstract void disposeView();

    protected void disableRegisteredActions() {
        for (OWLSelectionViewAction action : this.registeredActions) {
            action.setEnabled(false);
        }
    }

    protected void updateRegisteredActions() {
        for (OWLSelectionViewAction action : this.registeredActions) {
            action.updateState();
        }
    }

    protected void updateViewContentAndHeader() {
        if (!this.isShowing()) {
            this.needsRefresh = true;
            return;
        }
        this.needsRefresh = false;
        if (this.isPinned() && this.initialUpdatePerformed) {
            return;
        }
        this.initialUpdatePerformed = true;
        if (this.isSynchronizing()) {
            this.lastDisplayedObject = this.updateView();
            this.updateHeader(this.lastDisplayedObject);
        }
    }

    protected void updateHeader(OWLObject object) {
        if (object != null) {
            this.updateRegisteredActions();
            String rendering = this.getOWLModelManager().getDisabmiguatedRendering(object, RenderingEscapeUtils.RenderingEscapeSetting.UNESCAPED_RENDERING);
            this.getView().setHeaderText(rendering);
        } else {
            this.disableRegisteredActions();
            this.getView().setHeaderText("");
        }
    }

    protected abstract OWLObject updateView();

    protected boolean isOWLClassView() {
        return this.canNavigate("org.protege.classcategory");
    }

    protected boolean isOWLObjectPropertyView() {
        return this.canNavigate("org.protege.objectpropertycategory");
    }

    protected boolean isOWLDataPropertyView() {
        return this.canNavigate("org.protege.datapropertycategory");
    }

    protected boolean isOWLIndividualView() {
        return this.canNavigate("org.protege.individualcategory");
    }

    protected boolean isOWLAnnotationPropertyView() {
        return this.canNavigate("org.protege.annotationpropertycategory");
    }

    protected boolean isOWLDatatypeView() {
        return this.canNavigate("org.protege.datatypecategory");
    }

    private boolean canNavigate(String type) {
        ViewComponentPlugin plugin = this.getWorkspace().getViewManager().getViewComponentPlugin(this.getView().getId());
        return plugin != null && plugin.getNavigates().contains(ProtegeProperties.getInstance().getProperty(type));
    }

    public final boolean canShowEntity(OWLEntity owlEntity) {
        return owlEntity != null && new AcceptableEntityVisitor().canShowEntity(owlEntity);
    }

    class AcceptableEntityVisitor
    implements OWLEntityVisitor {
        boolean result;

        AcceptableEntityVisitor() {
        }

        public boolean canShowEntity(OWLEntity owlEntity) {
            this.result = false;
            owlEntity.accept((OWLEntityVisitor)this);
            return this.result;
        }

        public void visit(OWLClass owlClass) {
            this.result = AbstractOWLSelectionViewComponent.this.isOWLClassView();
        }

        public void visit(OWLObjectProperty owlObjectProperty) {
            this.result = AbstractOWLSelectionViewComponent.this.isOWLObjectPropertyView();
        }

        public void visit(OWLDataProperty owlDataProperty) {
            this.result = AbstractOWLSelectionViewComponent.this.isOWLDataPropertyView();
        }

        public void visit(OWLNamedIndividual owlIndividual) {
            this.result = AbstractOWLSelectionViewComponent.this.isOWLIndividualView();
        }

        public void visit(OWLDatatype owlDatatype) {
            this.result = AbstractOWLSelectionViewComponent.this.isOWLDatatypeView();
        }

        public void visit(OWLAnnotationProperty owlAnnotationProperty) {
            this.result = AbstractOWLSelectionViewComponent.this.isOWLAnnotationPropertyView();
        }
    }
}

