"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
exports.getDataStreams = getDataStreams;
exports.getIndexToDataStreamMapping = getIndexToDataStreamMapping;
var _constants = require("../utils/constants");
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return typeof key === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (typeof input !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (typeof res !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); } /*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
class DataStreamService {
  constructor(osDriver) {
    _defineProperty(this, "osDriver", void 0);
    _defineProperty(this, "getDataStreams", async (context, request, response) => {
      try {
        const {
          search
        } = request.query;
        const client = this.osDriver.asScoped(request);
        const [dataStreams, apiAccessible, errMsg] = await getDataStreams(client, search);
        if (!apiAccessible) return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: errMsg
          }
        });
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: {
              dataStreams: dataStreams,
              totalDataStreams: dataStreams.length
            }
          }
        });
      } catch (err) {
        console.error("Index Management - DataStreamService - getDataStreams:", err);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: err.message
          }
        });
      }
    });
    this.osDriver = osDriver;
  }
}
exports.default = DataStreamService;
async function getDataStreams({
  callAsCurrentUser: callWithRequest
}, search) {
  const searchPattern = search ? `*${search}*` : "*";
  let accessible = true;
  let errMsg = "";
  const dataStreamsResponse = await callWithRequest("transport.request", {
    path: `/_data_stream/${searchPattern}`,
    method: "GET"
  }).catch(e => {
    if (e.statusCode === 403 && e.message.startsWith(_constants.SECURITY_EXCEPTION_PREFIX)) {
      accessible = false;
      errMsg = e.message;
      return {
        data_streams: []
      };
    }
    throw e;
  });
  return [dataStreamsResponse["data_streams"], accessible, errMsg];
}
async function getIndexToDataStreamMapping({
  callAsCurrentUser: callWithRequest
}) {
  const [dataStreams] = await getDataStreams({
    callAsCurrentUser: callWithRequest
  });
  const mapping = {};
  dataStreams.forEach(dataStream => {
    dataStream.indices.forEach(index => {
      mapping[index.index_name] = dataStream.name;
    });
  });
  return mapping;
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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