/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.symmetry;

import java.util.Map;
import javajs.util.PT;
import org.jmol.symmetry.SpaceGroup;
import org.jmol.symmetry.SymmetryOperation;
import org.jmol.util.SimpleUnitCell;

class SymmetryInfo {
    boolean coordinatesAreFractional;
    boolean isMultiCell;
    String sgName;
    String sgTitle;
    SymmetryOperation[] symmetryOperations;
    SymmetryOperation[] additionalOperations;
    String infoStr;
    int[] cellRange;
    char latticeType = (char)80;
    public String intlTableNo;
    public String intlTableNoFull;
    private int spaceGroupIndex;
    float[][] spaceGroupF2C;
    private String spaceGroupF2CTitle;
    float[] spaceGroupF2CParams;
    protected String strSUPERCELL;
    private SpaceGroup sgDerived;
    boolean isActive = true;

    SymmetryInfo() {
    }

    float[] setSymmetryInfo(Map<String, Object> modelInfo, float[] unitCellParams, SpaceGroup sg) {
        int symmetryCount;
        if (sg == null) {
            this.spaceGroupIndex = (Integer)modelInfo.get("spaceGroupIndex");
            this.cellRange = (int[])modelInfo.get("unitCellRange");
            this.sgName = (String)modelInfo.get("spaceGroup");
            this.spaceGroupF2C = (float[][])modelInfo.get("f2c");
            this.spaceGroupF2CTitle = (String)modelInfo.get("f2cTitle");
            this.spaceGroupF2CParams = (float[])modelInfo.get("f2cParams");
            this.sgTitle = (String)modelInfo.get("spaceGroupTitle");
            this.strSUPERCELL = (String)modelInfo.get("supercell");
            if (this.sgName == null || this.sgName == "") {
                this.sgName = "spacegroup unspecified";
            }
            this.intlTableNo = (String)modelInfo.get("intlTableNo");
            this.intlTableNoFull = (String)modelInfo.get("intlTableNoFull");
            String s = (String)modelInfo.get("latticeType");
            this.latticeType = (char)(s == null ? 80 : (int)s.charAt(0));
            symmetryCount = modelInfo.containsKey("symmetryCount") ? (Integer)modelInfo.get("symmetryCount") : 0;
            this.symmetryOperations = (SymmetryOperation[])modelInfo.remove("symmetryOps");
            this.coordinatesAreFractional = modelInfo.containsKey("coordinatesAreFractional") ? (Boolean)modelInfo.get("coordinatesAreFractional") : false;
            this.isMultiCell = this.coordinatesAreFractional && this.symmetryOperations != null;
            this.infoStr = "Spacegroup: " + this.sgName;
        } else {
            this.cellRange = null;
            this.sgName = sg.getName();
            this.intlTableNoFull = sg.intlTableNumberFull;
            this.intlTableNo = sg.intlTableNumber;
            this.latticeType = sg.latticeType;
            symmetryCount = sg.getOperationCount();
            this.symmetryOperations = sg.finalOperations;
            this.coordinatesAreFractional = true;
            this.infoStr = "Spacegroup: " + this.sgName;
        }
        if (this.symmetryOperations != null) {
            String c = "";
            String s = "\nNumber of symmetry operations: " + (symmetryCount == 0 ? 1 : symmetryCount) + "\nSymmetry Operations:";
            for (int i = 0; i < symmetryCount; ++i) {
                SymmetryOperation op = this.symmetryOperations[i];
                s = s + "\n" + op.fixMagneticXYZ(op, op.xyz, true);
                if (!op.isCenteringOp) continue;
                c = c + " (" + PT.rep(PT.replaceAllCharacters(op.xyz, "xyz", "0"), "0+", "") + ")";
            }
            if (c.length() > 0) {
                this.infoStr = this.infoStr + "\nCentering: " + c;
            }
            this.infoStr = this.infoStr + s;
            this.infoStr = this.infoStr + "\n";
        }
        if (unitCellParams == null) {
            unitCellParams = (float[])modelInfo.get("unitCellParams");
        }
        Object object = unitCellParams = (Object)(SimpleUnitCell.isValid(unitCellParams) ? unitCellParams : null);
        if (unitCellParams == null) {
            this.coordinatesAreFractional = false;
            this.symmetryOperations = null;
            this.cellRange = null;
            this.infoStr = "";
            modelInfo.remove("unitCellParams");
        }
        return unitCellParams;
    }

    public SymmetryOperation[] getAdditionalOperations() {
        if (this.additionalOperations == null && this.symmetryOperations != null) {
            this.additionalOperations = SymmetryOperation.getAdditionalOperations(this.symmetryOperations);
        }
        return this.additionalOperations;
    }

    public SpaceGroup getDerivedSpaceGroup() {
        if (this.sgDerived == null) {
            this.sgDerived = SpaceGroup.getSpaceGroupFromIndex(this.spaceGroupIndex);
        }
        return this.sgDerived;
    }

    public boolean setIsActiveCell(boolean TF) {
        return this.isActive != TF && (this.isActive = TF);
    }

    public String getSpaceGroupTitle() {
        return this.isActive && this.spaceGroupF2CTitle != null ? this.spaceGroupF2CTitle : (this.sgName.startsWith("cell=") ? this.sgName : this.sgTitle);
    }
}

