
#ifndef KCOMPLETION_EXPORT_H
#define KCOMPLETION_EXPORT_H

#ifdef KCOMPLETION_STATIC_DEFINE
#  define KCOMPLETION_EXPORT
#  define KCOMPLETION_NO_EXPORT
#else
#  ifndef KCOMPLETION_EXPORT
#    ifdef KF6Completion_EXPORTS
        /* We are building this library */
#      define KCOMPLETION_EXPORT __attribute__((visibility("default")))
#    else
        /* We are using this library */
#      define KCOMPLETION_EXPORT __attribute__((visibility("default")))
#    endif
#  endif

#  ifndef KCOMPLETION_NO_EXPORT
#    define KCOMPLETION_NO_EXPORT __attribute__((visibility("hidden")))
#  endif
#endif

#ifndef KCOMPLETION_DECL_DEPRECATED
#  define KCOMPLETION_DECL_DEPRECATED __attribute__ ((__deprecated__))
#endif

#ifndef KCOMPLETION_DECL_DEPRECATED_EXPORT
#  define KCOMPLETION_DECL_DEPRECATED_EXPORT KCOMPLETION_EXPORT KCOMPLETION_DECL_DEPRECATED
#endif

#ifndef KCOMPLETION_DECL_DEPRECATED_NO_EXPORT
#  define KCOMPLETION_DECL_DEPRECATED_NO_EXPORT KCOMPLETION_NO_EXPORT KCOMPLETION_DECL_DEPRECATED
#endif

#if 0 /* DEFINE_NO_DEPRECATED */
#  ifndef KCOMPLETION_NO_DEPRECATED
#    define KCOMPLETION_NO_DEPRECATED
#  endif
#endif
#include <kcompletion_version.h>

#define KCOMPLETION_DECL_DEPRECATED_TEXT(text) __attribute__ ((__deprecated__(text)))

/* Take any defaults from group settings */
#if !defined(KCOMPLETION_NO_DEPRECATED) && !defined(KCOMPLETION_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  ifdef KF_NO_DEPRECATED
#    define KCOMPLETION_NO_DEPRECATED
#  elif defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#    define KCOMPLETION_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#  endif
#endif
#if !defined(KCOMPLETION_DISABLE_DEPRECATED_BEFORE_AND_AT) && defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  define KCOMPLETION_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#endif

#if !defined(KCOMPLETION_NO_DEPRECATED_WARNINGS) && !defined(KCOMPLETION_DEPRECATED_WARNINGS_SINCE)
#  ifdef KF_NO_DEPRECATED_WARNINGS
#    define KCOMPLETION_NO_DEPRECATED_WARNINGS
#  elif defined(KF_DEPRECATED_WARNINGS_SINCE)
#    define KCOMPLETION_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#  endif
#endif
#if !defined(KCOMPLETION_DEPRECATED_WARNINGS_SINCE) && defined(KF_DEPRECATED_WARNINGS_SINCE)
#  define KCOMPLETION_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#endif

#if defined(KCOMPLETION_NO_DEPRECATED)
#  undef KCOMPLETION_DEPRECATED
#  define KCOMPLETION_DEPRECATED_EXPORT KCOMPLETION_EXPORT
#  define KCOMPLETION_DEPRECATED_NO_EXPORT KCOMPLETION_NO_EXPORT
#elif defined(KCOMPLETION_NO_DEPRECATED_WARNINGS)
#  define KCOMPLETION_DEPRECATED
#  define KCOMPLETION_DEPRECATED_EXPORT KCOMPLETION_EXPORT
#  define KCOMPLETION_DEPRECATED_NO_EXPORT KCOMPLETION_NO_EXPORT
#else
#  define KCOMPLETION_DEPRECATED KCOMPLETION_DECL_DEPRECATED
#  define KCOMPLETION_DEPRECATED_EXPORT KCOMPLETION_DECL_DEPRECATED_EXPORT
#  define KCOMPLETION_DEPRECATED_NO_EXPORT KCOMPLETION_DECL_DEPRECATED_NO_EXPORT
#endif

/* No deprecated API had been removed from build */
#define KCOMPLETION_EXCLUDE_DEPRECATED_BEFORE_AND_AT 0

#define KCOMPLETION_BUILD_DEPRECATED_SINCE(major, minor) 1

#ifdef KCOMPLETION_NO_DEPRECATED
#  define KCOMPLETION_DISABLE_DEPRECATED_BEFORE_AND_AT KCOMPLETION_VERSION
#endif
#ifdef KCOMPLETION_NO_DEPRECATED_WARNINGS
#  define KCOMPLETION_DEPRECATED_WARNINGS_SINCE 0
#endif

#ifndef KCOMPLETION_DEPRECATED_WARNINGS_SINCE
#  ifdef KCOMPLETION_DISABLE_DEPRECATED_BEFORE_AND_AT
#    define KCOMPLETION_DEPRECATED_WARNINGS_SINCE KCOMPLETION_DISABLE_DEPRECATED_BEFORE_AND_AT
#  else
#    define KCOMPLETION_DEPRECATED_WARNINGS_SINCE KCOMPLETION_VERSION
#  endif
#endif

#ifndef KCOMPLETION_DISABLE_DEPRECATED_BEFORE_AND_AT
#  define KCOMPLETION_DISABLE_DEPRECATED_BEFORE_AND_AT 0
#endif

#ifdef KCOMPLETION_DEPRECATED
#  define KCOMPLETION_ENABLE_DEPRECATED_SINCE(major, minor) (((major<<16)|(minor<<8)) > KCOMPLETION_DISABLE_DEPRECATED_BEFORE_AND_AT)
#else
#  define KCOMPLETION_ENABLE_DEPRECATED_SINCE(major, minor) 0
#endif

#endif /* KCOMPLETION_EXPORT_H */
