/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.transport;

import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.DocWriteResponse;
import org.opensearch.action.delete.DeleteRequest;
import org.opensearch.action.delete.DeleteResponse;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.get.GetResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.ad.constant.CommonErrorMessages;
import org.opensearch.ad.model.ADTask;
import org.opensearch.ad.model.ADTaskType;
import org.opensearch.ad.model.AnomalyDetectorJob;
import org.opensearch.ad.rest.handler.AnomalyDetectorFunction;
import org.opensearch.ad.settings.AnomalyDetectorSettings;
import org.opensearch.ad.task.ADTaskManager;
import org.opensearch.ad.transport.DeleteAnomalyDetectorAction;
import org.opensearch.ad.transport.DeleteAnomalyDetectorRequest;
import org.opensearch.ad.util.ParseUtils;
import org.opensearch.ad.util.RestHandlerUtils;
import org.opensearch.client.Client;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;

public class DeleteAnomalyDetectorTransportAction
extends HandledTransportAction<DeleteAnomalyDetectorRequest, DeleteResponse> {
    private static final Logger LOG = LogManager.getLogger(DeleteAnomalyDetectorTransportAction.class);
    private final Client client;
    private final ClusterService clusterService;
    private final TransportService transportService;
    private NamedXContentRegistry xContentRegistry;
    private final ADTaskManager adTaskManager;
    private volatile Boolean filterByEnabled;

    @Inject
    public DeleteAnomalyDetectorTransportAction(TransportService transportService, ActionFilters actionFilters, Client client, ClusterService clusterService, Settings settings, NamedXContentRegistry xContentRegistry, ADTaskManager adTaskManager) {
        super(DeleteAnomalyDetectorAction.NAME, transportService, actionFilters, DeleteAnomalyDetectorRequest::new);
        this.transportService = transportService;
        this.client = client;
        this.clusterService = clusterService;
        this.xContentRegistry = xContentRegistry;
        this.adTaskManager = adTaskManager;
        this.filterByEnabled = (Boolean)AnomalyDetectorSettings.FILTER_BY_BACKEND_ROLES.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(AnomalyDetectorSettings.FILTER_BY_BACKEND_ROLES, it -> {
            this.filterByEnabled = it;
        });
    }

    protected void doExecute(Task task, DeleteAnomalyDetectorRequest request, ActionListener<DeleteResponse> actionListener) {
        String detectorId = request.getDetectorID();
        LOG.info("Delete anomaly detector job {}", (Object)detectorId);
        User user = ParseUtils.getUserContext(this.client);
        ActionListener listener = RestHandlerUtils.wrapRestActionListener(actionListener, CommonErrorMessages.FAIL_TO_DELETE_DETECTOR);
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            ParseUtils.resolveUserAndExecute(user, detectorId, this.filterByEnabled, listener, anomalyDetector -> this.adTaskManager.getDetector(detectorId, detector -> {
                if (!detector.isPresent()) {
                    LOG.info("Can't find anomaly detector {}", (Object)detectorId);
                    this.adTaskManager.deleteADTasks(detectorId, () -> this.deleteAnomalyDetectorJobDoc(detectorId, (ActionListener<DeleteResponse>)listener), (ActionListener<DeleteResponse>)listener);
                    return;
                }
                this.getDetectorJob(detectorId, (ActionListener<DeleteResponse>)listener, () -> this.adTaskManager.getAndExecuteOnLatestDetectorLevelTask(detectorId, ADTaskType.HISTORICAL_DETECTOR_TASK_TYPES, adTask -> {
                    if (adTask.isPresent() && !((ADTask)adTask.get()).isDone()) {
                        listener.onFailure((Exception)new OpenSearchStatusException("Detector is running", RestStatus.INTERNAL_SERVER_ERROR, new Object[0]));
                    } else {
                        this.adTaskManager.deleteADTasks(detectorId, () -> this.deleteAnomalyDetectorJobDoc(detectorId, (ActionListener<DeleteResponse>)listener), (ActionListener<DeleteResponse>)listener);
                    }
                }, this.transportService, true, listener));
            }, listener), this.client, this.clusterService, this.xContentRegistry);
        }
        catch (Exception e) {
            LOG.error((Object)e);
            listener.onFailure(e);
        }
    }

    private void deleteAnomalyDetectorJobDoc(String detectorId, ActionListener<DeleteResponse> listener) {
        LOG.info("Delete anomaly detector job {}", (Object)detectorId);
        DeleteRequest deleteRequest = (DeleteRequest)new DeleteRequest(".opendistro-anomaly-detector-jobs", detectorId).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
        this.client.delete(deleteRequest, ActionListener.wrap(response -> {
            if (response.getResult() == DocWriteResponse.Result.DELETED || response.getResult() == DocWriteResponse.Result.NOT_FOUND) {
                this.deleteDetectorStateDoc(detectorId, listener);
            } else {
                String message = "Fail to delete anomaly detector job " + detectorId;
                LOG.error(message);
                listener.onFailure((Exception)new OpenSearchStatusException(message, RestStatus.INTERNAL_SERVER_ERROR, new Object[0]));
            }
        }, exception -> {
            LOG.error("Failed to delete AD job for " + detectorId, (Throwable)exception);
            if (exception instanceof IndexNotFoundException) {
                this.deleteDetectorStateDoc(detectorId, listener);
            } else {
                LOG.error("Failed to delete anomaly detector job", (Throwable)exception);
                listener.onFailure(exception);
            }
        }));
    }

    private void deleteDetectorStateDoc(String detectorId, ActionListener<DeleteResponse> listener) {
        LOG.info("Delete detector info {}", (Object)detectorId);
        DeleteRequest deleteRequest = new DeleteRequest(".opendistro-anomaly-detection-state", detectorId);
        this.client.delete(deleteRequest, ActionListener.wrap(response -> this.deleteAnomalyDetectorDoc(detectorId, listener), exception -> {
            if (exception instanceof IndexNotFoundException) {
                this.deleteAnomalyDetectorDoc(detectorId, listener);
            } else {
                LOG.error("Failed to delete detector state", (Throwable)exception);
                listener.onFailure(exception);
            }
        }));
    }

    private void deleteAnomalyDetectorDoc(String detectorId, final ActionListener<DeleteResponse> listener) {
        LOG.info("Delete anomaly detector {}", (Object)detectorId);
        DeleteRequest deleteRequest = (DeleteRequest)new DeleteRequest(".opendistro-anomaly-detectors", detectorId).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
        this.client.delete(deleteRequest, (ActionListener)new ActionListener<DeleteResponse>(){

            public void onResponse(DeleteResponse deleteResponse) {
                listener.onResponse((Object)deleteResponse);
            }

            public void onFailure(Exception e) {
                listener.onFailure(e);
            }
        });
    }

    private void getDetectorJob(String detectorId, ActionListener<DeleteResponse> listener, AnomalyDetectorFunction function) {
        if (this.clusterService.state().metadata().indices().containsKey(".opendistro-anomaly-detector-jobs")) {
            GetRequest request = new GetRequest(".opendistro-anomaly-detector-jobs").id(detectorId);
            this.client.get(request, ActionListener.wrap(response -> this.onGetAdJobResponseForWrite((GetResponse)response, listener, function), exception -> {
                LOG.error("Fail to get anomaly detector job: " + detectorId, (Throwable)exception);
                listener.onFailure(exception);
            }));
        } else {
            function.execute();
        }
    }

    private void onGetAdJobResponseForWrite(GetResponse response, ActionListener<DeleteResponse> listener, AnomalyDetectorFunction function) throws IOException {
        String adJobId;
        if (response.isExists() && (adJobId = response.getId()) != null) {
            try (XContentParser parser = RestHandlerUtils.createXContentParserFromRegistry(this.xContentRegistry, response.getSourceAsBytesRef());){
                XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
                AnomalyDetectorJob adJob = AnomalyDetectorJob.parse(parser);
                if (adJob.isEnabled()) {
                    listener.onFailure((Exception)new OpenSearchStatusException("Detector job is running: " + adJobId, RestStatus.BAD_REQUEST, new Object[0]));
                    return;
                }
            }
            catch (IOException e) {
                String message = "Failed to parse anomaly detector job " + adJobId;
                LOG.error(message, (Throwable)e);
            }
        }
        function.execute();
    }
}

