complete -c cargo-public-api -n "__fish_use_subcommand" -l manifest-path -d 'Path to `Cargo.toml`' -r -F
complete -c cargo-public-api -n "__fish_use_subcommand" -s p -l package -d 'Name of package in workspace to list or diff the public API for' -r
complete -c cargo-public-api -n "__fish_use_subcommand" -l omit -d 'Omit specified items' -r -f -a "{blanket-impls	Omit items that belong to Blanket Implementations such as `impl<T> Any for T`\, `impl<T> Borrow<T> for T`\, and `impl<T\, U> Into<U> for T where U: From<T>`,auto-trait-impls	Omit items that belong to Auto Trait Implementations such as `impl Send for ...`\, `impl Sync for ...`\, and `impl Unpin for ...`,auto-derived-impls	Omit items that belong to Auto Derived Implementations such as `Clone`\, `Debug`\, and `Eq`}"
complete -c cargo-public-api -n "__fish_use_subcommand" -s F -l features -d 'Space or comma separated list of features to activate' -r
complete -c cargo-public-api -n "__fish_use_subcommand" -l target -d 'Build for the target triple' -r
complete -c cargo-public-api -n "__fish_use_subcommand" -l color -d 'When to color the output' -r -f -a "{auto	Colors will be used if stdout is a terminal. Colors will not be used if stdout is a regular file,never	Colors will never be used,always	Colors will always be used}"
complete -c cargo-public-api -n "__fish_use_subcommand" -l rustdoc-json -d 'List the public API based on the given rustdoc JSON file' -r
complete -c cargo-public-api -n "__fish_use_subcommand" -l target-dir -d 'Where to put rustdoc JSON build artifacts' -r -F
complete -c cargo-public-api -n "__fish_use_subcommand" -l cap-lints -d 'Forwarded to rustdoc JSON build command' -r
complete -c cargo-public-api -n "__fish_use_subcommand" -s s -l simplified -d 'Omit noisy items. Can be used more than once.'
complete -c cargo-public-api -n "__fish_use_subcommand" -l all-features -d 'Activate all available features'
complete -c cargo-public-api -n "__fish_use_subcommand" -l no-default-features -d 'Do not activate the `default` feature'
complete -c cargo-public-api -n "__fish_use_subcommand" -l verbose -d 'Show detailed info about processing'
complete -c cargo-public-api -n "__fish_use_subcommand" -l debug-sorting -d 'Show the hidden "sorting prefix" that makes items nicely grouped'
complete -c cargo-public-api -n "__fish_use_subcommand" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c cargo-public-api -n "__fish_use_subcommand" -s V -l version -d 'Print version'
complete -c cargo-public-api -n "__fish_use_subcommand" -f -a "diff" -d 'Diff the public API against a published version of the crate, or between commits.'
complete -c cargo-public-api -n "__fish_use_subcommand" -f -a "completions" -d 'Generate completion scripts for many different shells.'
complete -c cargo-public-api -n "__fish_use_subcommand" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c cargo-public-api -n "__fish_seen_subcommand_from diff" -l deny -d 'Exit with failure if the specified API diff is detected' -r -f -a "{all	All forms of API diffs are denied: additions\, changes\, deletions,added	Deny added things in API diffs,changed	Deny changed things in API diffs,removed	Deny removed things in API diffs}"
complete -c cargo-public-api -n "__fish_seen_subcommand_from diff" -l force -d 'Force the diff. For example, when diffing commits, enabling this option will discard working tree changes during git checkouts of other commits'
complete -c cargo-public-api -n "__fish_seen_subcommand_from diff" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c cargo-public-api -n "__fish_seen_subcommand_from completions" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c cargo-public-api -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from diff; and not __fish_seen_subcommand_from completions; and not __fish_seen_subcommand_from help" -f -a "diff" -d 'Diff the public API against a published version of the crate, or between commits.'
complete -c cargo-public-api -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from diff; and not __fish_seen_subcommand_from completions; and not __fish_seen_subcommand_from help" -f -a "completions" -d 'Generate completion scripts for many different shells.'
complete -c cargo-public-api -n "__fish_seen_subcommand_from help; and not __fish_seen_subcommand_from diff; and not __fish_seen_subcommand_from completions; and not __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
