/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.layer;

import java.awt.event.ActionEvent;
import java.util.List;
import java.util.stream.Collectors;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.layer.ImageryLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.MainLayerManager;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;

public class CycleLayerUpAction
extends JosmAction {
    private static final long serialVersionUID = 1L;
    private static final Shortcut cycleUp = Shortcut.registerShortcut("core:cyclelayerup", I18n.tr("Cycle layer up", new Object[0]), 91, 5005);

    public CycleLayerUpAction() {
        super(I18n.tr("Cycle layer up", new Object[0]), "dialogs/next", I18n.tr("Cycle through data layers in an upward direction", new Object[0]), cycleUp, true, "cycle-layer-up", false);
        new ImageProvider("dialogs", "next").getResource().attachImageIcon(this, true);
        this.putValue("ShortDescription", I18n.tr("Cycle through visible layers.", new Object[0]));
        this.putValue("Name", I18n.tr("Cycle layers", new Object[0]));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int sublist;
        MainLayerManager manager = MainApplication.getLayerManager();
        List managerLayers = manager.getLayers().stream().filter(layer -> !(layer instanceof ImageryLayer)).collect(Collectors.toList());
        if (managerLayers.isEmpty()) {
            return;
        }
        int index = managerLayers.indexOf(manager.getActiveLayer());
        int n = sublist = index < managerLayers.size() ? index + 1 : index;
        if (index >= managerLayers.size() - 1) {
            sublist = 0;
        }
        List layers = managerLayers.subList(sublist, managerLayers.size());
        manager.setActiveLayer(layers.stream().filter(Layer::isVisible).filter(tlayer -> !(tlayer instanceof ImageryLayer)).findFirst().orElse(manager.getActiveLayer()));
    }
}

