/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.latex;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import writer2latex.latex.ConverterHelper;
import writer2latex.latex.ConverterPalette;
import writer2latex.latex.LaTeXConfig;
import writer2latex.latex.LaTeXDocument;
import writer2latex.latex.LaTeXDocumentPortion;
import writer2latex.latex.i18n.ClassicI18n;
import writer2latex.latex.util.BeforeAfter;
import writer2latex.latex.util.Context;
import writer2latex.office.OfficeReader;
import writer2latex.office.StyleWithProperties;
import writer2latex.util.ExportNameCollection;
import writer2latex.util.Misc;

public class SectionConverter
extends ConverterHelper {
    private boolean bNeedMulticol = false;
    private boolean bDisplayHiddenText = false;
    private ExportNameCollection fileNames = new ExportNameCollection(true);

    public SectionConverter(OfficeReader ofr, LaTeXConfig config, ConverterPalette palette) {
        super(ofr, config, palette);
        this.bDisplayHiddenText = config.displayHiddenText();
    }

    @Override
    public void appendDeclarations(LaTeXDocumentPortion pack, LaTeXDocumentPortion decl) {
        if (this.bNeedMulticol) {
            pack.append("\\usepackage{multicol}").nl();
        }
    }

    private boolean handleZoteroBibliography(Element node, LaTeXDocumentPortion ldp, Context oc) {
        String sName = node.getAttribute("text:name");
        if (this.config.useBibtex() && this.config.zoteroBibtexFiles().length() > 0 && sName.startsWith("ZOTERO_BIBL")) {
            if (!this.config.noIndex()) {
                int nObjectStart = sName.indexOf(123);
                int nObjectEnd = sName.lastIndexOf(125);
                if (nObjectStart > -1 && nObjectEnd > -1 && nObjectStart < nObjectEnd) {
                    String sJsonObject = sName.substring(nObjectStart, nObjectEnd + 1);
                    JSONObject jo = null;
                    try {
                        jo = new JSONObject(sJsonObject);
                    }
                    catch (JSONException jSONException) {
                        // empty catch block
                    }
                    if (jo != null) {
                        int nCount;
                        JSONArray uncited = null;
                        try {
                            uncited = jo.getJSONArray("uncited");
                        }
                        catch (JSONException jSONException) {
                            // empty catch block
                        }
                        if (uncited != null && (nCount = uncited.length()) > 0) {
                            ldp.append("\\nocite{");
                            for (int nIndex = 0; nIndex < nCount; ++nIndex) {
                                if (nIndex > 0) {
                                    ldp.append(",");
                                }
                                String sURI = null;
                                try {
                                    sURI = uncited.getJSONArray(nIndex).getString(0);
                                }
                                catch (JSONException jSONException) {
                                    // empty catch block
                                }
                                if (sURI == null) continue;
                                int nSlash = sURI.lastIndexOf(47);
                                if (nSlash > 0) {
                                    ldp.append(sURI.substring(nSlash + 1));
                                    continue;
                                }
                                ldp.append(sURI);
                            }
                            ldp.append("}").nl();
                        }
                    }
                }
                ldp.append("\\bibliographystyle{").append(this.config.bibtexStyle()).append("}").nl().append("\\bibliography{").append(this.config.zoteroBibtexFiles()).append("}").nl();
            }
            return true;
        }
        return false;
    }

    private boolean handleJabRefBibliography(Element node, LaTeXDocumentPortion ldp, Context oc) {
        String sName = node.getAttribute("text:name");
        if (this.config.useBibtex() && this.config.jabrefBibtexFiles().length() > 0 && sName.equals("JR_bib")) {
            ldp.append("\\bibliographystyle{").append(this.config.bibtexStyle()).append("}").nl().append("\\bibliography{").append(this.config.jabrefBibtexFiles()).append("}").nl();
            return true;
        }
        return false;
    }

    public void handleSection(Element node, LaTeXDocumentPortion ldp, Context oc) {
        if (!this.bDisplayHiddenText && "none".equals(Misc.getAttribute(node, "text:display"))) {
            return;
        }
        this.palette.getFieldCv().addTarget(node, "|region", ldp);
        String sFileName = null;
        Element source = Misc.getChildByTagName(node, "text:section-source");
        if (this.config.splitLinkedSections() && source != null) {
            sFileName = this.fileNames.getExportName(Misc.removeExtension(Misc.urlDecode(source.getAttribute("xlink:href"))));
        } else if (this.config.splitToplevelSections() && this.isToplevel(node)) {
            sFileName = this.fileNames.getExportName(node.getAttribute("text:name"));
        }
        LaTeXDocumentPortion sectionLdp = ldp;
        if (sFileName != null) {
            LaTeXDocument newDoc = new LaTeXDocument(sFileName, this.config.getWrapLinesAfter(), false);
            if (this.config.getBackend() != 4) {
                newDoc.setEncoding(ClassicI18n.writeJavaEncoding(this.config.getInputencoding()));
            } else {
                newDoc.setEncoding("UTF-8");
            }
            this.palette.addDocument(newDoc);
            sectionLdp = newDoc.getContents();
        }
        String sStyleName = node.getAttribute("text:style-name");
        BeforeAfter ba = new BeforeAfter();
        Context ic = (Context)oc.clone();
        this.applySectionStyle(sStyleName, ba, ic);
        ldp.append(ba.getBefore());
        if (sFileName != null) {
            ldp.append("\\input{").append(sFileName).append("}").nl();
        }
        if (!this.handleZoteroBibliography(node, sectionLdp, ic) && !this.handleJabRefBibliography(node, sectionLdp, ic)) {
            this.palette.getBlockCv().traverseBlockText(node, sectionLdp, ic);
        }
        if (sectionLdp != ldp) {
            sectionLdp.append("\\endinput").nl();
        }
        ldp.append(ba.getAfter());
    }

    private void applySectionStyle(String sStyleName, BeforeAfter ba, Context context) {
        StyleWithProperties style = this.ofr.getSectionStyle(sStyleName);
        if (context.isInMulticols() || style == null || style.getColCount() < 2) {
            return;
        }
        int nCols = style.getColCount();
        this.bNeedMulticol = true;
        context.setInMulticols(true);
        ba.add("\\begin{multicols}{" + (nCols > 10 ? 10 : nCols) + "}\n", "\\end{multicols}\n");
    }

    private boolean isToplevel(Node node) {
        Node parent = node.getParentNode();
        if ("text:section".equals(parent.getNodeName())) {
            return false;
        }
        if ("office:body".equals(parent.getNodeName())) {
            return true;
        }
        return this.isToplevel(parent);
    }
}

