/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.util.gui;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.batik.util.gui.ExtendedGridBagConstraints;
import org.apache.batik.util.gui.resource.ActionMap;
import org.apache.batik.util.gui.resource.ButtonFactory;
import org.apache.batik.util.gui.resource.MissingListenerException;
import org.apache.batik.util.resources.ResourceManager;

public class UserStyleDialog
extends JDialog
implements ActionMap {
    public static final int OK_OPTION = 0;
    public static final int CANCEL_OPTION = 1;
    protected static final String RESOURCES = "org.apache.batik.util.gui.resources.UserStyleDialog";
    protected static ResourceBundle bundle = ResourceBundle.getBundle("org.apache.batik.util.gui.resources.UserStyleDialog", Locale.getDefault());
    protected static ResourceManager resources = new ResourceManager(bundle);
    protected Panel panel;
    protected String chosenPath;
    protected int returnCode;
    protected Map listeners = new HashMap();

    public UserStyleDialog(JFrame jFrame) {
        super(jFrame);
        this.setModal(true);
        this.setTitle(resources.getString("Dialog.title"));
        this.listeners.put("OKButtonAction", new OKButtonAction());
        this.listeners.put("CancelButtonAction", new CancelButtonAction());
        this.panel = new Panel();
        this.getContentPane().add(this.panel);
        this.getContentPane().add((Component)this.createButtonsPanel(), "South");
        this.pack();
    }

    public int showDialog() {
        this.pack();
        this.setVisible(true);
        return this.returnCode;
    }

    public String getPath() {
        return this.chosenPath;
    }

    public void setPath(String string) {
        this.chosenPath = string;
        this.panel.fileTextField.setText(string);
        this.panel.fileCheckBox.setSelected(true);
    }

    protected JPanel createButtonsPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(2));
        ButtonFactory buttonFactory = new ButtonFactory(bundle, this);
        jPanel.add(buttonFactory.createJButton("OKButton"));
        jPanel.add(buttonFactory.createJButton("CancelButton"));
        return jPanel;
    }

    public Action getAction(String string) throws MissingListenerException {
        return (Action)this.listeners.get(string);
    }

    public static class Panel
    extends JPanel {
        protected JCheckBox fileCheckBox;
        protected JLabel fileLabel;
        protected JTextField fileTextField;
        protected JButton browseButton;

        public Panel() {
            super(new GridBagLayout());
            this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), resources.getString("Panel.title")));
            ExtendedGridBagConstraints extendedGridBagConstraints = new ExtendedGridBagConstraints();
            extendedGridBagConstraints.insets = new Insets(5, 5, 5, 5);
            this.fileCheckBox = new JCheckBox(resources.getString("PanelFileCheckBox.text"));
            this.fileCheckBox.addChangeListener(new FileCheckBoxChangeListener());
            extendedGridBagConstraints.weightx = 0.0;
            extendedGridBagConstraints.weighty = 0.0;
            extendedGridBagConstraints.fill = 2;
            extendedGridBagConstraints.setGridBounds(0, 2, 3, 1);
            this.add((Component)this.fileCheckBox, extendedGridBagConstraints);
            this.fileLabel = new JLabel(resources.getString("PanelFileLabel.text"));
            extendedGridBagConstraints.weightx = 0.0;
            extendedGridBagConstraints.weighty = 0.0;
            extendedGridBagConstraints.fill = 2;
            extendedGridBagConstraints.setGridBounds(0, 3, 3, 1);
            this.add((Component)this.fileLabel, extendedGridBagConstraints);
            this.fileTextField = new JTextField(30);
            extendedGridBagConstraints.weightx = 1.0;
            extendedGridBagConstraints.weighty = 0.0;
            extendedGridBagConstraints.fill = 2;
            extendedGridBagConstraints.setGridBounds(0, 4, 2, 1);
            this.add((Component)this.fileTextField, extendedGridBagConstraints);
            ButtonFactory buttonFactory = new ButtonFactory(bundle, null);
            extendedGridBagConstraints.weightx = 0.0;
            extendedGridBagConstraints.weighty = 0.0;
            extendedGridBagConstraints.fill = 0;
            extendedGridBagConstraints.anchor = 13;
            extendedGridBagConstraints.setGridBounds(2, 4, 1, 1);
            this.browseButton = buttonFactory.createJButton("PanelFileBrowseButton");
            this.add((Component)this.browseButton, extendedGridBagConstraints);
            this.browseButton.addActionListener(new FileBrowseButtonAction());
            this.fileLabel.setEnabled(false);
            this.fileTextField.setEnabled(false);
            this.browseButton.setEnabled(false);
        }

        public String getPath() {
            if (this.fileCheckBox.isSelected()) {
                return this.fileTextField.getText();
            }
            return null;
        }

        public void setPath(String string) {
            if (string == null) {
                this.fileTextField.setEnabled(false);
                this.fileCheckBox.setSelected(false);
            } else {
                this.fileTextField.setEnabled(true);
                this.fileTextField.setText(string);
                this.fileCheckBox.setSelected(true);
            }
        }

        protected class FileBrowseButtonAction
        extends AbstractAction {
            protected FileBrowseButtonAction() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser = new JFileChooser(new File("."));
                jFileChooser.setFileHidingEnabled(false);
                int n = jFileChooser.showOpenDialog(Panel.this);
                if (n == 0) {
                    File file = jFileChooser.getSelectedFile();
                    try {
                        Panel.this.fileTextField.setText(file.getCanonicalPath());
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        }

        protected class FileCheckBoxChangeListener
        implements ChangeListener {
            protected FileCheckBoxChangeListener() {
            }

            public void stateChanged(ChangeEvent changeEvent) {
                boolean bl = Panel.this.fileCheckBox.isSelected();
                Panel.this.fileLabel.setEnabled(bl);
                Panel.this.fileTextField.setEnabled(bl);
                Panel.this.browseButton.setEnabled(bl);
            }
        }
    }

    protected class CancelButtonAction
    extends AbstractAction {
        protected CancelButtonAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            UserStyleDialog.this.returnCode = 1;
            UserStyleDialog.this.dispose();
        }
    }

    protected class OKButtonAction
    extends AbstractAction {
        protected OKButtonAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (UserStyleDialog.this.panel.fileCheckBox.isSelected()) {
                String string = UserStyleDialog.this.panel.fileTextField.getText();
                if (string.equals("")) {
                    JOptionPane.showMessageDialog(UserStyleDialog.this, resources.getString("StyleDialogError.text"), resources.getString("StyleDialogError.title"), 0);
                    return;
                }
                File file = new File(string);
                if (file.exists()) {
                    string = file.isDirectory() ? null : "file:" + string;
                }
                UserStyleDialog.this.chosenPath = string;
            } else {
                UserStyleDialog.this.chosenPath = null;
            }
            UserStyleDialog.this.returnCode = 0;
            UserStyleDialog.this.dispose();
        }
    }
}

