/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.resolve;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Stack;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.resolve.IvyNode;
import org.apache.ivy.core.resolve.ResolveData;

public class IvyNodeCallers {
    private Map callersByRootConf = new HashMap();
    private Map allCallers = new HashMap();
    private IvyNode node;

    public IvyNodeCallers(IvyNode ivyNode) {
        this.node = ivyNode;
    }

    public void addCaller(String object, IvyNode ivyNode, String iterator, String object22, String[] stringArray, DependencyDescriptor dependencyDescriptor) {
        Caller caller;
        iterator = ivyNode.getDescriptor();
        ModuleRevisionId moduleRevisionId = ivyNode.getResolvedId();
        if (moduleRevisionId.getModuleId().equals(this.node.getId().getModuleId())) {
            throw new IllegalArgumentException("a module is not authorized to depend on itself: " + this.node.getId());
        }
        HashMap<ModuleRevisionId, Caller> hashMap = (HashMap<ModuleRevisionId, Caller>)this.callersByRootConf.get(object);
        if (hashMap == null) {
            hashMap = new HashMap<ModuleRevisionId, Caller>();
            this.callersByRootConf.put(object, hashMap);
        }
        if ((caller = (Caller)hashMap.get(moduleRevisionId)) == null) {
            caller = new Caller((ModuleDescriptor)((Object)iterator), moduleRevisionId, dependencyDescriptor, ivyNode.canExclude((String)object));
            hashMap.put(moduleRevisionId, caller);
        }
        caller.addConfiguration((String)object22, stringArray);
        object = ivyNode.getRealNode();
        for (Object object22 : ((IvyNode)object).getAllCallersModuleIds()) {
            this.allCallers.put(object22, object);
        }
        this.allCallers.put(moduleRevisionId.getModuleId(), ivyNode);
    }

    public Caller[] getCallers(String object) {
        if ((object = (Map)this.callersByRootConf.get(object)) == null) {
            return new Caller[0];
        }
        return object.values().toArray(new Caller[object.values().size()]);
    }

    public Caller[] getAllRealCallers() {
        HashSet<Caller> hashSet = new HashSet<Caller>();
        for (Object object : this.callersByRootConf.values()) {
            for (Caller caller : object.values()) {
                if (!caller.isRealCaller()) continue;
                hashSet.add(caller);
            }
        }
        HashSet<Caller> hashSet2 = hashSet;
        return hashSet2.toArray(new Caller[hashSet2.size()]);
    }

    public Collection getAllCallersModuleIds() {
        return this.allCallers.keySet();
    }

    void updateFrom(IvyNodeCallers object, String object22, boolean bl) {
        object = (Map)((IvyNodeCallers)object).callersByRootConf.get(object22);
        if (object != null) {
            HashMap<ModuleRevisionId, Object> hashMap = (HashMap<ModuleRevisionId, Object>)this.callersByRootConf.get(object22);
            if (hashMap == null) {
                hashMap = new HashMap<ModuleRevisionId, Object>();
                this.callersByRootConf.put(object22, hashMap);
            }
            for (Object object22 : object.values()) {
                if (hashMap.containsKey(((Caller)object22).getModuleRevisionId())) continue;
                if (!bl) {
                    ((Caller)object22).setRealCaller(false);
                }
                hashMap.put(((Caller)object22).getModuleRevisionId(), object22);
            }
        }
    }

    public IvyNode getDirectCallerFor(ModuleId moduleId) {
        return (IvyNode)this.allCallers.get(moduleId);
    }

    boolean doesCallersExclude(String string, Artifact artifact) {
        return this.doesCallersExclude(string, artifact, new Stack());
    }

    boolean doesCallersExclude(String string, Artifact artifact, Stack stack) {
        int n;
        boolean bl;
        Caller[] callerArray;
        block5: {
            stack.push(this.node.getId());
            callerArray = this.getCallers(string);
            if (callerArray.length != 0) break block5;
            stack.pop();
            return false;
        }
        try {
            bl = true;
            for (n = 0; n < callerArray.length; ++n) {
                if (callerArray[n].canExclude()) break block6;
                stack.pop();
            }
        }
        catch (Throwable throwable) {
            stack.pop();
            throw throwable;
        }
        {
            block7: {
                block6: {
                    return false;
                }
                Object object = callerArray[n].getModuleDescriptor();
                object = this.node.doesExclude((ModuleDescriptor)object, string, callerArray[n].getCallerConfigurations(), callerArray[n].getDependencyDescriptor(), artifact, stack);
                if (object == null) continue;
                if (((Boolean)object).booleanValue()) break block7;
                stack.pop();
                return false;
            }
            bl = false;
            continue;
        }
        n = bl ? 0 : 1;
        stack.pop();
        return n != 0;
    }

    public static class Caller {
        private ModuleDescriptor md;
        private ModuleRevisionId mrid;
        private Map confs = new HashMap();
        private DependencyDescriptor dd;
        private boolean callerCanExclude;
        private boolean real = true;

        public Caller(ModuleDescriptor moduleDescriptor, ModuleRevisionId moduleRevisionId, DependencyDescriptor dependencyDescriptor, boolean bl) {
            this.md = moduleDescriptor;
            this.mrid = moduleRevisionId;
            this.dd = dependencyDescriptor;
            this.callerCanExclude = bl;
        }

        public void addConfiguration(String stringArray, String[] stringArray2) {
            this.updateConfs((String)stringArray, stringArray2);
            stringArray = this.md.getConfiguration((String)stringArray);
            if (stringArray != null && (stringArray = stringArray.getExtends()) != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    this.addConfiguration(stringArray[i], stringArray2);
                }
            }
        }

        private void updateConfs(String string, String[] stringArray) {
            Object object = (String[])this.confs.get(string);
            if (object != null) {
                object = new HashSet<String>(Arrays.asList(object));
                object.addAll(Arrays.asList(stringArray));
                Object object2 = object;
                this.confs.put(string, object2.toArray(new String[object2.size()]));
                return;
            }
            this.confs.put(string, stringArray);
        }

        public String[] getCallerConfigurations() {
            return this.confs.keySet().toArray(new String[this.confs.keySet().size()]);
        }

        public ModuleRevisionId getModuleRevisionId() {
            return this.mrid;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Caller)) {
                return false;
            }
            object = (Caller)object;
            return ((Caller)object).confs.equals(this.confs) && this.mrid.equals(((Caller)object).mrid);
        }

        public int hashCode() {
            int n = 403 + this.confs.hashCode();
            n = n * 13 + this.mrid.hashCode();
            return n;
        }

        public String toString() {
            return this.mrid.toString();
        }

        public ModuleRevisionId getAskedDependencyId(ResolveData resolveData) {
            return this.dd.getDependencyRevisionId();
        }

        public ModuleDescriptor getModuleDescriptor() {
            return this.md;
        }

        public boolean canExclude() {
            return this.callerCanExclude || this.md.canExclude() || this.dd.canExclude();
        }

        public DependencyDescriptor getDependencyDescriptor() {
            return this.dd;
        }

        public void setRealCaller(boolean bl) {
            this.real = bl;
        }

        public boolean isRealCaller() {
            return this.real;
        }
    }
}

