"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.paginateDescribeStackEvents = void 0;
const CloudFormationClient_1 = require("../CloudFormationClient");
const DescribeStackEventsCommand_1 = require("../commands/DescribeStackEventsCommand");
const makePagedClientRequest = async (client, input, ...args) => {
    return await client.send(new DescribeStackEventsCommand_1.DescribeStackEventsCommand(input), ...args);
};
async function* paginateDescribeStackEvents(config, input, ...additionalArguments) {
    let token = config.startingToken || undefined;
    let hasNext = true;
    let page;
    while (hasNext) {
        input.NextToken = token;
        if (config.client instanceof CloudFormationClient_1.CloudFormationClient) {
            page = await makePagedClientRequest(config.client, input, ...additionalArguments);
        }
        else {
            throw new Error("Invalid client, expected CloudFormation | CloudFormationClient");
        }
        yield page;
        const prevToken = token;
        token = page.NextToken;
        hasNext = !!(token && (!config.stopOnSameToken || token !== prevToken));
    }
    return undefined;
}
exports.paginateDescribeStackEvents = paginateDescribeStackEvents;
