import { createAggregatedClient } from "@smithy/smithy-client";
import { CloudFormationClient } from "./CloudFormationClient";
import { ActivateOrganizationsAccessCommand, } from "./commands/ActivateOrganizationsAccessCommand";
import { ActivateTypeCommand, } from "./commands/ActivateTypeCommand";
import { BatchDescribeTypeConfigurationsCommand, } from "./commands/BatchDescribeTypeConfigurationsCommand";
import { CancelUpdateStackCommand, } from "./commands/CancelUpdateStackCommand";
import { ContinueUpdateRollbackCommand, } from "./commands/ContinueUpdateRollbackCommand";
import { CreateChangeSetCommand, } from "./commands/CreateChangeSetCommand";
import { CreateStackCommand } from "./commands/CreateStackCommand";
import { CreateStackInstancesCommand, } from "./commands/CreateStackInstancesCommand";
import { CreateStackSetCommand, } from "./commands/CreateStackSetCommand";
import { DeactivateOrganizationsAccessCommand, } from "./commands/DeactivateOrganizationsAccessCommand";
import { DeactivateTypeCommand, } from "./commands/DeactivateTypeCommand";
import { DeleteChangeSetCommand, } from "./commands/DeleteChangeSetCommand";
import { DeleteStackCommand } from "./commands/DeleteStackCommand";
import { DeleteStackInstancesCommand, } from "./commands/DeleteStackInstancesCommand";
import { DeleteStackSetCommand, } from "./commands/DeleteStackSetCommand";
import { DeregisterTypeCommand, } from "./commands/DeregisterTypeCommand";
import { DescribeAccountLimitsCommand, } from "./commands/DescribeAccountLimitsCommand";
import { DescribeChangeSetCommand, } from "./commands/DescribeChangeSetCommand";
import { DescribeChangeSetHooksCommand, } from "./commands/DescribeChangeSetHooksCommand";
import { DescribeOrganizationsAccessCommand, } from "./commands/DescribeOrganizationsAccessCommand";
import { DescribePublisherCommand, } from "./commands/DescribePublisherCommand";
import { DescribeStackDriftDetectionStatusCommand, } from "./commands/DescribeStackDriftDetectionStatusCommand";
import { DescribeStackEventsCommand, } from "./commands/DescribeStackEventsCommand";
import { DescribeStackInstanceCommand, } from "./commands/DescribeStackInstanceCommand";
import { DescribeStackResourceCommand, } from "./commands/DescribeStackResourceCommand";
import { DescribeStackResourceDriftsCommand, } from "./commands/DescribeStackResourceDriftsCommand";
import { DescribeStackResourcesCommand, } from "./commands/DescribeStackResourcesCommand";
import { DescribeStacksCommand, } from "./commands/DescribeStacksCommand";
import { DescribeStackSetCommand, } from "./commands/DescribeStackSetCommand";
import { DescribeStackSetOperationCommand, } from "./commands/DescribeStackSetOperationCommand";
import { DescribeTypeCommand, } from "./commands/DescribeTypeCommand";
import { DescribeTypeRegistrationCommand, } from "./commands/DescribeTypeRegistrationCommand";
import { DetectStackDriftCommand, } from "./commands/DetectStackDriftCommand";
import { DetectStackResourceDriftCommand, } from "./commands/DetectStackResourceDriftCommand";
import { DetectStackSetDriftCommand, } from "./commands/DetectStackSetDriftCommand";
import { EstimateTemplateCostCommand, } from "./commands/EstimateTemplateCostCommand";
import { ExecuteChangeSetCommand, } from "./commands/ExecuteChangeSetCommand";
import { GetStackPolicyCommand, } from "./commands/GetStackPolicyCommand";
import { GetTemplateCommand } from "./commands/GetTemplateCommand";
import { GetTemplateSummaryCommand, } from "./commands/GetTemplateSummaryCommand";
import { ImportStacksToStackSetCommand, } from "./commands/ImportStacksToStackSetCommand";
import { ListChangeSetsCommand, } from "./commands/ListChangeSetsCommand";
import { ListExportsCommand } from "./commands/ListExportsCommand";
import { ListImportsCommand } from "./commands/ListImportsCommand";
import { ListStackInstanceResourceDriftsCommand, } from "./commands/ListStackInstanceResourceDriftsCommand";
import { ListStackInstancesCommand, } from "./commands/ListStackInstancesCommand";
import { ListStackResourcesCommand, } from "./commands/ListStackResourcesCommand";
import { ListStacksCommand } from "./commands/ListStacksCommand";
import { ListStackSetOperationResultsCommand, } from "./commands/ListStackSetOperationResultsCommand";
import { ListStackSetOperationsCommand, } from "./commands/ListStackSetOperationsCommand";
import { ListStackSetsCommand, } from "./commands/ListStackSetsCommand";
import { ListTypeRegistrationsCommand, } from "./commands/ListTypeRegistrationsCommand";
import { ListTypesCommand } from "./commands/ListTypesCommand";
import { ListTypeVersionsCommand, } from "./commands/ListTypeVersionsCommand";
import { PublishTypeCommand } from "./commands/PublishTypeCommand";
import { RecordHandlerProgressCommand, } from "./commands/RecordHandlerProgressCommand";
import { RegisterPublisherCommand, } from "./commands/RegisterPublisherCommand";
import { RegisterTypeCommand, } from "./commands/RegisterTypeCommand";
import { RollbackStackCommand, } from "./commands/RollbackStackCommand";
import { SetStackPolicyCommand, } from "./commands/SetStackPolicyCommand";
import { SetTypeConfigurationCommand, } from "./commands/SetTypeConfigurationCommand";
import { SetTypeDefaultVersionCommand, } from "./commands/SetTypeDefaultVersionCommand";
import { SignalResourceCommand, } from "./commands/SignalResourceCommand";
import { StopStackSetOperationCommand, } from "./commands/StopStackSetOperationCommand";
import { TestTypeCommand } from "./commands/TestTypeCommand";
import { UpdateStackCommand } from "./commands/UpdateStackCommand";
import { UpdateStackInstancesCommand, } from "./commands/UpdateStackInstancesCommand";
import { UpdateStackSetCommand, } from "./commands/UpdateStackSetCommand";
import { UpdateTerminationProtectionCommand, } from "./commands/UpdateTerminationProtectionCommand";
import { ValidateTemplateCommand, } from "./commands/ValidateTemplateCommand";
const commands = {
    ActivateOrganizationsAccessCommand,
    ActivateTypeCommand,
    BatchDescribeTypeConfigurationsCommand,
    CancelUpdateStackCommand,
    ContinueUpdateRollbackCommand,
    CreateChangeSetCommand,
    CreateStackCommand,
    CreateStackInstancesCommand,
    CreateStackSetCommand,
    DeactivateOrganizationsAccessCommand,
    DeactivateTypeCommand,
    DeleteChangeSetCommand,
    DeleteStackCommand,
    DeleteStackInstancesCommand,
    DeleteStackSetCommand,
    DeregisterTypeCommand,
    DescribeAccountLimitsCommand,
    DescribeChangeSetCommand,
    DescribeChangeSetHooksCommand,
    DescribeOrganizationsAccessCommand,
    DescribePublisherCommand,
    DescribeStackDriftDetectionStatusCommand,
    DescribeStackEventsCommand,
    DescribeStackInstanceCommand,
    DescribeStackResourceCommand,
    DescribeStackResourceDriftsCommand,
    DescribeStackResourcesCommand,
    DescribeStacksCommand,
    DescribeStackSetCommand,
    DescribeStackSetOperationCommand,
    DescribeTypeCommand,
    DescribeTypeRegistrationCommand,
    DetectStackDriftCommand,
    DetectStackResourceDriftCommand,
    DetectStackSetDriftCommand,
    EstimateTemplateCostCommand,
    ExecuteChangeSetCommand,
    GetStackPolicyCommand,
    GetTemplateCommand,
    GetTemplateSummaryCommand,
    ImportStacksToStackSetCommand,
    ListChangeSetsCommand,
    ListExportsCommand,
    ListImportsCommand,
    ListStackInstanceResourceDriftsCommand,
    ListStackInstancesCommand,
    ListStackResourcesCommand,
    ListStacksCommand,
    ListStackSetOperationResultsCommand,
    ListStackSetOperationsCommand,
    ListStackSetsCommand,
    ListTypeRegistrationsCommand,
    ListTypesCommand,
    ListTypeVersionsCommand,
    PublishTypeCommand,
    RecordHandlerProgressCommand,
    RegisterPublisherCommand,
    RegisterTypeCommand,
    RollbackStackCommand,
    SetStackPolicyCommand,
    SetTypeConfigurationCommand,
    SetTypeDefaultVersionCommand,
    SignalResourceCommand,
    StopStackSetOperationCommand,
    TestTypeCommand,
    UpdateStackCommand,
    UpdateStackInstancesCommand,
    UpdateStackSetCommand,
    UpdateTerminationProtectionCommand,
    ValidateTemplateCommand,
};
export class CloudFormation extends CloudFormationClient {
}
createAggregatedClient(commands, CloudFormation);
