import { EndpointParameterInstructions } from "@smithy/middleware-endpoint";
import { Command as $Command } from "@smithy/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@smithy/types";
import { CloudFormationClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../CloudFormationClient";
import { ListStackSetOperationsInput, ListStackSetOperationsOutput } from "../models/models_0";
/**
 * @public
 */
export { __MetadataBearer, $Command };
/**
 * @public
 *
 * The input for {@link ListStackSetOperationsCommand}.
 */
export interface ListStackSetOperationsCommandInput extends ListStackSetOperationsInput {
}
/**
 * @public
 *
 * The output of {@link ListStackSetOperationsCommand}.
 */
export interface ListStackSetOperationsCommandOutput extends ListStackSetOperationsOutput, __MetadataBearer {
}
/**
 * @public
 * <p>Returns summary information about operations performed on a stack set.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { CloudFormationClient, ListStackSetOperationsCommand } from "@aws-sdk/client-cloudformation"; // ES Modules import
 * // const { CloudFormationClient, ListStackSetOperationsCommand } = require("@aws-sdk/client-cloudformation"); // CommonJS import
 * const client = new CloudFormationClient(config);
 * const input = { // ListStackSetOperationsInput
 *   StackSetName: "STRING_VALUE", // required
 *   NextToken: "STRING_VALUE",
 *   MaxResults: Number("int"),
 *   CallAs: "SELF" || "DELEGATED_ADMIN",
 * };
 * const command = new ListStackSetOperationsCommand(input);
 * const response = await client.send(command);
 * // { // ListStackSetOperationsOutput
 * //   Summaries: [ // StackSetOperationSummaries
 * //     { // StackSetOperationSummary
 * //       OperationId: "STRING_VALUE",
 * //       Action: "CREATE" || "UPDATE" || "DELETE" || "DETECT_DRIFT",
 * //       Status: "RUNNING" || "SUCCEEDED" || "FAILED" || "STOPPING" || "STOPPED" || "QUEUED",
 * //       CreationTimestamp: new Date("TIMESTAMP"),
 * //       EndTimestamp: new Date("TIMESTAMP"),
 * //       StatusReason: "STRING_VALUE",
 * //       StatusDetails: { // StackSetOperationStatusDetails
 * //         FailedStackInstancesCount: Number("int"),
 * //       },
 * //       OperationPreferences: { // StackSetOperationPreferences
 * //         RegionConcurrencyType: "SEQUENTIAL" || "PARALLEL",
 * //         RegionOrder: [ // RegionList
 * //           "STRING_VALUE",
 * //         ],
 * //         FailureToleranceCount: Number("int"),
 * //         FailureTolerancePercentage: Number("int"),
 * //         MaxConcurrentCount: Number("int"),
 * //         MaxConcurrentPercentage: Number("int"),
 * //         ConcurrencyMode: "STRICT_FAILURE_TOLERANCE" || "SOFT_FAILURE_TOLERANCE",
 * //       },
 * //     },
 * //   ],
 * //   NextToken: "STRING_VALUE",
 * // };
 *
 * ```
 *
 * @param ListStackSetOperationsCommandInput - {@link ListStackSetOperationsCommandInput}
 * @returns {@link ListStackSetOperationsCommandOutput}
 * @see {@link ListStackSetOperationsCommandInput} for command's `input` shape.
 * @see {@link ListStackSetOperationsCommandOutput} for command's `response` shape.
 * @see {@link CloudFormationClientResolvedConfig | config} for CloudFormationClient's `config` shape.
 *
 * @throws {@link StackSetNotFoundException} (client fault)
 *  <p>The specified stack set doesn't exist.</p>
 *
 * @throws {@link CloudFormationServiceException}
 * <p>Base exception class for all service exceptions from CloudFormation service.</p>
 *
 */
export declare class ListStackSetOperationsCommand extends $Command<ListStackSetOperationsCommandInput, ListStackSetOperationsCommandOutput, CloudFormationClientResolvedConfig> {
    readonly input: ListStackSetOperationsCommandInput;
    static getEndpointParameterInstructions(): EndpointParameterInstructions;
    /**
     * @public
     */
    constructor(input: ListStackSetOperationsCommandInput);
    /**
     * @internal
     */
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: CloudFormationClientResolvedConfig, options?: __HttpHandlerOptions): Handler<ListStackSetOperationsCommandInput, ListStackSetOperationsCommandOutput>;
    /**
     * @internal
     */
    private serialize;
    /**
     * @internal
     */
    private deserialize;
}
