"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AdaptiveRetryStrategy = void 0;
const config_1 = require("./config");
const DefaultRateLimiter_1 = require("./DefaultRateLimiter");
const StandardRetryStrategy_1 = require("./StandardRetryStrategy");
class AdaptiveRetryStrategy {
    constructor(maxAttemptsProvider, options) {
        this.maxAttemptsProvider = maxAttemptsProvider;
        this.mode = config_1.RETRY_MODES.ADAPTIVE;
        const { rateLimiter } = options !== null && options !== void 0 ? options : {};
        this.rateLimiter = rateLimiter !== null && rateLimiter !== void 0 ? rateLimiter : new DefaultRateLimiter_1.DefaultRateLimiter();
        this.standardRetryStrategy = new StandardRetryStrategy_1.StandardRetryStrategy(maxAttemptsProvider);
    }
    async acquireInitialRetryToken(retryTokenScope) {
        await this.rateLimiter.getSendToken();
        return this.standardRetryStrategy.acquireInitialRetryToken(retryTokenScope);
    }
    async refreshRetryTokenForRetry(tokenToRenew, errorInfo) {
        this.rateLimiter.updateClientSendingRate(errorInfo);
        return this.standardRetryStrategy.refreshRetryTokenForRetry(tokenToRenew, errorInfo);
    }
    recordSuccess(token) {
        this.rateLimiter.updateClientSendingRate({});
        this.standardRetryStrategy.recordSuccess(token);
    }
}
exports.AdaptiveRetryStrategy = AdaptiveRetryStrategy;
