/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.targets.indy;

import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import org.jruby.RubyClass;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.ir.targets.indy.ClassSuperInvokeSite;
import org.jruby.ir.targets.indy.InstanceSuperInvokeSite;
import org.jruby.ir.targets.indy.InvokeSite;
import org.jruby.ir.targets.indy.SelfInvokeSite;
import org.jruby.runtime.CallType;
import org.jruby.util.JavaNameMangler;

public abstract class ResolvedSuperInvokeSite
extends SelfInvokeSite {
    protected final String superName;
    protected final boolean[] splatMap;

    public ResolvedSuperInvokeSite(MethodType type2, String superName, String splatmapString, int flags2, String file2, int line) {
        super(type2, superName, CallType.SUPER, flags2, file2, line);
        this.superName = superName;
        this.splatMap = IRRuntimeHelpers.decodeSplatmap(splatmapString);
    }

    public static CallSite bootstrap(MethodHandles.Lookup lookup, String name2, MethodType type2, String splatmapString, int flags2, String file2, int line) {
        ResolvedSuperInvokeSite site;
        String[] targetAndMethod = name2.split(":");
        String superName = JavaNameMangler.demangleMethodName(targetAndMethod[1]);
        switch (targetAndMethod[0]) {
            case "invokeInstanceSuper": {
                site = new InstanceSuperInvokeSite(type2, superName, splatmapString, flags2, file2, line);
                break;
            }
            case "invokeClassSuper": {
                site = new ClassSuperInvokeSite(type2, superName, splatmapString, flags2, file2, line);
                break;
            }
            default: {
                throw new RuntimeException("invalid super call: " + name2);
            }
        }
        return InvokeSite.bootstrap(site, lookup);
    }

    protected abstract RubyClass getSuperClass(RubyClass var1);
}

