"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.eventRoutes = eventRoutes;
var _configSchema = require("@osd/config-schema");
var _common = require("../../common");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function eventRoutes(router) {
  router.get({
    path: `${_common.NODE_API.GET_EVENT}/{eventId}`,
    validate: {
      params: _configSchema.schema.object({
        eventId: _configSchema.schema.string()
      })
    }
  }, async (context, request, response) => {
    // @ts-ignore
    const client = context.notificationsContext.notificationsClient.asScoped(request);
    try {
      const resp = await client.callAsCurrentUser('notifications.getEventById', {
        eventId: request.params.eventId
      });
      return response.ok({
        body: resp
      });
    } catch (error) {
      return response.custom({
        statusCode: error.statusCode || 500,
        body: error.message
      });
    }
  });
  router.post({
    path: `${_common.NODE_API.SEND_TEST_MESSAGE}/{configId}`,
    validate: {
      params: _configSchema.schema.object({
        configId: _configSchema.schema.string()
      })
    }
  }, async (context, request, response) => {
    // @ts-ignore
    const client = context.notificationsContext.notificationsClient.asScoped(request);
    try {
      const resp = await client.callAsCurrentUser('notifications.sendTestMessage', {
        configId: request.params.configId
      });
      return response.ok({
        body: resp
      });
    } catch (error) {
      return response.custom({
        statusCode: error.statusCode || 500,
        body: error.message
      });
    }
  });
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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