"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.notificationServiceMock = exports.mainStateMock = exports.coreServicesMock = void 0;
var _services = require("../../public/services");
var _constants = require("../../public/utils/constants");
var _httpClientMock = _interopRequireDefault(require("./httpClientMock"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const coreServicesMock = exports.coreServicesMock = {
  uiSettings: {
    get: jest.fn()
  },
  chrome: {
    setBreadcrumbs: jest.fn()
  },
  notifications: {
    toasts: {
      addDanger: jest.fn().mockName('addDanger'),
      addSuccess: jest.fn().mockName('addSuccess'),
      addError: jest.fn().mockName('addError')
    }
  }
};
const browserServicesMock = new _services.NotificationService(_httpClientMock.default);
const notificationServiceMock = exports.notificationServiceMock = {
  notificationService: browserServicesMock
};
const mainStateMock = exports.mainStateMock = {
  availableChannels: _constants.CHANNEL_TYPE,
  availableConfigTypes: ['slack', 'chime', 'webhook', 'email', 'sns', 'smtp_account', 'ses_account', 'email_group'],
  tooltipSupport: true
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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