/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.core.log;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.AppenderBase;
import ch.qos.logback.core.Context;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.protege.editor.core.FileUtils;
import org.protege.editor.core.log.LogPreferences;
import org.protege.editor.core.log.LogPreferencesPanel;
import org.protege.editor.core.log.LogStatusListener;
import org.protege.editor.core.log.LogView;
import org.protege.editor.core.ui.action.TimestampOutputAction;
import org.slf4j.LoggerFactory;

public class LogManager {
    private final LogView logView;
    private final Appender<ILoggingEvent> appender;
    private final List<LogStatusListener> listenerList = new ArrayList<LogStatusListener>();
    private final JDialog logViewDialog;

    public LogManager(final LogView logView) {
        this.logView = logView;
        this.appender = new AppenderBase<ILoggingEvent>(){

            public void start() {
                logView.start();
                super.start();
            }

            public void stop() {
                super.stop();
                logView.stop();
            }

            public void setContext(Context context) {
                logView.setContext(context);
                super.setContext(context);
            }

            protected void append(ILoggingEvent event) {
                logView.doAppend(event);
                LogManager.this.fireEvent(event);
            }
        };
        JPanel holder = new JPanel(new BorderLayout(7, 7));
        holder.setPreferredSize(new Dimension(800, 600));
        JScrollPane sp = new JScrollPane(logView.asJComponent());
        sp.getVerticalScrollBar().setUnitIncrement(15);
        holder.add(sp);
        JPanel buttonPanel = new JPanel(new FlowLayout(0));
        JButton clearLogButton = new JButton("Clear log");
        clearLogButton.setToolTipText("Remove all log messages");
        clearLogButton.addActionListener(e -> this.clearLogView());
        JButton showLogFile = new JButton("Show log file");
        showLogFile.setToolTipText("Show the log file in the system file browser");
        showLogFile.addActionListener(e -> FileUtils.showLogFile());
        JButton preferencesButton = new JButton("Preferences");
        preferencesButton.addActionListener(e -> this.showPreferences());
        preferencesButton.setToolTipText("Display log preferences");
        JButton timeStampButton = new JButton("Time stamp");
        timeStampButton.addActionListener(e -> TimestampOutputAction.createTimeStamp(holder));
        timeStampButton.setToolTipText("Print a timestamp and optional message into the logs or console");
        buttonPanel.add(showLogFile);
        buttonPanel.add(preferencesButton);
        buttonPanel.add(timeStampButton);
        buttonPanel.add(clearLogButton);
        holder.add((Component)buttonPanel, "South");
        JOptionPane op = new JOptionPane(holder, -1);
        this.logViewDialog = op.createDialog(null, "Log");
        this.logViewDialog.setModal(false);
        this.logViewDialog.setResizable(true);
        this.logViewDialog.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                LogManager.this.fireErrorsCleared();
            }
        });
    }

    public synchronized void addErrorLogListener(LogStatusListener listener) {
        this.listenerList.add(listener);
    }

    public synchronized void removeErrorLogListener(LogStatusListener listener) {
        this.listenerList.remove(listener);
    }

    private synchronized void fireEvent(ILoggingEvent event) {
        for (int i = 0; i < this.listenerList.size(); ++i) {
            this.listenerList.get(i).eventLogged(event);
        }
    }

    private synchronized void fireErrorsCleared() {
        this.listenerList.stream().forEach(LogStatusListener::statusCleared);
    }

    private Logger getRootLogger() {
        return (Logger)LoggerFactory.getLogger((String)"ROOT");
    }

    public void bind() {
        this.applyPreferences();
        Logger rootLogger = this.getRootLogger();
        this.appender.setContext((Context)rootLogger.getLoggerContext());
        this.appender.start();
        rootLogger.addAppender(this.appender);
    }

    public void unbind() {
        this.getRootLogger().detachAppender(this.appender);
        this.appender.stop();
    }

    public void showLogView() {
        this.logViewDialog.setVisible(true);
        this.fireErrorsCleared();
    }

    public void clearLogView() {
        this.logView.clearView();
        this.fireErrorsCleared();
    }

    private void showPreferences() {
        LogPreferencesPanel panel = new LogPreferencesPanel();
        panel.initialise();
        JOptionPane op = new JOptionPane(panel, -1, 2);
        JDialog dlg = op.createDialog(this.logViewDialog, "Log Preferences");
        dlg.setResizable(true);
        dlg.setVisible(true);
        Object value = op.getValue();
        if (value != null && (Integer)value == 0) {
            panel.applyChanges();
        }
    }

    public void applyPreferences() {
        this.getRootLogger().setLevel(Level.toLevel((String)LogPreferences.create().load().logLevel));
        this.logView.applyPreferences();
    }
}

