/**
 * Define the size of the receive buffer pool on the EZSP host.
 *
 * The number of receive buffers does not need to be greater than the number of packet buffers available on the NCP,
 * because this in turn is the maximum number of callbacks that could be received between commands.
 * In reality a value of 20 is a generous allocation.
 */
export declare const EZSP_HOST_RX_POOL_SIZE = 20;
/**
 * The number of transmit buffers must be set to the number of receive buffers
 * -- to hold the immediate ACKs sent for each callabck frame received --
 * plus 3 buffers for the retransmit queue and one each for an automatic ACK
 * (due to data flow control) and a command.
 */
export declare const TX_POOL_BUFFERS: number;
/** protocol version */
export declare const ASH_VERSION = 2;
/**
 * Timeouts before link is judged down.
 *
 * Consecutive ACK timeouts (minus 1) needed to enter the ERROR state.
 *
 * Is 3 in ash-ncp.h
 */
export declare const ASH_MAX_TIMEOUTS = 6;
/** max time in msecs for ncp to wake */
export declare const ASH_MAX_WAKE_TIME = 150;
/**
 * Define the units used by the Not Ready timer as 2**n msecs
 * log2 of msecs per NR timer unit
 */
export declare const ASH_NR_TIMER_BIT = 4;
/** Control byte mask for DATA frame */
export declare const ASH_DFRAME_MASK = 128;
/** Control byte mask for short frames (ACK/NAK) */
export declare const ASH_SHFRAME_MASK = 224;
/** Acknowledge frame number */
export declare const ASH_ACKNUM_MASK = 7;
export declare const ASH_ACKNUM_BIT = 0;
/** Retransmitted frame flag */
export declare const ASH_RFLAG_MASK = 8;
export declare const ASH_RFLAG_BIT = 3;
/** Receiver not ready flag */
export declare const ASH_NFLAG_MASK = 8;
export declare const ASH_NFLAG_BIT = 3;
/** Reserved for future use */
export declare const ASH_PFLAG_MASK = 16;
export declare const ASH_PFLAG_BIT = 4;
/** DATA frame number */
export declare const ASH_FRMNUM_MASK = 112;
export declare const ASH_FRMNUM_BIT = 4;
/**
 * The wake byte special function applies only when in between frames,
 * so it does not need to be escaped within a frame.
 * (also means NCP data pending)
 */
export declare const ASH_WAKE = 255; /*!<   */
/** Constant used in byte-stuffing (XOR mask used in byte stuffing) */
export declare const ASH_FLIP = 32;
export declare const ASH_MIN_DATA_FIELD_LEN = 3;
export declare const ASH_MAX_DATA_FIELD_LEN: number;
/** with control */
export declare const ASH_MIN_DATA_FRAME_LEN: number;
/** control plus data field, but not CRC */
export declare const ASH_MIN_FRAME_LEN = 1;
export declare const ASH_MAX_FRAME_LEN: number;
export declare const ASH_CRC_LEN = 2;
export declare const ASH_MIN_FRAME_WITH_CRC_LEN: number;
export declare const ASH_MAX_FRAME_WITH_CRC_LEN: number;
/** ash frame len data min */
export declare const ASH_FRAME_LEN_DATA_MIN: number;
/** [control] */
export declare const ASH_FRAME_LEN_ACK = 1;
/** [control] */
export declare const ASH_FRAME_LEN_NAK = 1;
/** [control] */
export declare const ASH_FRAME_LEN_RST = 1;
/** [control, version, reset reason] */
export declare const ASH_FRAME_LEN_RSTACK = 3;
/** [control, version, error] */
export declare const ASH_FRAME_LEN_ERROR = 3;
/** longest non-data frame sent */
export declare const SH_TX_BUFFER_LEN = 2;
/** longest non-data frame received */
export declare const SH_RX_BUFFER_LEN = 3;
/** polynomial */
export declare const LFSR_POLY = 184;
/** initial value (seed) */
export declare const LFSR_SEED = 66;
export declare const VALID_BAUDRATES: number[];
//# sourceMappingURL=consts.d.ts.map