/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.css.dom;

import java.util.HashMap;
import java.util.Map;
import org.apache.batik.css.dom.CSSOMValue;
import org.apache.batik.css.engine.CSSEngine;
import org.apache.batik.css.engine.CSSStylableElement;
import org.apache.batik.css.engine.value.Value;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSValue;

public class CSSOMComputedStyle
implements CSSStyleDeclaration {
    protected CSSEngine cssEngine;
    protected CSSStylableElement element;
    protected String pseudoElement;
    protected Map values = new HashMap();

    public CSSOMComputedStyle(CSSEngine cSSEngine, CSSStylableElement cSSStylableElement, String string) {
        this.cssEngine = cSSEngine;
        this.element = cSSStylableElement;
        this.pseudoElement = string;
    }

    @Override
    public String getCssText() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.cssEngine.getNumberOfProperties(); ++i) {
            stringBuffer.append(this.cssEngine.getPropertyName(i));
            stringBuffer.append(": ");
            stringBuffer.append(this.cssEngine.getComputedStyle(this.element, this.pseudoElement, i).getCssText());
            stringBuffer.append(";\n");
        }
        return stringBuffer.toString();
    }

    @Override
    public void setCssText(String string) throws DOMException {
        throw new DOMException(7, "");
    }

    @Override
    public String getPropertyValue(String string) {
        int n = this.cssEngine.getPropertyIndex(string);
        if (n == -1) {
            return "";
        }
        Value value = this.cssEngine.getComputedStyle(this.element, this.pseudoElement, n);
        return value.getCssText();
    }

    @Override
    public CSSValue getPropertyCSSValue(String string) {
        int n;
        CSSValue cSSValue = (CSSValue)this.values.get(string);
        if (cSSValue == null && (n = this.cssEngine.getPropertyIndex(string)) != -1) {
            cSSValue = this.createCSSValue(n);
            this.values.put(string, cSSValue);
        }
        return cSSValue;
    }

    @Override
    public String removeProperty(String string) throws DOMException {
        throw new DOMException(7, "");
    }

    @Override
    public String getPropertyPriority(String string) {
        return "";
    }

    @Override
    public void setProperty(String string, String string2, String string3) throws DOMException {
        throw new DOMException(7, "");
    }

    @Override
    public int getLength() {
        return this.cssEngine.getNumberOfProperties();
    }

    @Override
    public String item(int n) {
        if (n < 0 || n >= this.cssEngine.getNumberOfProperties()) {
            return "";
        }
        return this.cssEngine.getPropertyName(n);
    }

    @Override
    public CSSRule getParentRule() {
        return null;
    }

    protected CSSValue createCSSValue(int n) {
        return new ComputedCSSValue(n);
    }

    public class ComputedCSSValue
    extends CSSOMValue
    implements CSSOMValue.ValueProvider {
        protected int index;

        public ComputedCSSValue(int n) {
            super(null);
            this.valueProvider = this;
            this.index = n;
        }

        @Override
        public Value getValue() {
            return CSSOMComputedStyle.this.cssEngine.getComputedStyle(CSSOMComputedStyle.this.element, CSSOMComputedStyle.this.pseudoElement, this.index);
        }
    }
}

