/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.search;

import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.helpers.DefaultHandler;
import tim.prune.App;
import tim.prune.I18nManager;
import tim.prune.data.DataPoint;
import tim.prune.function.search.GenericDownloaderFunction;
import tim.prune.function.search.OpenCachingDeXmlHandler;
import tim.prune.function.search.SearchResult;

public class SearchOpenCachingDeFunction
extends GenericDownloaderFunction {
    private static final int MAX_DISTANCE = 50;

    public SearchOpenCachingDeFunction(App app) {
        super(app);
    }

    @Override
    public String getNameKey() {
        return "function.searchopencachingde";
    }

    @Override
    protected String getColumnKey(int n) {
        if (n == 0) {
            return "dialog.wikipedia.column.name";
        }
        return "dialog.wikipedia.column.distance";
    }

    @Override
    public void run() {
        this._statusLabel.setText(I18nManager.getText("confirm.running"));
        DataPoint dataPoint = this._app.getTrackInfo().getCurrentPoint();
        if (dataPoint == null) {
            return;
        }
        double d = dataPoint.getLatitude().getDouble();
        double d2 = dataPoint.getLongitude().getDouble();
        this.submitSearch(d, d2);
        if (this._errorMessage == null && this._trackListModel.isEmpty()) {
            this._errorMessage = I18nManager.getText("dialog.geocaching.nonefound");
        }
        this._statusLabel.setText(this._errorMessage == null ? "" : this._errorMessage);
    }

    private void submitSearch(double d, double d2) {
        Object object;
        Serializable serializable;
        String string = "https://opencaching.de/search.php?searchto=searchbydistance&showresult=1&output=XML&sort=bydistance&lat=" + d + "&lon=" + d2 + "&distance=" + 50 + "&unit=km";
        OpenCachingDeXmlHandler openCachingDeXmlHandler = new OpenCachingDeXmlHandler();
        InputStream inputStream = null;
        try {
            serializable = new URL(string);
            object = SAXParserFactory.newInstance().newSAXParser();
            inputStream = serializable.openStream();
            ((SAXParser)object).parse(inputStream, (DefaultHandler)openCachingDeXmlHandler);
        }
        catch (Exception exception) {
            this._errorMessage = String.valueOf(exception.getClass().getName()) + " - " + exception.getMessage();
        }
        try {
            inputStream.close();
        }
        catch (Exception exception) {}
        serializable = openCachingDeXmlHandler.getTrackList();
        this._trackListModel.addTracks((ArrayList<SearchResult>)serializable);
        if (this._trackListModel.isEmpty() && (object = openCachingDeXmlHandler.getErrorMessage()) != null && !((String)object).equals("")) {
            this._app.showErrorMessageNoLookup(this.getNameKey(), (String)object);
            this._errorMessage = object;
        }
    }
}

