/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.srtm;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.util.Base64;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import tim.prune.App;
import tim.prune.GenericFunction;
import tim.prune.I18nManager;
import tim.prune.config.Config;
import tim.prune.function.browser.BrowserLauncher;

public class ConfigureSrtmSources
extends GenericFunction {
    private JDialog _dialog = null;
    private JCheckBox _oneSecondCheck = null;
    private boolean _oneSecondOriginallyOn = false;
    private String _authString = null;
    private JButton _okButton = null;

    public ConfigureSrtmSources(App app) {
        super(app);
    }

    @Override
    public String getNameKey() {
        return "function.configuresrtmsources";
    }

    @Override
    public void begin() {
        if (this._dialog == null) {
            this._dialog = new JDialog(this._parentFrame, this.getName(), true);
            this._dialog.setLocationRelativeTo(this._parentFrame);
            this._dialog.setDefaultCloseOperation(2);
            this._dialog.getContentPane().add(this.makeDialogComponents());
            this._dialog.pack();
        }
        this.prefillCurrentAuth();
        this._dialog.setVisible(true);
    }

    private JPanel makeDialogComponents() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        jPanel3.add(new JLabel(I18nManager.getText("dialog.configuresrtm.intro1")));
        jPanel3.add(new JLabel(I18nManager.getText("dialog.configuresrtm.intro2")));
        jPanel2.add(jPanel3);
        jPanel2.add(Box.createRigidArea(new Dimension(0, 10)));
        JPanel jPanel4 = new JPanel();
        jPanel4.setBorder(BorderFactory.createTitledBorder(""));
        jPanel4.setLayout(new BoxLayout(jPanel4, 1));
        JCheckBox jCheckBox = new JCheckBox(I18nManager.getText("dialog.configuresrtm.threesecond"));
        jCheckBox.setSelected(true);
        jCheckBox.setEnabled(false);
        jPanel4.add(jCheckBox);
        jPanel4.add(new JLabel(I18nManager.getText("dialog.configuresrtm.threesecond.desc")));
        jPanel2.add(jPanel4);
        jPanel2.add(Box.createRigidArea(new Dimension(0, 10)));
        JPanel jPanel5 = new JPanel();
        jPanel5.setBorder(BorderFactory.createTitledBorder(""));
        jPanel5.setLayout(new BoxLayout(jPanel5, 1));
        this._oneSecondCheck = new JCheckBox(I18nManager.getText("dialog.configuresrtm.onesecond"));
        this._oneSecondCheck.setSelected(true);
        jPanel5.add(this._oneSecondCheck);
        this._oneSecondCheck.addActionListener(actionEvent -> {
            if (this._oneSecondCheck.isSelected()) {
                this.setupEarthdataAuth();
            }
            this._okButton.setEnabled(this._oneSecondCheck.isSelected() ^ this._oneSecondOriginallyOn);
        });
        jPanel5.add(new JLabel(I18nManager.getText("dialog.configuresrtm.onesecond.desc1")));
        jPanel5.add(new JLabel(I18nManager.getText("dialog.configuresrtm.onesecond.desc2")));
        jPanel2.add(jPanel5);
        jPanel2.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 15));
        jPanel.add((Component)jPanel2, "Center");
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new FlowLayout(2));
        this._okButton = new JButton(I18nManager.getText("button.ok"));
        this._okButton.addActionListener(actionEvent -> this.finish());
        jPanel6.add(this._okButton);
        JButton jButton = new JButton(I18nManager.getText("button.cancel"));
        jButton.addActionListener(actionEvent -> this._dialog.dispose());
        jPanel6.add(jButton);
        jPanel.add((Component)jPanel6, "South");
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 15));
        return jPanel;
    }

    private void setupEarthdataAuth() {
        Object object;
        Object[] objectArray = new Object[]{I18nManager.getText("button.yes"), I18nManager.getText("button.no")};
        int n = JOptionPane.showOptionDialog(this._parentFrame, I18nManager.getText("dialog.configuresrtm.showregistrationwebsite"), this.getName(), 0, 3, null, objectArray, objectArray[1]);
        if (n == 0) {
            BrowserLauncher.launchBrowser("https://urs.earthdata.nasa.gov/users/new");
        }
        if ((object = JOptionPane.showInputDialog(this._app.getFrame(), I18nManager.getText("dialog.configuresrtm.userid"), this.getName(), 3, null, null, "")) == null || object.equals("")) {
            this._oneSecondCheck.setSelected(false);
            return;
        }
        Object object2 = JOptionPane.showInputDialog(this._app.getFrame(), I18nManager.getText("dialog.configuresrtm.password"), this.getName(), 3, null, null, "");
        if (object2 == null || object2.equals("")) {
            this._oneSecondCheck.setSelected(false);
            return;
        }
        String string = Base64.getEncoder().encodeToString((String.valueOf(object.toString()) + ":" + object2.toString()).getBytes());
        if (this.isAuthValid(string)) {
            this._authString = string;
        } else {
            JOptionPane.showMessageDialog(this._dialog, I18nManager.getText("dialog.configuresrtm.loginfailed"), this.getName(), 0);
            this._oneSecondCheck.setSelected(false);
        }
    }

    private void finish() {
        if (this._oneSecondCheck.isSelected()) {
            if (this._authString != null) {
                Config.setConfigString("prune.earthdataauth", this._authString);
            }
        } else {
            Config.setConfigString("prune.earthdataauth", null);
        }
        this._dialog.dispose();
    }

    private void prefillCurrentAuth() {
        this._oneSecondCheck.setSelected(this.isAuthValid(Config.getConfigString("prune.earthdataauth")));
        this._authString = null;
        this._oneSecondOriginallyOn = this._oneSecondCheck.isSelected();
        this._okButton.setEnabled(false);
    }

    private boolean isAuthValid(String string) {
        return string != null && !string.isEmpty();
    }
}

