/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.vector;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.openstreetmap.josm.data.osm.AbstractPrimitive;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.visitor.PrimitiveVisitor;
import org.openstreetmap.josm.data.vector.DataLayer;
import org.openstreetmap.josm.data.vector.VectorDataSet;
import org.openstreetmap.josm.gui.mappaint.StyleCache;
import org.openstreetmap.josm.tools.Utils;

public abstract class VectorPrimitive
extends AbstractPrimitive
implements DataLayer<String> {
    private VectorDataSet dataSet;
    private boolean highlighted;
    private StyleCache mappaintStyle;
    private final String layer;
    private Object referrers;

    protected VectorPrimitive(String layer) {
        this.layer = layer;
        this.id = this.getIdGenerator().generateUniqueId();
    }

    @Override
    protected void keysChangedImpl(Map<String, String> originalKeys) {
        this.clearCachedStyle();
        if (this.dataSet != null) {
            for (IPrimitive iPrimitive : this.getReferrers()) {
                iPrimitive.clearCachedStyle();
            }
        }
        this.updateFlags((short)512, this.hasKeys() && this.keys().anyMatch(key -> !VectorPrimitive.isUninterestingKey(key)));
    }

    @Override
    public boolean isHighlighted() {
        return this.highlighted;
    }

    @Override
    public void setHighlighted(boolean highlighted) {
        this.highlighted = highlighted;
    }

    @Override
    public boolean isTagged() {
        return (this.flags & 0x200) != 0;
    }

    @Override
    public boolean isAnnotated() {
        return this.getInterestingTags().size() - this.getKeys().size() > 0;
    }

    public VectorDataSet getDataSet() {
        return this.dataSet;
    }

    protected void setDataSet(VectorDataSet newDataSet) {
        this.dataSet = newDataSet;
    }

    @Override
    public final StyleCache getCachedStyle() {
        return this.mappaintStyle;
    }

    @Override
    public final void setCachedStyle(StyleCache mappaintStyle) {
        this.mappaintStyle = mappaintStyle;
    }

    @Override
    public final boolean isCachedStyleUpToDate() {
        return this.mappaintStyle != null && this.mappaintCacheIdx == this.dataSet.getMappaintCacheIndex();
    }

    @Override
    public final void declareCachedStyleUpToDate() {
        this.mappaintCacheIdx = this.dataSet.getMappaintCacheIndex();
    }

    @Override
    public boolean hasDirectionKeys() {
        return false;
    }

    @Override
    public boolean reversedDirection() {
        return false;
    }

    public final List<VectorPrimitive> getReferrers(boolean allowWithoutDataset) {
        if (this.referrers == null) {
            return Collections.emptyList();
        }
        if (this.referrers instanceof VectorPrimitive) {
            return Collections.singletonList((VectorPrimitive)this.referrers);
        }
        return this.referrers(allowWithoutDataset, VectorPrimitive.class).collect(Collectors.toList());
    }

    protected void addReferrer(IPrimitive referrer) {
        if (this.referrers == null) {
            this.referrers = referrer;
        } else if (this.referrers instanceof IPrimitive) {
            if (this.referrers != referrer) {
                this.referrers = new IPrimitive[]{(IPrimitive)this.referrers, referrer};
            }
        } else {
            for (IPrimitive primitive : (IPrimitive[])this.referrers) {
                if (primitive != referrer) continue;
                return;
            }
            this.referrers = Utils.addInArrayCopy((IPrimitive[])this.referrers, referrer);
        }
    }

    protected void removeReferrer(IPrimitive referrer) {
        if (this.referrers instanceof IPrimitive) {
            if (this.referrers == referrer) {
                this.referrers = null;
            }
        } else if (this.referrers instanceof IPrimitive[]) {
            IPrimitive[] orig = (IPrimitive[])this.referrers;
            int idx = IntStream.range(0, orig.length).filter(i -> orig[i] == referrer).findFirst().orElse(-1);
            if (idx == -1) {
                return;
            }
            if (orig.length == 2) {
                this.referrers = orig[1 - idx];
            } else {
                IPrimitive[] smaller = new IPrimitive[orig.length - 1];
                System.arraycopy(orig, 0, smaller, 0, idx);
                System.arraycopy(orig, idx + 1, smaller, idx, smaller.length - idx);
                this.referrers = smaller;
            }
        }
    }

    private <T extends IPrimitive> Stream<T> referrers(boolean allowWithoutDataset, Class<T> filter) {
        if (this.dataSet == null && !allowWithoutDataset) {
            return Stream.empty();
        }
        if (this.referrers == null) {
            return Stream.empty();
        }
        Stream<IPrimitive> stream = this.referrers instanceof IPrimitive ? Stream.of((IPrimitive)this.referrers) : Arrays.stream((IPrimitive[])this.referrers);
        return stream.filter(p -> p.getDataSet() == this.dataSet).filter(filter::isInstance).map(filter::cast);
    }

    public final <T extends IPrimitive> Stream<T> referrers(Class<T> filter) {
        return this.referrers(false, filter);
    }

    @Override
    public void visitReferrers(PrimitiveVisitor visitor) {
        if (visitor != null) {
            this.doVisitReferrers(o -> o.accept(visitor));
        }
    }

    private void doVisitReferrers(Consumer<IPrimitive> visitor) {
        if (this.referrers instanceof IPrimitive) {
            IPrimitive ref = (IPrimitive)this.referrers;
            if (ref.getDataSet() == this.dataSet) {
                visitor.accept(ref);
            }
        } else if (this.referrers instanceof IPrimitive[]) {
            IPrimitive[] refs;
            for (IPrimitive ref : refs = (IPrimitive[])this.referrers) {
                if (ref.getDataSet() != this.dataSet) continue;
                visitor.accept(ref);
            }
        }
    }

    protected void setId(long id) {
        this.id = id;
    }

    public void setDisabled(boolean disabled) {
        this.updateFlags((short)16, disabled);
    }

    @Override
    public void setVisible(boolean visible) {
        this.updateFlags((short)2, visible);
    }

    @Override
    public String getLayer() {
        return this.layer;
    }
}

