/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.actions;

import java.awt.Font;
import java.awt.event.ActionEvent;
import javafx.application.Platform;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.scene.control.Spinner;
import javafx.scene.control.SpinnerValueFactory;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.FlowPane;
import javafx.stage.Stage;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import mediathek.mainwindow.MediathekGui;
import mediathek.tool.ApplicationConfiguration;
import mediathek.tool.swing.LookAndFeelType;
import mediathek.tool.swing.SwingUIFontChanger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.controlsfx.glyphfont.FontAwesome;
import org.controlsfx.glyphfont.GlyphFont;
import org.controlsfx.glyphfont.GlyphFontRegistry;

public class ChangeGlobalFontSetting
extends AbstractAction {
    private static final Logger logger = LogManager.getLogger();
    private JMenuItem menuItem;
    private boolean sizeChanged;
    private Stage window;

    public ChangeGlobalFontSetting() {
        this.putValue("Name", "Globale Schriftgr\u00f6\u00dfe \u00e4ndern...");
    }

    public void setMenuItem(JMenuItem menuItem) {
        this.menuItem = menuItem;
    }

    private int getCurrentSize() {
        int result = -1;
        switch (LookAndFeelType.get(UIManager.getLookAndFeel().getClass().getName())) {
            case Windows: {
                Font font = (Font)UIManager.getDefaults().get("Table.font");
                result = font.getSize();
                break;
            }
            case Nimbus: {
                Font font = (Font)UIManager.getDefaults().get("defaultFont");
                result = font.getSize();
            }
        }
        return result;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int initialSize = this.getCurrentSize();
        this.sizeChanged = false;
        Platform.runLater(() -> {
            this.createWindow();
            this.window.setScene(new Scene(this.createLayout(initialSize)));
            this.window.show();
        });
    }

    private FlowPane createLayout(int initialSize) {
        Label label = new Label("Schriftgr\u00f6\u00dfe:");
        Spinner<Integer> spinner = new Spinner<Integer>();
        spinner.setEditable(true);
        SpinnerValueFactory.IntegerSpinnerValueFactory valueFactory = new SpinnerValueFactory.IntegerSpinnerValueFactory(12, 48, initialSize);
        spinner.setValueFactory(valueFactory);
        spinner.valueProperty().addListener((observableValue, oldValue, newValue) -> SwingUtilities.invokeLater(() -> this.spinnerUpdate((int)newValue)));
        FlowPane root = new FlowPane();
        root.setHgap(10.0);
        root.setVgap(10.0);
        root.setPadding(new Insets(10.0));
        GlyphFont fontAwesome = GlyphFontRegistry.font("FontAwesome");
        Button btnReset = new Button("", fontAwesome.create(FontAwesome.Glyph.TRASH_ALT));
        btnReset.setTooltip(new Tooltip("Schriftgr\u00f6\u00dfe zur\u00fccksetzen"));
        btnReset.setOnAction(evt -> this.resetAction());
        root.getChildren().addAll((Node[])new Node[]{label, spinner, btnReset});
        return root;
    }

    private void spinnerUpdate(int newValue) {
        logger.info("Updating Swing UI font size to {}", (Object)newValue);
        SwingUIFontChanger fc = new SwingUIFontChanger();
        fc.changeFontSize(newValue);
        ApplicationConfiguration.getConfiguration().setProperty("application.ui.font_size", Float.valueOf(newValue));
        SwingUtilities.updateComponentTreeUI(MediathekGui.ui());
        this.sizeChanged = true;
    }

    private void resetAction() {
        logger.info("Resetting Swing UI to default font size");
        ApplicationConfiguration.getConfiguration().clearProperty("application.ui.font_size");
        this.sizeChanged = true;
        this.window.close();
    }

    private void showAppTerminationAlert() {
        Alert alert = new Alert(Alert.AlertType.CONFIRMATION, "Die \u00c4nderung der Schriftgr\u00f6\u00dfe erfordert einen Neustart.\nM\u00f6chten Sie MediathekView nun beenden?\n", ButtonType.YES, ButtonType.NO);
        alert.setHeaderText("Schriftgr\u00f6\u00dfe wurde ge\u00e4ndert");
        alert.showAndWait();
        if (alert.getResult() == ButtonType.YES) {
            SwingUtilities.invokeLater(() -> MediathekGui.ui().beenden(false, false));
        }
    }

    private void createWindow() {
        this.window = new Stage();
        this.window.setTitle("Globale Schriftgr\u00f6\u00dfe \u00e4ndern");
        this.window.setResizable(false);
        this.window.setOnShowing(evt -> SwingUtilities.invokeLater(() -> this.menuItem.setEnabled(false)));
        this.window.setOnHidden(evt -> SwingUtilities.invokeLater(() -> {
            this.menuItem.setEnabled(true);
            if (this.sizeChanged) {
                Platform.runLater(this::showAppTerminationAlert);
            }
        }));
    }
}

