/*
 * Copyright (c) 2012, 2024, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_tt extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_ar = "\u0433\u0430\u0440\u04d9\u043f";
        final String metaValue_la = "\u043b\u0430\u0442\u0438\u043d";
        final Object[][] data = new Object[][] {
            { "AD", "\u0410\u043d\u0434\u043e\u0440\u0440\u0430" },
            { "AE", "\u0411\u0435\u0440\u043b\u04d9\u0448\u043a\u04d9\u043d \u0413\u0430\u0440\u04d9\u043f \u04d8\u043c\u0438\u0440\u043b\u0435\u043a\u043b\u04d9\u0440\u0435" },
            { "AF", "\u04d8\u0444\u0433\u0430\u043d\u0441\u0442\u0430\u043d" },
            { "AG", "\u0410\u043d\u0442\u0438\u0433\u0443\u0430 \u04bb\u04d9\u043c \u0411\u0430\u0440\u0431\u0443\u0434\u0430" },
            { "AI", "\u0410\u043d\u0433\u0438\u043b\u044c\u044f" },
            { "AL", "\u0410\u043b\u0431\u0430\u043d\u0438\u044f" },
            { "AM", "\u04d8\u0440\u043c\u04d9\u043d\u0441\u0442\u0430\u043d" },
            { "AO", "\u0410\u043d\u0433\u043e\u043b\u0430" },
            { "AQ", "\u0410\u043d\u0442\u0430\u0440\u043a\u0442\u0438\u043a\u0430" },
            { "AR", "\u0410\u0440\u0433\u0435\u043d\u0442\u0438\u043d\u0430" },
            { "AS", "\u0410\u043c\u0435\u0440\u0438\u043a\u0430 \u0421\u0430\u043c\u043e\u0430\u0441\u044b" },
            { "AT", "\u0410\u0432\u0441\u0442\u0440\u0438\u044f" },
            { "AU", "\u0410\u0432\u0441\u0442\u0440\u0430\u043b\u0438\u044f" },
            { "AW", "\u0410\u0440\u0443\u0431\u0430" },
            { "AX", "\u0410\u043b\u0430\u043d\u0434 \u0443\u0442\u0440\u0430\u0443\u043b\u0430\u0440\u044b" },
            { "AZ", "\u04d8\u0437\u04d9\u0440\u0431\u0430\u0439\u0497\u0430\u043d" },
            { "BA", "\u0411\u043e\u0441\u043d\u0438\u044f \u04bb\u04d9\u043c \u0413\u0435\u0440\u0446\u0435\u0433\u043e\u0432\u0438\u043d\u0430" },
            { "BB", "\u0411\u0430\u0440\u0431\u0430\u0434\u043e\u0441" },
            { "BD", "\u0411\u0430\u043d\u0433\u043b\u0430\u0434\u0435\u0448" },
            { "BE", "\u0411\u0435\u043b\u044c\u0433\u0438\u044f" },
            { "BF", "\u0411\u0443\u0440\u043a\u0438\u043d\u0430-\u0424\u0430\u0441\u043e" },
            { "BG", "\u0411\u043e\u043b\u0433\u0430\u0440\u0438\u044f" },
            { "BH", "\u0411\u04d9\u0445\u0440\u04d9\u0439\u043d" },
            { "BI", "\u0411\u0443\u0440\u0443\u043d\u0434\u0438" },
            { "BJ", "\u0411\u0435\u043d\u0438\u043d" },
            { "BL", "\u0421\u0435\u043d-\u0411\u0430\u0440\u0442\u0435\u043b\u044c\u043c\u0438" },
            { "BM", "\u0411\u0435\u0440\u043c\u0443\u0434 \u0443\u0442\u0440\u0430\u0443\u043b\u0430\u0440\u044b" },
            { "BN", "\u0411\u0440\u0443\u043d\u0435\u0439" },
            { "BO", "\u0411\u043e\u043b\u0438\u0432\u0438\u044f" },
            { "BR", "\u0411\u0440\u0430\u0437\u0438\u043b\u0438\u044f" },
            { "BS", "\u0411\u0430\u0433\u0430\u043c \u0443\u0442\u0440\u0430\u0443\u043b\u0430\u0440\u044b" },
            { "BT", "\u0411\u0443\u0442\u0430\u043d" },
            { "BV", "\u0411\u0443\u0432\u0435 \u0443\u0442\u0440\u0430\u0432\u044b" },
            { "BW", "\u0411\u043e\u0442\u0441\u0432\u0430\u043d\u0430" },
            { "BY", "\u0411\u0435\u043b\u0430\u0440\u0443\u0441\u044c" },
            { "BZ", "\u0411\u0435\u043b\u0438\u0437" },
            { "CA", "\u041a\u0430\u043d\u0430\u0434\u0430" },
            { "CC", "\u041a\u043e\u043a\u043e\u0441 (\u041a\u0438\u043b\u0438\u043d\u0433) \u0443\u0442\u0440\u0430\u0443\u043b\u0430\u0440\u044b" },
            { "CD", "\u041a\u043e\u043d\u0433\u043e (\u041a\u0414\u0420)" },
            { "CF", "\u04ae\u0437\u04d9\u043a \u0410\u0444\u0440\u0438\u043a\u0430 \u0420\u0435\u0441\u043f\u0443\u0431\u043b\u0438\u043a\u0430\u0441\u044b" },
            { "CH", "\u0428\u0432\u0435\u0439\u0446\u0430\u0440\u0438\u044f" },
            { "CI", "\u041a\u043e\u0442-\u0434\u2019\u0418\u0432\u0443\u0430\u0440" },
            { "CK", "\u041a\u0443\u043a \u0443\u0442\u0440\u0430\u0443\u043b\u0430\u0440\u044b" },
            { "CL", "\u0427\u0438\u043b\u0438" },
            { "CM", "\u041a\u0430\u043c\u0435\u0440\u0443\u043d" },
            { "CN", "\u041a\u044b\u0442\u0430\u0439" },
            { "CO", "\u041a\u043e\u043b\u0443\u043c\u0431\u0438\u044f" },
            { "CR", "\u041a\u043e\u0441\u0442\u0430-\u0420\u0438\u043a\u0430" },
            { "CU", "\u041a\u0443\u0431\u0430" },
            { "CV", "\u041a\u0430\u0431\u043e-\u0412\u0435\u0440\u0434\u0435" },
            { "CW", "\u041a\u044e\u0440\u0430\u0441\u0430\u043e" },
            { "CX", "\u0420\u0430\u0448\u0442\u0443\u0430 \u0443\u0442\u0440\u0430\u0432\u044b" },
            { "CY", "\u041a\u0438\u043f\u0440" },
            { "CZ", "\u0427\u0435\u0445\u0438\u044f \u0420\u0435\u0441\u043f\u0443\u0431\u043b\u0438\u043a\u0430\u0441\u044b" },
            { "DE", "\u0413\u0435\u0440\u043c\u0430\u043d\u0438\u044f" },
            { "DJ", "\u0496\u0438\u0431\u04af\u0442\u0438" },
            { "DK", "\u0414\u0430\u043d\u0438\u044f" },
            { "DM", "\u0414\u043e\u043c\u0438\u043d\u0438\u043a\u0430" },
            { "DO", "\u0414\u043e\u043c\u0438\u043d\u0438\u043a\u0430\u043d\u0430 \u0420\u0435\u0441\u043f\u0443\u0431\u043b\u0438\u043a\u0430\u0441\u044b" },
            { "DZ", "\u0410\u043b\u0436\u0438\u0440" },
            { "EC", "\u042d\u043a\u0432\u0430\u0434\u043e\u0440" },
            { "EE", "\u042d\u0441\u0442\u043e\u043d\u0438\u044f" },
            { "EG", "\u041c\u0438\u0441\u044b\u0440" },
            { "ER", "\u042d\u0440\u0438\u0442\u0440\u0435\u044f" },
            { "ES", "\u0418\u0441\u043f\u0430\u043d\u0438\u044f" },
            { "ET", "\u042d\u0444\u0438\u043e\u043f\u0438\u044f" },
            { "FI", "\u0424\u0438\u043d\u043b\u044f\u043d\u0434\u0438\u044f" },
            { "FJ", "\u0424\u0438\u0434\u0436\u0438" },
            { "FK", "\u0424\u043e\u043b\u043a\u043b\u0435\u043d\u0434 \u0443\u0442\u0440\u0430\u0443\u043b\u0430\u0440\u044b" },
            { "FM", "\u041c\u0438\u043a\u0440\u043e\u043d\u0435\u0437\u0438\u044f" },
            { "FO", "\u0424\u0430\u0440\u0435\u0440 \u0443\u0442\u0440\u0430\u0443\u043b\u0430\u0440\u044b" },
            { "FR", "\u0424\u0440\u0430\u043d\u0446\u0438\u044f" },
            { "GA", "\u0413\u0430\u0431\u043e\u043d" },
            { "GB", "\u0411\u0435\u0440\u043b\u04d9\u0448\u043a\u04d9\u043d \u041a\u043e\u0440\u043e\u043b\u044c\u043b\u0435\u043a" },
            { "GD", "\u0413\u0440\u0435\u043d\u0430\u0434\u0430" },
            { "GE", "\u0413\u0440\u0443\u0437\u0438\u044f" },
            { "GF", "\u0424\u0440\u0430\u043d\u0446\u0443\u0437 \u0413\u0432\u0438\u0430\u043d\u0430\u0441\u044b" },
            { "GG", "\u0413\u0435\u0440\u043d\u0441\u0438" },
            { "GH", "\u0413\u0430\u043d\u0430" },
            { "GI", "\u0413\u0438\u0431\u0440\u0430\u043b\u0442\u0430\u0440" },
            { "GL", "\u0413\u0440\u0435\u043d\u043b\u0430\u043d\u0434\u0438\u044f" },
            { "GM", "\u0413\u0430\u043c\u0431\u0438\u044f" },
            { "GN", "\u0413\u0432\u0438\u043d\u0435\u044f" },
            { "GP", "\u0413\u0432\u0430\u0434\u0435\u043b\u0443\u043f\u0430" },
            { "GQ", "\u042d\u043a\u0432\u0430\u0442\u043e\u0440\u0438\u0430\u043b\u044c \u0413\u0432\u0438\u043d\u0435\u044f" },
            { "GR", "\u0413\u0440\u0435\u0446\u0438\u044f" },
            { "GS", "\u041a\u04e9\u043d\u044c\u044f\u043a \u0413\u0435\u043e\u0440\u0433\u0438\u044f \u04bb\u04d9\u043c \u041a\u04e9\u043d\u044c\u044f\u043a \u0421\u0430\u043d\u0434\u0432\u0438\u0447 \u0443\u0442\u0440\u0430\u0443\u043b\u0430\u0440\u044b" },
            { "GT", "\u0413\u0432\u0430\u0442\u0435\u043c\u0430\u043b\u0430" },
            { "GU", "\u0413\u0443\u0430\u043c" },
            { "GW", "\u0413\u0432\u0438\u043d\u0435\u044f-\u0411\u0438\u0441\u0430\u0443" },
            { "GY", "\u0413\u0430\u0439\u0430\u043d\u0430" },
            { "HK", "\u0413\u043e\u043d\u043a\u043e\u043d\u0433 \u041c\u0430\u0445\u0441\u0443\u0441 \u0418\u0434\u0430\u0440\u04d9\u043b\u0435 \u0422\u04e9\u0431\u04d9\u0433\u0435" },
            { "HM", "\u0425\u0435\u0440\u0434 \u0443\u0442\u0440\u0430\u0432\u044b \u04bb\u04d9\u043c \u041c\u0430\u043a\u0434\u043e\u043d\u0430\u043b\u044c\u0434 \u0443\u0442\u0440\u0430\u0443\u043b\u0430\u0440\u044b" },
            { "HN", "\u0413\u043e\u043d\u0434\u0443\u0440\u0430\u0441" },
            { "HR", "\u0425\u043e\u0440\u0432\u0430\u0442\u0438\u044f" },
            { "HT", "\u0413\u0430\u0438\u0442\u0438" },
            { "HU", "\u0412\u0435\u043d\u0433\u0440\u0438\u044f" },
            { "ID", "\u0418\u043d\u0434\u043e\u043d\u0435\u0437\u0438\u044f" },
            { "IE", "\u0418\u0440\u043b\u0430\u043d\u0434\u0438\u044f" },
            { "IL", "\u0418\u0437\u0440\u0430\u0438\u043b\u044c" },
            { "IM", "\u041c\u044d\u043d \u0443\u0442\u0440\u0430\u0432\u044b" },
            { "IN", "\u0418\u043d\u0434\u0438\u044f" },
            { "IQ", "\u0413\u044b\u0439\u0440\u0430\u043a" },
            { "IR", "\u0418\u0440\u0430\u043d" },
            { "IS", "\u0418\u0441\u043b\u0430\u043d\u0434\u0438\u044f" },
            { "IT", "\u0418\u0442\u0430\u043b\u0438\u044f" },
            { "JE", "\u0414\u0436\u0435\u0440\u0441\u0438" },
            { "JM", "\u042f\u043c\u0430\u0439\u043a\u0430" },
            { "JO", "\u0418\u043e\u0440\u0434\u0430\u043d\u0438\u044f" },
            { "JP", "\u042f\u043f\u043e\u043d\u0438\u044f" },
            { "KE", "\u041a\u0435\u043d\u0438\u044f" },
            { "KG", "\u041a\u044b\u0440\u0433\u044b\u0437\u0441\u0442\u0430\u043d" },
            { "KH", "\u041a\u0430\u043c\u0431\u043e\u0434\u0436\u0430" },
            { "KI", "\u041a\u0438\u0440\u0438\u0431\u0430\u0442\u0438" },
            { "KM", "\u041a\u043e\u043c\u043e\u0440 \u0443\u0442\u0440\u0430\u0443\u043b\u0430\u0440\u044b" },
            { "KN", "\u0421\u0435\u043d\u0442-\u041a\u0438\u0442\u0441 \u04bb\u04d9\u043c \u041d\u0435\u0432\u0438\u0441" },
            { "KP", "\u0422\u04e9\u043d\u044c\u044f\u043a \u041a\u043e\u0440\u0435\u044f" },
            { "KW", "\u041a\u04af\u0432\u04d9\u0439\u0442" },
            { "KY", "\u041a\u0430\u0439\u043c\u0430\u043d \u0443\u0442\u0440\u0430\u0443\u043b\u0430\u0440\u044b" },
            { "KZ", "\u041a\u0430\u0437\u0430\u0445\u0441\u0442\u0430\u043d" },
            { "LA", "\u041b\u0430\u043e\u0441" },
            { "LB", "\u041b\u0438\u0432\u0430\u043d" },
            { "LC", "\u0421\u0435\u043d\u0442-\u041b\u044e\u0441\u0438\u044f" },
            { "LI", "\u041b\u0438\u0445\u0442\u0435\u043d\u0448\u0442\u0435\u0439\u043d" },
            { "LK", "\u0428\u0440\u0438-\u041b\u0430\u043d\u043a\u0430" },
            { "LR", "\u041b\u0438\u0431\u0435\u0440\u0438\u044f" },
            { "LS", "\u041b\u0435\u0441\u043e\u0442\u043e" },
            { "LT", "\u041b\u0438\u0442\u0432\u0430" },
            { "LU", "\u041b\u044e\u043a\u0441\u0435\u043c\u0431\u0443\u0440\u0433" },
            { "LV", "\u041b\u0430\u0442\u0432\u0438\u044f" },
            { "LY", "\u041b\u0438\u0432\u0438\u044f" },
            { "MA", "\u041c\u0430\u0440\u043e\u043a\u043a\u043e" },
            { "MC", "\u041c\u043e\u043d\u0430\u043a\u043e" },
            { "MD", "\u041c\u043e\u043b\u0434\u043e\u0432\u0430" },
            { "ME", "\u0427\u0435\u0440\u043d\u043e\u0433\u043e\u0440\u0438\u044f" },
            { "MF", "\u0421\u0435\u043d\u0442-\u041c\u0430\u0440\u0442\u0438\u043d" },
            { "MG", "\u041c\u0430\u0434\u0430\u0433\u0430\u0441\u043a\u0430\u0440" },
            { "MH", "\u041c\u0430\u0440\u0448\u0430\u043b\u043b \u0443\u0442\u0440\u0430\u0443\u043b\u0430\u0440\u044b" },
            { "MK", "\u0422\u04e9\u043d\u044c\u044f\u043a \u041c\u0430\u043a\u0435\u0434\u043e\u043d\u0438\u044f" },
            { "ML", "\u041c\u0430\u043b\u0438" },
            { "MN", "\u041c\u043e\u043d\u0433\u043e\u043b\u0438\u044f" },
            { "MO", "\u041c\u0430\u043a\u0430\u043e \u041c\u0430\u0445\u0441\u0443\u0441 \u0418\u0434\u0430\u0440\u04d9\u043b\u0435 \u0422\u04e9\u0431\u04d9\u0433\u0435" },
            { "MP", "\u0422\u04e9\u043d\u044c\u044f\u043a \u041c\u0430\u0440\u0438\u0430\u043d\u0430 \u0443\u0442\u0440\u0430\u0443\u043b\u0430\u0440\u044b" },
            { "MQ", "\u041c\u0430\u0440\u0442\u0438\u043d\u0438\u043a\u0430" },
            { "MR", "\u041c\u0430\u0432\u0440\u0438\u0442\u0430\u043d\u0438\u044f" },
            { "MS", "\u041c\u043e\u043d\u0442\u0441\u0435\u0440\u0440\u0430\u0442" },
            { "MT", "\u041c\u0430\u043b\u044c\u0442\u0430" },
            { "MU", "\u041c\u0430\u0432\u0440\u0438\u043a\u0438\u0439" },
            { "MV", "\u041c\u0430\u043b\u044c\u0434\u0438\u0432 \u0443\u0442\u0440\u0430\u0443\u043b\u0430\u0440\u044b" },
            { "MW", "\u041c\u0430\u043b\u0430\u0432\u0438" },
            { "MX", "\u041c\u0435\u043a\u0441\u0438\u043a\u0430" },
            { "MY", "\u041c\u0430\u043b\u0430\u0439\u0437\u0438\u044f" },
            { "MZ", "\u041c\u043e\u0437\u0430\u043c\u0431\u0438\u043a" },
            { "NA", "\u041d\u0430\u043c\u0438\u0431\u0438\u044f" },
            { "NC", "\u042f\u04a3\u0430 \u041a\u0430\u043b\u0435\u0434\u043e\u043d\u0438\u044f" },
            { "NE", "\u041d\u0438\u0433\u0435\u0440" },
            { "NF", "\u041d\u043e\u0440\u0444\u043e\u043b\u043a \u0443\u0442\u0440\u0430\u0432\u044b" },
            { "NG", "\u041d\u0438\u0433\u0435\u0440\u0438\u044f" },
            { "NI", "\u041d\u0438\u043a\u0430\u0440\u0430\u0433\u0443\u0430" },
            { "NL", "\u041d\u0438\u0434\u0435\u0440\u043b\u0430\u043d\u0434" },
            { "NO", "\u041d\u043e\u0440\u0432\u0435\u0433\u0438\u044f" },
            { "NP", "\u041d\u0435\u043f\u0430\u043b" },
            { "NR", "\u041d\u0430\u0443\u0440\u0443" },
            { "NU", "\u041d\u0438\u0443\u044d" },
            { "NZ", "\u042f\u04a3\u0430 \u0417\u0435\u043b\u0430\u043d\u0434\u0438\u044f" },
            { "OM", "\u041e\u043c\u0430\u043d" },
            { "PA", "\u041f\u0430\u043d\u0430\u043c\u0430" },
            { "PE", "\u041f\u0435\u0440\u0443" },
            { "PF", "\u0424\u0440\u0430\u043d\u0446\u0443\u0437 \u041f\u043e\u043b\u0438\u043d\u0435\u0437\u0438\u044f\u0441\u0435" },
            { "PG", "\u041f\u0430\u043f\u0443\u0430 - \u042f\u04a3\u0430 \u0413\u0432\u0438\u043d\u0435\u044f" },
            { "PH", "\u0424\u0438\u043b\u0438\u043f\u043f\u0438\u043d" },
            { "PK", "\u041f\u0430\u043a\u0438\u0441\u0442\u0430\u043d" },
            { "PL", "\u041f\u043e\u043b\u044c\u0448\u0430" },
            { "PM", "\u0421\u0435\u043d-\u041f\u044c\u0435\u0440 \u04bb\u04d9\u043c \u041c\u0438\u043a\u0435\u043b\u043e\u043d" },
            { "PN", "\u041f\u0438\u0442\u043a\u044d\u0440\u043d \u0443\u0442\u0440\u0430\u0443\u043b\u0430\u0440\u044b" },
            { "PR", "\u041f\u0443\u044d\u0440\u0442\u043e-\u0420\u0438\u043a\u043e" },
            { "PT", "\u041f\u043e\u0440\u0442\u0443\u0433\u0430\u043b\u0438\u044f" },
            { "PW", "\u041f\u0430\u043b\u0430\u0443" },
            { "PY", "\u041f\u0430\u0440\u0430\u0433\u0432\u0430\u0439" },
            { "QA", "\u041a\u0430\u0442\u0430\u0440" },
            { "RE", "\u0420\u0435\u044e\u043d\u044c\u043e\u043d" },
            { "RO", "\u0420\u0443\u043c\u044b\u043d\u0438\u044f" },
            { "RS", "\u0421\u0435\u0440\u0431\u0438\u044f" },
            { "RU", "\u0420\u043e\u0441\u0441\u0438\u044f" },
            { "RW", "\u0420\u0443\u0430\u043d\u0434\u0430" },
            { "SA", "\u0421\u043e\u0433\u0443\u0434 \u0413\u0430\u0440\u04d9\u0431\u0441\u0442\u0430\u043d\u044b" },
            { "SB", "\u0421\u04e9\u043b\u04d9\u0439\u043c\u0430\u043d \u0443\u0442\u0440\u0430\u0443\u043b\u0430\u0440\u044b" },
            { "SC", "\u0421\u0435\u0439\u0448\u0435\u043b \u0443\u0442\u0440\u0430\u0443\u043b\u0430\u0440\u044b" },
            { "SD", "\u0421\u0443\u0434\u0430\u043d" },
            { "SE", "\u0428\u0432\u0435\u0446\u0438\u044f" },
            { "SG", "\u0421\u0438\u043d\u0433\u0430\u043f\u0443\u0440" },
            { "SI", "\u0421\u043b\u043e\u0432\u0435\u043d\u0438\u044f" },
            { "SJ", "\u0428\u043f\u0438\u0446\u0431\u0435\u0440\u0433\u0435\u043d \u04bb\u04d9\u043c \u042f\u043d-\u041c\u0430\u0439\u0435\u043d" },
            { "SK", "\u0421\u043b\u043e\u0432\u0430\u043a\u0438\u044f" },
            { "SL", "\u0421\u044c\u0435\u0440\u0440\u0430-\u041b\u0435\u043e\u043d\u0435" },
            { "SM", "\u0421\u0430\u043d-\u041c\u0430\u0440\u0438\u043d\u043e" },
            { "SN", "\u0421\u0435\u043d\u0435\u0433\u0430\u043b" },
            { "SO", "\u0421\u043e\u043c\u0430\u043b\u0438" },
            { "SR", "\u0421\u0443\u0440\u0438\u043d\u0430\u043c" },
            { "SS", "\u041a\u04e9\u043d\u044c\u044f\u043a \u0421\u0443\u0434\u0430\u043d" },
            { "ST", "\u0421\u0430\u043d-\u0422\u043e\u043c\u0435 \u04bb\u04d9\u043c \u041f\u0440\u0438\u043d\u0441\u0438\u043f\u0438" },
            { "SV", "\u0421\u0430\u043b\u044c\u0432\u0430\u0434\u043e\u0440" },
            { "SX", "\u0421\u0438\u043d\u0442-\u041c\u0430\u0440\u0442\u0435\u043d" },
            { "SY", "\u0421\u04af\u0440\u0438\u044f" },
            { "SZ", "\u0421\u0432\u0430\u0437\u0438\u043b\u0435\u043d\u0434" },
            { "TC", "\u0422\u0435\u0440\u043a\u0441 \u04bb\u04d9\u043c \u041a\u0430\u0439\u043a\u043e\u0441 \u0443\u0442\u0440\u0430\u0443\u043b\u0430\u0440\u044b" },
            { "TD", "\u0427\u0430\u0434" },
            { "TF", "\u0424\u0440\u0430\u043d\u0446\u0438\u044f\u043d\u0435\u04a3 \u041a\u04e9\u043d\u044c\u044f\u043a \u0422\u0435\u0440\u0440\u0438\u0442\u043e\u0440\u0438\u044f\u043b\u04d9\u0440\u0435" },
            { "TG", "\u0422\u043e\u0433\u043e" },
            { "TH", "\u0422\u0430\u0439\u043b\u0430\u043d\u0434" },
            { "TJ", "\u0422\u0430\u0497\u0438\u043a\u0441\u0442\u0430\u043d" },
            { "TK", "\u0422\u043e\u043a\u0435\u043b\u0430\u0443" },
            { "TL", "\u0422\u0438\u043c\u043e\u0440-\u041b\u0435\u0441\u0442\u0435" },
            { "TM", "\u0422\u04e9\u0440\u043a\u043c\u04d9\u043d\u0441\u0442\u0430\u043d" },
            { "TN", "\u0422\u0443\u043d\u0438\u0441" },
            { "TO", "\u0422\u043e\u043d\u0433\u0430" },
            { "TR", "\u0422\u04e9\u0440\u043a\u0438\u044f" },
            { "TT", "\u0422\u0440\u0438\u043d\u0438\u0434\u0430\u0434 \u04bb\u04d9\u043c \u0422\u043e\u0431\u0430\u0433\u043e" },
            { "TV", "\u0422\u0443\u0432\u0430\u043b\u0443" },
            { "TW", "\u0422\u0430\u0439\u0432\u0430\u043d\u044c" },
            { "TZ", "\u0422\u0430\u043d\u0437\u0430\u043d\u0438\u044f" },
            { "UA", "\u0423\u043a\u0440\u0430\u0438\u043d\u0430" },
            { "UG", "\u0423\u0433\u0430\u043d\u0434\u0430" },
            { "UM", "\u0410\u041a\u0428 \u041a\u0435\u0447\u0435 \u0427\u0438\u0442\u0442\u04d9\u0433\u0435 \u0443\u0442\u0440\u0430\u0443\u043b\u0430\u0440\u044b" },
            { "US", "\u0410\u041a\u0428" },
            { "UY", "\u0423\u0440\u0443\u0433\u0432\u0430\u0439" },
            { "UZ", "\u04ae\u0437\u0431\u04d9\u043a\u0441\u0442\u0430\u043d" },
            { "VC", "\u0421\u0435\u043d\u0442-\u0412\u0438\u043d\u0441\u0435\u043d\u0442 \u04bb\u04d9\u043c \u0413\u0440\u0435\u043d\u0430\u0434\u0438\u043d" },
            { "VE", "\u0412\u0435\u043d\u0435\u0441\u0443\u044d\u043b\u0430" },
            { "VG", "\u0411\u0440\u0438\u0442\u0430\u043d\u0438\u044f \u0412\u0438\u0440\u0433\u0438\u043d \u0443\u0442\u0440\u0430\u0443\u043b\u0430\u0440\u044b" },
            { "VI", "\u0410\u041a\u0428 \u0412\u0438\u0440\u0433\u0438\u043d \u0443\u0442\u0440\u0430\u0443\u043b\u0430\u0440\u044b" },
            { "VN", "\u0412\u044c\u0435\u0442\u043d\u0430\u043c" },
            { "VU", "\u0412\u0430\u043d\u0443\u0430\u0442\u0443" },
            { "WF", "\u0423\u043e\u043b\u043b\u0438\u0441 \u04bb\u04d9\u043c \u0424\u0443\u0442\u0443\u043d\u0430" },
            { "WS", "\u0421\u0430\u043c\u043e\u0430" },
            { "XK", "\u041a\u043e\u0441\u043e\u0432\u043e" },
            { "YE", "\u0419\u04d9\u043c\u04d9\u043d" },
            { "YT", "\u041c\u0430\u0439\u043e\u0442\u0442\u0430" },
            { "ZA", "\u041a\u04e9\u043d\u044c\u044f\u043a \u0410\u0444\u0440\u0438\u043a\u0430" },
            { "ZM", "\u0417\u0430\u043c\u0431\u0438\u044f" },
            { "ZW", "\u0417\u0438\u043c\u0431\u0430\u0431\u0432\u0435" },
            { "ZZ", "\u0431\u0438\u043b\u0433\u0435\u0441\u0435\u0437 \u0442\u04e9\u0431\u04d9\u043a" },
            { "af", "\u0430\u0444\u0440\u0438\u043a\u0430\u0430\u043d\u0441" },
            { "am", "\u0430\u043c\u0445\u0430\u0440" },
            { "ar", metaValue_ar },
            { "as", "\u0430\u0441\u0441\u0430\u043c" },
            { "az", "\u04d9\u0437\u04d9\u0440\u0431\u0430\u0439\u0497\u0430\u043d" },
            { "ba", "\u0431\u0430\u0448\u043a\u043e\u0440\u0442" },
            { "be", "\u0431\u0435\u043b\u043e\u0440\u0443\u0441" },
            { "bg", "\u0431\u043e\u043b\u0433\u0430\u0440" },
            { "bn", "\u0431\u0435\u043d\u0433\u0430\u043b\u0438" },
            { "bo", "\u0442\u0438\u0431\u0435\u0442" },
            { "br", "\u0431\u0440\u0435\u0442\u043e\u043d" },
            { "bs", "\u0431\u043e\u0441\u043d\u0438\u044f" },
            { "ca", "\u043a\u0430\u0442\u0430\u043b\u0430\u043d" },
            { "co", "\u043a\u043e\u0440\u0441\u0438\u043a\u0430" },
            { "cs", "\u0447\u0435\u0445" },
            { "cy", "\u0443\u044d\u043b\u044c\u0441" },
            { "da", "\u0434\u0430\u043d\u0438\u044f" },
            { "de", "\u0430\u043b\u043c\u0430\u043d" },
            { "dv", "\u043c\u0430\u043b\u044c\u0434\u0438\u0432" },
            { "dz", "\u0434\u0437\u043e\u043d\u0433-\u043a\u0445\u0430" },
            { "el", "\u0433\u0440\u0435\u043a" },
            { "en", "\u0438\u043d\u0433\u043b\u0438\u0437" },
            { "eo", "\u044d\u0441\u043f\u0435\u0440\u0430\u043d\u0442\u043e" },
            { "es", "\u0438\u0441\u043f\u0430\u043d" },
            { "et", "\u044d\u0441\u0442\u043e\u043d" },
            { "eu", "\u0431\u0430\u0441\u043a" },
            { "fa", "\u0444\u0430\u0440\u0441\u044b" },
            { "ff", "\u0444\u0443\u043b\u0430" },
            { "fi", "\u0444\u0438\u043d" },
            { "fo", "\u0444\u0430\u0440\u0435\u0440" },
            { "fr", "\u0444\u0440\u0430\u043d\u0446\u0443\u0437" },
            { "ga", "\u0438\u0440\u043b\u0430\u043d\u0434" },
            { "gd", "\u0448\u043e\u0442\u043b\u0430\u043d\u0434 \u0433\u044d\u043b\u044c" },
            { "gl", "\u0433\u0430\u043b\u0438\u0441\u0438\u044f" },
            { "gn", "\u0433\u0443\u0430\u0440\u0430\u043d\u0438" },
            { "gu", "\u0433\u0443\u0497\u0430\u0440\u0430\u0442\u0438" },
            { "ha", "\u0445\u0430\u0443\u0441\u0430" },
            { "he", "\u044f\u04bb\u04af\u0434" },
            { "hi", "\u04bb\u0438\u043d\u0434" },
            { "hr", "\u0445\u043e\u0440\u0432\u0430\u0442" },
            { "ht", "\u0433\u0430\u0438\u0442\u0438 \u043a\u0440\u0435\u043e\u043b" },
            { "hu", "\u0432\u0435\u043d\u0433\u0440" },
            { "hy", "\u04d9\u0440\u043c\u04d9\u043d" },
            { "hz", "\u0433\u0435\u0440\u0435\u0440\u043e" },
            { "id", "\u0438\u043d\u0434\u043e\u043d\u0435\u0437\u0438\u044f" },
            { "ig", "\u0438\u0433\u0431\u043e" },
            { "is", "\u0438\u0441\u043b\u0430\u043d\u0434" },
            { "it", "\u0438\u0442\u0430\u043b\u044c\u044f\u043d" },
            { "iu", "\u0438\u043d\u0443\u043a\u0442\u0438\u043a\u0443\u0442" },
            { "ja", "\u044f\u043f\u043e\u043d" },
            { "ka", "\u0433\u0440\u0443\u0437\u0438\u043d" },
            { "kk", "\u043a\u0430\u0437\u0430\u043a\u044a" },
            { "km", "\u043a\u0445\u043c\u0435\u0440" },
            { "kn", "\u043a\u0430\u043d\u043d\u0430\u0434\u0430" },
            { "ko", "\u043a\u043e\u0440\u0435\u044f" },
            { "kr", "\u043a\u0430\u043d\u0443\u0440\u0438" },
            { "ks", "\u043a\u0430\u0448\u043c\u0438\u0440\u0438" },
            { "ku", "\u043a\u04e9\u0440\u0434" },
            { "ky", "\u043a\u044b\u0440\u0433\u044b\u0437" },
            { "la", metaValue_la },
            { "lb", "\u043b\u044e\u043a\u0441\u0435\u043c\u0431\u0443\u0440\u0433" },
            { "lo", "\u043b\u0430\u043e\u0441" },
            { "lt", "\u043b\u0438\u0442\u0432\u0430" },
            { "lv", "\u043b\u0430\u0442\u044b\u0448" },
            { "mg", "\u043c\u0430\u043b\u0430\u0433\u0430\u0441\u0438" },
            { "mi", "\u043c\u0430\u043e\u0440\u0438" },
            { "mk", "\u043c\u0430\u043a\u0435\u0434\u043e\u043d" },
            { "ml", "\u043c\u0430\u043b\u0430\u044f\u043b\u0430\u043c" },
            { "mn", "\u043c\u043e\u043d\u0433\u043e\u043b" },
            { "mr", "\u043c\u0430\u0440\u0430\u0442\u0445\u0438" },
            { "ms", "\u043c\u0430\u043b\u0430\u0439" },
            { "mt", "\u043c\u0430\u043b\u044c\u0442\u0430" },
            { "my", "\u0431\u0438\u0440\u043c\u0430" },
            { "ne", "\u043d\u0435\u043f\u0430\u043b\u0438" },
            { "nl", "\u0433\u043e\u043b\u043b\u0430\u043d\u0434" },
            { "ny", "\u043d\u044c\u044f\u043d\u0497\u0430" },
            { "oc", "\u043e\u043a\u0441\u0438\u0442\u0430\u043d" },
            { "om", "\u043e\u0440\u043e\u043c\u043e" },
            { "or", "\u043e\u0440\u0438\u044f" },
            { "pa", "\u043f\u04d9\u043d\u0497\u0430\u0431\u0438" },
            { "pl", "\u043f\u043e\u043b\u044f\u043a" },
            { "ps", "\u043f\u0443\u0448\u0442\u0443" },
            { "pt", "\u043f\u043e\u0440\u0442\u0443\u0433\u0430\u043b" },
            { "qu", "\u043a\u0435\u0447\u0443\u0430" },
            { "rm", "\u0440\u0435\u0442\u043e\u0440\u043e\u043c\u0430\u043d" },
            { "ro", "\u0440\u0443\u043c\u044b\u043d" },
            { "ru", "\u0440\u0443\u0441" },
            { "rw", "\u0440\u0443\u0430\u043d\u0434\u0430" },
            { "sa", "\u0441\u0430\u043d\u0441\u043a\u0440\u0438\u0442" },
            { "sd", "\u0441\u0438\u043d\u0434\u04bb\u0438" },
            { "se", "\u0442\u04e9\u043d\u044c\u044f\u043a \u0441\u0430\u0430\u043c" },
            { "si", "\u0441\u0438\u043d\u0433\u0430\u043b" },
            { "sk", "\u0441\u043b\u043e\u0432\u0430\u043a" },
            { "sl", "\u0441\u043b\u043e\u0432\u0435\u043d" },
            { "so", "\u0441\u043e\u043c\u0430\u043b\u0438" },
            { "sq", "\u0430\u043b\u0431\u0430\u043d" },
            { "sr", "\u0441\u0435\u0440\u0431" },
            { "sv", "\u0448\u0432\u0435\u0434" },
            { "ta", "\u0442\u0430\u043c\u0438\u043b" },
            { "te", "\u0442\u0435\u043b\u0443\u0433\u0443" },
            { "tg", "\u0442\u0430\u0497\u0438\u043a" },
            { "th", "\u0442\u0430\u0439" },
            { "ti", "\u0442\u0438\u0433\u0440\u0438\u043d\u044c\u044f" },
            { "tk", "\u0442\u04e9\u0440\u0435\u043a\u043c\u04d9\u043d" },
            { "to", "\u0442\u043e\u043d\u0433\u0430" },
            { "tr", "\u0442\u04e9\u0440\u0435\u043a" },
            { "tt", "\u0442\u0430\u0442\u0430\u0440" },
            { "ug", "\u0443\u0439\u0433\u044b\u0440" },
            { "uk", "\u0443\u043a\u0440\u0430\u0438\u043d" },
            { "ur", "\u0443\u0440\u0434\u0443" },
            { "uz", "\u04af\u0437\u0431\u04d9\u043a" },
            { "ve", "\u0432\u0435\u043d\u0434\u0430" },
            { "vi", "\u0432\u044c\u0435\u0442\u043d\u0430\u043c" },
            { "wo", "\u0432\u043e\u043b\u043e\u0444" },
            { "yi", "\u0438\u0434\u0438\u0448" },
            { "yo", "\u0439\u043e\u0440\u0443\u0431\u0430" },
            { "zh", "\u043a\u044b\u0442\u0430\u0439" },
            { "arn", "\u043c\u0430\u043f\u0443\u0447\u0435" },
            { "ban", "\u0431\u0430\u043b\u0438" },
            { "bem", "\u0431\u0435\u043c\u0431\u0430" },
            { "ceb", "\u0441\u0435\u0431\u0443\u0430\u043d\u043e" },
            { "chm", "\u043c\u0430\u0440\u0438" },
            { "chr", "\u0447\u0435\u0440\u043e\u043a\u0438" },
            { "ckb", "\u04af\u0437\u04d9\u043a \u043a\u04e9\u0440\u0434" },
            { "dsb", "\u0442\u04af\u0431\u04d9\u043d \u0441\u043e\u0440\u0431" },
            { "fil", "\u0444\u0438\u043b\u0438\u043f\u043f\u0438\u043d" },
            { "haw", "\u0433\u0430\u0432\u0430\u0439\u0438" },
            { "hil", "\u0445\u0438\u043b\u0438\u0433\u0430\u0439\u043d\u043e\u043d" },
            { "hsb", "\u044e\u0433\u0430\u0440\u044b \u0441\u043e\u0440\u0431" },
            { "ibb", "\u0438\u0431\u0438\u0431\u0438\u043e" },
            { "kok", "\u043a\u043e\u043d\u043a\u0430\u043d\u0438" },
            { "kru", "\u043a\u0443\u0440\u0443\u0445" },
            { "men", "\u043c\u0435\u043d\u0434\u0435" },
            { "mni", "\u043c\u0430\u043d\u0438\u043f\u0443\u0440\u0438" },
            { "moh", "\u043c\u043e\u0433\u0430\u0443\u043a" },
            { "niu", "\u043d\u0438\u0443\u044d" },
            { "pap", "\u043f\u0430\u043f\u044c\u044f\u043c\u0435\u043d\u0442\u043e" },
            { "quc", "\u043a\u0438\u0447\u0435" },
            { "sah", "\u0441\u0430\u0445\u0430" },
            { "sat", "\u0441\u0430\u043d\u0442\u0430\u043b\u0438" },
            { "sma", "\u043a\u04e9\u043d\u044c\u044f\u043a \u0441\u0430\u0430\u043c" },
            { "smj", "\u043b\u0443\u043b\u0435-\u0441\u0430\u0430\u043c" },
            { "smn", "\u0438\u043d\u0430\u0440\u0438-\u0441\u0430\u0430\u043c" },
            { "sms", "\u043a\u043e\u043b\u0442\u0442\u0430-\u0441\u0430\u0430\u043c" },
            { "syr", "\u0441\u04af\u0440\u0438\u044f" },
            { "tzm", "\u04af\u0437\u04d9\u043a \u0430\u0442\u043b\u0430\u0441 \u0442\u0430\u043c\u0430\u0437\u0438\u0433\u0442" },
            { "und", "\u0431\u0438\u043b\u0433\u0435\u0441\u0435\u0437 \u0442\u0435\u043b" },
            { "Arab", metaValue_ar },
            { "Cyrl", "\u043a\u0438\u0440\u0438\u043b\u043b" },
            { "Hans", "\u0433\u0430\u0434\u0438\u043b\u04d9\u0448\u0442\u0435\u0440\u0435\u043b\u0433\u04d9\u043d" },
            { "Hant", "\u0442\u0440\u0430\u0434\u0438\u0446\u0438\u043e\u043d" },
            { "Latn", metaValue_la },
            { "Zxxx", "\u044f\u0437\u0443\u0441\u044b\u0437" },
            { "Zzzz", "\u0431\u0438\u043b\u0433\u0435\u0441\u0435\u0437 \u044f\u0437\u0443" },
            { "de_CH", "\u044e\u0433\u0430\u0440\u044b \u0430\u043b\u043c\u0430\u043d (\u0428\u0432\u0435\u0439\u0446\u0430\u0440\u0438\u044f)" },
            { "en_GB", "\u0411\u0440\u0438\u0442\u0430\u043d\u0438\u044f \u0438\u043d\u0433\u043b\u0438\u0437\u0447\u04d9\u0441\u0435" },
            { "en_US", "\u0410\u043c\u0435\u0440\u0438\u043a\u0430 \u0438\u043d\u0433\u043b\u0438\u0437\u0447\u04d9\u0441\u0435" },
            { "es_ES", "\u0438\u0441\u043f\u0430\u043d (\u0415\u0432\u0440\u043e\u043f\u0430)" },
            { "pt_PT", "\u043f\u043e\u0440\u0442\u0443\u0433\u0430\u043b (\u0415\u0432\u0440\u043e\u043f\u0430)" },
            { "es_419", "\u0438\u0441\u043f\u0430\u043d (\u041b\u0430\u0442\u0438\u043d \u0410\u043c\u0435\u0440\u0438\u043a\u0430\u0441\u044b)" },
            { "zh_Hans", "\u0433\u0430\u0434\u0438\u043b\u04d9\u0448\u0442\u0435\u0440\u0435\u043b\u0433\u04d9\u043d \u043a\u044b\u0442\u0430\u0439" },
            { "zh_Hant", "\u0442\u0440\u0430\u0434\u0438\u0446\u0438\u043e\u043d \u043a\u044b\u0442\u0430\u0439" },
            { "type.nu.latn", "\u043a\u04e9\u043d\u0431\u0430\u0442\u044b\u0448 \u0446\u0438\u0444\u0440\u043b\u0430\u0440\u044b" },
            { "type.co.standard", "\u0433\u0430\u0434\u04d9\u0442\u0438 \u0442\u04d9\u0440\u0442\u0438\u043f\u043b\u04d9\u04af \u044b\u0441\u0443\u043b\u044b" },
            { "type.ca.gregorian", "\u0433\u0440\u0438\u0433\u043e\u0440\u0438\u0430\u043d \u0435\u043b \u0438\u0441\u04d9\u0431\u0435" },
        };
        return data;
    }
}
