"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.evaluateRules = void 0;
const types_1 = require("../types");
const evaluateEndpointRule_1 = require("./evaluateEndpointRule");
const evaluateErrorRule_1 = require("./evaluateErrorRule");
const evaluateTreeRule_1 = require("./evaluateTreeRule");
const evaluateRules = (rules, options) => {
    for (const rule of rules) {
        if (rule.type === "endpoint") {
            const endpointOrUndefined = (0, evaluateEndpointRule_1.evaluateEndpointRule)(rule, options);
            if (endpointOrUndefined) {
                return endpointOrUndefined;
            }
        }
        else if (rule.type === "error") {
            (0, evaluateErrorRule_1.evaluateErrorRule)(rule, options);
        }
        else if (rule.type === "tree") {
            const endpointOrUndefined = (0, evaluateTreeRule_1.evaluateTreeRule)(rule, options);
            if (endpointOrUndefined) {
                return endpointOrUndefined;
            }
        }
        else {
            throw new types_1.EndpointError(`Unknown endpoint rule: ${rule}`);
        }
    }
    throw new types_1.EndpointError(`Rules evaluation failed`);
};
exports.evaluateRules = evaluateRules;
