/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.websocket;

import jakarta.websocket.ClientEndpointConfig;
import jakarta.websocket.CloseReason;
import jakarta.websocket.DeploymentException;
import jakarta.websocket.Endpoint;
import jakarta.websocket.EndpointConfig;
import jakarta.websocket.Extension;
import jakarta.websocket.MessageHandler;
import jakarta.websocket.PongMessage;
import jakarta.websocket.RemoteEndpoint;
import jakarta.websocket.SendResult;
import jakarta.websocket.Session;
import jakarta.websocket.WebSocketContainer;
import jakarta.websocket.server.ServerEndpointConfig;
import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.naming.NamingException;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.InstanceManager;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.res.StringManager;
import org.apache.tomcat.websocket.ClientEndpointHolder;
import org.apache.tomcat.websocket.Constants;
import org.apache.tomcat.websocket.FutureToSendHandler;
import org.apache.tomcat.websocket.MessageHandlerResult;
import org.apache.tomcat.websocket.Util;
import org.apache.tomcat.websocket.WrappedMessageHandler;
import org.apache.tomcat.websocket.WsFrameBase;
import org.apache.tomcat.websocket.WsRemoteEndpointAsync;
import org.apache.tomcat.websocket.WsRemoteEndpointBasic;
import org.apache.tomcat.websocket.WsRemoteEndpointImplBase;
import org.apache.tomcat.websocket.WsWebSocketContainer;
import org.apache.tomcat.websocket.pojo.PojoEndpointServer;
import org.apache.tomcat.websocket.server.DefaultServerEndpointConfigurator;

public class WsSession
implements Session {
    private final Log log;
    private static final StringManager sm = StringManager.getManager(WsSession.class);
    private static final byte[] ELLIPSIS_BYTES = "\u2026".getBytes(StandardCharsets.UTF_8);
    private static final int ELLIPSIS_BYTES_LEN = ELLIPSIS_BYTES.length;
    private static final boolean SEC_CONFIGURATOR_USES_IMPL_DEFAULT;
    private static AtomicLong ids;
    private final Endpoint localEndpoint;
    private final WsRemoteEndpointImplBase wsRemoteEndpoint;
    private final RemoteEndpoint.Async remoteEndpointAsync;
    private final RemoteEndpoint.Basic remoteEndpointBasic;
    private final ClassLoader applicationClassLoader;
    private final WsWebSocketContainer webSocketContainer;
    private final URI requestUri;
    private final Map<String, List<String>> requestParameterMap;
    private final String queryString;
    private final Principal userPrincipal;
    private final EndpointConfig endpointConfig;
    private final List<Extension> negotiatedExtensions;
    private final String subProtocol;
    private final Map<String, String> pathParameters;
    private final boolean secure;
    private final String httpSessionId;
    private final String id;
    private volatile MessageHandler textMessageHandler;
    private volatile MessageHandler binaryMessageHandler;
    private volatile MessageHandler.Whole<PongMessage> pongMessageHandler;
    private AtomicReference<State> state;
    private final Map<String, Object> userProperties;
    private volatile int maxBinaryMessageBufferSize;
    private volatile int maxTextMessageBufferSize;
    private volatile long maxIdleTimeout;
    private volatile long lastActiveRead;
    private volatile long lastActiveWrite;
    private Map<FutureToSendHandler, FutureToSendHandler> futures;
    private volatile Long sessionCloseTimeoutExpiry;
    private WsFrameBase wsFrame;

    public WsSession(ClientEndpointHolder clientEndpointHolder, WsRemoteEndpointImplBase wsRemoteEndpointImplBase, WsWebSocketContainer wsWebSocketContainer, List<Extension> list, String string, Map<String, String> map, boolean bl, ClientEndpointConfig clientEndpointConfig) throws DeploymentException {
        this.log = LogFactory.getLog(WsSession.class);
        this.textMessageHandler = null;
        this.binaryMessageHandler = null;
        this.pongMessageHandler = null;
        this.state = new AtomicReference<State>(State.OPEN);
        this.userProperties = new ConcurrentHashMap<String, Object>();
        this.maxBinaryMessageBufferSize = Constants.DEFAULT_BUFFER_SIZE;
        this.maxTextMessageBufferSize = Constants.DEFAULT_BUFFER_SIZE;
        this.maxIdleTimeout = 0L;
        this.lastActiveRead = System.currentTimeMillis();
        this.lastActiveWrite = System.currentTimeMillis();
        this.futures = new ConcurrentHashMap<FutureToSendHandler, FutureToSendHandler>();
        this.wsRemoteEndpoint = wsRemoteEndpointImplBase;
        this.wsRemoteEndpoint.setSession(this);
        this.remoteEndpointAsync = new WsRemoteEndpointAsync(wsRemoteEndpointImplBase);
        this.remoteEndpointBasic = new WsRemoteEndpointBasic(wsRemoteEndpointImplBase);
        this.webSocketContainer = wsWebSocketContainer;
        this.applicationClassLoader = Thread.currentThread().getContextClassLoader();
        wsRemoteEndpointImplBase.setSendTimeout(wsWebSocketContainer.getDefaultAsyncSendTimeout());
        this.maxBinaryMessageBufferSize = this.webSocketContainer.getDefaultMaxBinaryMessageBufferSize();
        this.maxTextMessageBufferSize = this.webSocketContainer.getDefaultMaxTextMessageBufferSize();
        this.maxIdleTimeout = this.webSocketContainer.getDefaultMaxSessionIdleTimeout();
        this.requestUri = null;
        this.requestParameterMap = Collections.emptyMap();
        this.queryString = null;
        this.userPrincipal = null;
        this.httpSessionId = null;
        this.negotiatedExtensions = list;
        this.subProtocol = string == null ? "" : string;
        this.pathParameters = map;
        this.secure = bl;
        this.wsRemoteEndpoint.setEncoders((EndpointConfig)clientEndpointConfig);
        this.endpointConfig = clientEndpointConfig;
        this.userProperties.putAll(this.endpointConfig.getUserProperties());
        this.id = Long.toHexString(ids.getAndIncrement());
        this.localEndpoint = clientEndpointHolder.getInstance(this.getInstanceManager());
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)sm.getString("wsSession.created", new Object[]{this.id}));
        }
    }

    public WsSession(WsRemoteEndpointImplBase wsRemoteEndpointImplBase, WsWebSocketContainer wsWebSocketContainer, URI uRI, Map<String, List<String>> map, String string, Principal principal, String string2, List<Extension> list, String string3, Map<String, String> map2, boolean bl, ServerEndpointConfig serverEndpointConfig) throws DeploymentException {
        Object object;
        block6: {
            this.log = LogFactory.getLog(WsSession.class);
            this.textMessageHandler = null;
            this.binaryMessageHandler = null;
            this.pongMessageHandler = null;
            this.state = new AtomicReference<State>(State.OPEN);
            this.userProperties = new ConcurrentHashMap<String, Object>();
            this.maxBinaryMessageBufferSize = Constants.DEFAULT_BUFFER_SIZE;
            this.maxTextMessageBufferSize = Constants.DEFAULT_BUFFER_SIZE;
            this.maxIdleTimeout = 0L;
            this.lastActiveRead = System.currentTimeMillis();
            this.lastActiveWrite = System.currentTimeMillis();
            this.futures = new ConcurrentHashMap<FutureToSendHandler, FutureToSendHandler>();
            this.wsRemoteEndpoint = wsRemoteEndpointImplBase;
            this.wsRemoteEndpoint.setSession(this);
            this.remoteEndpointAsync = new WsRemoteEndpointAsync(wsRemoteEndpointImplBase);
            this.remoteEndpointBasic = new WsRemoteEndpointBasic(wsRemoteEndpointImplBase);
            this.webSocketContainer = wsWebSocketContainer;
            this.applicationClassLoader = Thread.currentThread().getContextClassLoader();
            wsRemoteEndpointImplBase.setSendTimeout(wsWebSocketContainer.getDefaultAsyncSendTimeout());
            this.maxBinaryMessageBufferSize = this.webSocketContainer.getDefaultMaxBinaryMessageBufferSize();
            this.maxTextMessageBufferSize = this.webSocketContainer.getDefaultMaxTextMessageBufferSize();
            this.maxIdleTimeout = this.webSocketContainer.getDefaultMaxSessionIdleTimeout();
            this.requestUri = uRI;
            this.requestParameterMap = map == null ? Collections.emptyMap() : map;
            this.queryString = string;
            this.userPrincipal = principal;
            this.httpSessionId = string2;
            this.negotiatedExtensions = list;
            this.subProtocol = string3 == null ? "" : string3;
            this.pathParameters = map2;
            this.secure = bl;
            this.wsRemoteEndpoint.setEncoders((EndpointConfig)serverEndpointConfig);
            this.endpointConfig = serverEndpointConfig;
            this.userProperties.putAll(this.endpointConfig.getUserProperties());
            this.id = Long.toHexString(ids.getAndIncrement());
            InstanceManager instanceManager = this.getInstanceManager();
            ServerEndpointConfig.Configurator configurator = serverEndpointConfig.getConfigurator();
            Class clazz = serverEndpointConfig.getEndpointClass();
            try {
                if (instanceManager == null || !this.isDefaultConfigurator(configurator)) {
                    object = configurator.getEndpointInstance(clazz);
                    if (instanceManager == null) break block6;
                    try {
                        instanceManager.newInstance(object);
                        break block6;
                    }
                    catch (ReflectiveOperationException | NamingException exception) {
                        throw new DeploymentException(sm.getString("wsSession.instanceNew"), (Throwable)exception);
                    }
                }
                object = instanceManager.newInstance(clazz);
            }
            catch (ReflectiveOperationException | NamingException exception) {
                throw new DeploymentException(sm.getString("wsSession.instanceCreateFailed"), (Throwable)exception);
            }
        }
        this.localEndpoint = object instanceof Endpoint ? (Endpoint)object : new PojoEndpointServer(map2, object);
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)sm.getString("wsSession.created", new Object[]{this.id}));
        }
    }

    private boolean isDefaultConfigurator(ServerEndpointConfig.Configurator configurator) {
        if (configurator.getClass().equals(DefaultServerEndpointConfigurator.class)) {
            return true;
        }
        return SEC_CONFIGURATOR_USES_IMPL_DEFAULT && configurator.getClass().equals(ServerEndpointConfig.Configurator.class);
    }

    public InstanceManager getInstanceManager() {
        return this.webSocketContainer.getInstanceManager(this.applicationClassLoader);
    }

    public WebSocketContainer getContainer() {
        this.checkState();
        return this.webSocketContainer;
    }

    public void addMessageHandler(MessageHandler messageHandler) {
        Class<?> clazz = Util.getMessageType(messageHandler);
        this.doAddMessageHandler(clazz, messageHandler);
    }

    public <T> void addMessageHandler(Class<T> clazz, MessageHandler.Partial<T> partial) throws IllegalStateException {
        this.doAddMessageHandler(clazz, (MessageHandler)partial);
    }

    public <T> void addMessageHandler(Class<T> clazz, MessageHandler.Whole<T> whole) throws IllegalStateException {
        this.doAddMessageHandler(clazz, (MessageHandler)whole);
    }

    private void doAddMessageHandler(Class<?> clazz, MessageHandler messageHandler) {
        this.checkState();
        Set<MessageHandlerResult> set = Util.getMessageHandlers(clazz, messageHandler, this.endpointConfig, this);
        block5: for (MessageHandlerResult messageHandlerResult : set) {
            switch (messageHandlerResult.getType()) {
                case TEXT: {
                    if (this.textMessageHandler != null) {
                        throw new IllegalStateException(sm.getString("wsSession.duplicateHandlerText"));
                    }
                    this.textMessageHandler = messageHandlerResult.getHandler();
                    continue block5;
                }
                case BINARY: {
                    if (this.binaryMessageHandler != null) {
                        throw new IllegalStateException(sm.getString("wsSession.duplicateHandlerBinary"));
                    }
                    this.binaryMessageHandler = messageHandlerResult.getHandler();
                    continue block5;
                }
                case PONG: {
                    if (this.pongMessageHandler != null) {
                        throw new IllegalStateException(sm.getString("wsSession.duplicateHandlerPong"));
                    }
                    MessageHandler messageHandler2 = messageHandlerResult.getHandler();
                    if (messageHandler2 instanceof MessageHandler.Whole) {
                        this.pongMessageHandler = (MessageHandler.Whole)messageHandler2;
                        continue block5;
                    }
                    throw new IllegalStateException(sm.getString("wsSession.invalidHandlerTypePong"));
                }
            }
            throw new IllegalArgumentException(sm.getString("wsSession.unknownHandlerType", new Object[]{messageHandler, messageHandlerResult.getType()}));
        }
    }

    public Set<MessageHandler> getMessageHandlers() {
        this.checkState();
        HashSet<MessageHandler> hashSet = new HashSet<MessageHandler>();
        if (this.binaryMessageHandler != null) {
            hashSet.add(this.binaryMessageHandler);
        }
        if (this.textMessageHandler != null) {
            hashSet.add(this.textMessageHandler);
        }
        if (this.pongMessageHandler != null) {
            hashSet.add((MessageHandler)this.pongMessageHandler);
        }
        return hashSet;
    }

    public void removeMessageHandler(MessageHandler messageHandler) {
        this.checkState();
        if (messageHandler == null) {
            return;
        }
        MessageHandler messageHandler2 = null;
        if (messageHandler instanceof WrappedMessageHandler) {
            messageHandler2 = ((WrappedMessageHandler)messageHandler).getWrappedHandler();
        }
        if (messageHandler2 == null) {
            messageHandler2 = messageHandler;
        }
        boolean bl = false;
        if (messageHandler2.equals(this.textMessageHandler) || messageHandler.equals(this.textMessageHandler)) {
            this.textMessageHandler = null;
            bl = true;
        }
        if (messageHandler2.equals(this.binaryMessageHandler) || messageHandler.equals(this.binaryMessageHandler)) {
            this.binaryMessageHandler = null;
            bl = true;
        }
        if (messageHandler2.equals(this.pongMessageHandler) || messageHandler.equals(this.pongMessageHandler)) {
            this.pongMessageHandler = null;
            bl = true;
        }
        if (!bl) {
            throw new IllegalStateException(sm.getString("wsSession.removeHandlerFailed", new Object[]{messageHandler}));
        }
    }

    public String getProtocolVersion() {
        this.checkState();
        return "13";
    }

    public String getNegotiatedSubprotocol() {
        this.checkState();
        return this.subProtocol;
    }

    public List<Extension> getNegotiatedExtensions() {
        this.checkState();
        return this.negotiatedExtensions;
    }

    public boolean isSecure() {
        this.checkState();
        return this.secure;
    }

    public boolean isOpen() {
        return this.state.get() == State.OPEN || this.state.get() == State.OUTPUT_CLOSING || this.state.get() == State.CLOSING;
    }

    public boolean isClosed() {
        return this.state.get() == State.CLOSED;
    }

    public long getMaxIdleTimeout() {
        this.checkState();
        return this.maxIdleTimeout;
    }

    public void setMaxIdleTimeout(long l) {
        this.checkState();
        this.maxIdleTimeout = l;
    }

    public void setMaxBinaryMessageBufferSize(int n) {
        this.checkState();
        this.maxBinaryMessageBufferSize = n;
    }

    public int getMaxBinaryMessageBufferSize() {
        this.checkState();
        return this.maxBinaryMessageBufferSize;
    }

    public void setMaxTextMessageBufferSize(int n) {
        this.checkState();
        this.maxTextMessageBufferSize = n;
    }

    public int getMaxTextMessageBufferSize() {
        this.checkState();
        return this.maxTextMessageBufferSize;
    }

    public Set<Session> getOpenSessions() {
        this.checkState();
        return this.webSocketContainer.getOpenSessions(this.getSessionMapKey());
    }

    public RemoteEndpoint.Async getAsyncRemote() {
        this.checkState();
        return this.remoteEndpointAsync;
    }

    public RemoteEndpoint.Basic getBasicRemote() {
        this.checkState();
        return this.remoteEndpointBasic;
    }

    public void close() throws IOException {
        this.close(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.NORMAL_CLOSURE, ""));
    }

    public void close(CloseReason closeReason) throws IOException {
        this.doClose(closeReason, closeReason);
    }

    public void doClose(CloseReason closeReason, CloseReason closeReason2) {
        this.doClose(closeReason, closeReason2, false);
    }

    public void doClose(CloseReason closeReason, CloseReason closeReason2, boolean bl) {
        if (!this.state.compareAndSet(State.OPEN, State.OUTPUT_CLOSING)) {
            return;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)sm.getString("wsSession.doClose", new Object[]{this.id}));
        }
        try {
            this.wsRemoteEndpoint.setBatchingAllowed(false);
        }
        catch (Throwable throwable) {
            ExceptionUtils.handleThrowable((Throwable)throwable);
            this.log.warn((Object)sm.getString("wsSession.flushFailOnClose"), throwable);
            this.fireEndpointOnError(throwable);
        }
        this.sendCloseMessage(closeReason);
        this.fireEndpointOnClose(closeReason2);
        if (!this.state.compareAndSet(State.OUTPUT_CLOSING, State.OUTPUT_CLOSED) || bl) {
            this.state.set(State.CLOSED);
            this.closeConnection();
        } else {
            this.sessionCloseTimeoutExpiry = System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(this.getSessionCloseTimeout());
        }
        IOException iOException = new IOException(sm.getString("wsSession.messageFailed"));
        SendResult sendResult = new SendResult((Throwable)iOException);
        for (FutureToSendHandler futureToSendHandler : this.futures.keySet()) {
            futureToSendHandler.onResult(sendResult);
        }
    }

    public void onClose(CloseReason closeReason) {
        if (this.state.compareAndSet(State.OPEN, State.CLOSING)) {
            try {
                this.wsRemoteEndpoint.setBatchingAllowed(false);
            }
            catch (Throwable throwable) {
                ExceptionUtils.handleThrowable((Throwable)throwable);
                this.log.warn((Object)sm.getString("wsSession.flushFailOnClose"), throwable);
                this.fireEndpointOnError(throwable);
            }
            this.sendCloseMessage(closeReason);
            this.fireEndpointOnClose(closeReason);
            this.state.set(State.CLOSED);
            this.closeConnection();
        } else if (!this.state.compareAndSet(State.OUTPUT_CLOSING, State.CLOSING) && this.state.compareAndSet(State.OUTPUT_CLOSED, State.CLOSED)) {
            this.closeConnection();
        }
    }

    private void closeConnection() {
        this.wsRemoteEndpoint.close();
        this.webSocketContainer.unregisterSession(this.getSessionMapKey(), this);
    }

    protected long getSessionCloseTimeout() {
        long l = 0L;
        Object object = this.userProperties.get("org.apache.tomcat.websocket.SESSION_CLOSE_TIMEOUT");
        if (object instanceof Long) {
            l = ((Long)object).intValue();
        }
        if (l <= 0L) {
            l = Constants.DEFAULT_SESSION_CLOSE_TIMEOUT;
        }
        return l;
    }

    protected void checkCloseTimeout() {
        if (this.sessionCloseTimeoutExpiry != null && System.nanoTime() - this.sessionCloseTimeoutExpiry > 0L && this.state.compareAndSet(State.OUTPUT_CLOSED, State.CLOSED)) {
            this.closeConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireEndpointOnClose(CloseReason closeReason) {
        Throwable throwable = null;
        InstanceManager instanceManager = this.getInstanceManager();
        Thread thread = Thread.currentThread();
        ClassLoader classLoader = thread.getContextClassLoader();
        thread.setContextClassLoader(this.applicationClassLoader);
        try {
            this.localEndpoint.onClose((Session)this, closeReason);
        }
        catch (Throwable throwable2) {
            ExceptionUtils.handleThrowable((Throwable)throwable2);
            throwable = throwable2;
        }
        finally {
            block14: {
                if (instanceManager != null) {
                    try {
                        instanceManager.destroyInstance((Object)this.localEndpoint);
                    }
                    catch (Throwable throwable3) {
                        ExceptionUtils.handleThrowable((Throwable)throwable3);
                        if (throwable != null) break block14;
                        throwable = throwable3;
                    }
                }
            }
            thread.setContextClassLoader(classLoader);
        }
        if (throwable != null) {
            this.fireEndpointOnError(throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireEndpointOnError(Throwable throwable) {
        Thread thread = Thread.currentThread();
        ClassLoader classLoader = thread.getContextClassLoader();
        thread.setContextClassLoader(this.applicationClassLoader);
        try {
            this.localEndpoint.onError((Session)this, throwable);
        }
        finally {
            thread.setContextClassLoader(classLoader);
        }
    }

    private void sendCloseMessage(CloseReason closeReason) {
        block6: {
            ByteBuffer byteBuffer = ByteBuffer.allocate(125);
            CloseReason.CloseCode closeCode = closeReason.getCloseCode();
            if (closeCode == CloseReason.CloseCodes.CLOSED_ABNORMALLY) {
                byteBuffer.putShort((short)CloseReason.CloseCodes.PROTOCOL_ERROR.getCode());
            } else {
                byteBuffer.putShort((short)closeCode.getCode());
            }
            String string = closeReason.getReasonPhrase();
            if (string != null && string.length() > 0) {
                WsSession.appendCloseReasonWithTruncation(byteBuffer, string);
            }
            byteBuffer.flip();
            try {
                this.wsRemoteEndpoint.sendMessageBlock((byte)8, byteBuffer, true);
            }
            catch (IOException | IllegalStateException exception) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)sm.getString("wsSession.sendCloseFail", new Object[]{this.id}), (Throwable)exception);
                }
                this.closeConnection();
                if (closeCode == CloseReason.CloseCodes.CLOSED_ABNORMALLY) break block6;
                this.localEndpoint.onError((Session)this, (Throwable)exception);
            }
        }
    }

    private Object getSessionMapKey() {
        if (this.endpointConfig instanceof ServerEndpointConfig) {
            return ((ServerEndpointConfig)this.endpointConfig).getPath();
        }
        return this.localEndpoint;
    }

    protected static void appendCloseReasonWithTruncation(ByteBuffer byteBuffer, String string) {
        byte[] byArray = string.getBytes(StandardCharsets.UTF_8);
        if (byArray.length <= 123) {
            byteBuffer.put(byArray);
        } else {
            int n = 0;
            byte[] byArray2 = string.substring(n, n + 1).getBytes(StandardCharsets.UTF_8);
            for (int i = 123 - ELLIPSIS_BYTES_LEN; i >= byArray2.length; i -= byArray2.length) {
                byteBuffer.put(byArray2);
                byArray2 = string.substring(++n, n + 1).getBytes(StandardCharsets.UTF_8);
            }
            byteBuffer.put(ELLIPSIS_BYTES);
        }
    }

    protected void registerFuture(FutureToSendHandler futureToSendHandler) {
        this.futures.put(futureToSendHandler, futureToSendHandler);
        if (this.isOpen()) {
            return;
        }
        if (futureToSendHandler.isDone()) {
            return;
        }
        IOException iOException = new IOException(sm.getString("wsSession.messageFailed"));
        SendResult sendResult = new SendResult((Throwable)iOException);
        futureToSendHandler.onResult(sendResult);
    }

    protected void unregisterFuture(FutureToSendHandler futureToSendHandler) {
        this.futures.remove(futureToSendHandler);
    }

    public URI getRequestURI() {
        this.checkState();
        return this.requestUri;
    }

    public Map<String, List<String>> getRequestParameterMap() {
        this.checkState();
        return this.requestParameterMap;
    }

    public String getQueryString() {
        this.checkState();
        return this.queryString;
    }

    public Principal getUserPrincipal() {
        this.checkState();
        return this.getUserPrincipalInternal();
    }

    public Principal getUserPrincipalInternal() {
        return this.userPrincipal;
    }

    public Map<String, String> getPathParameters() {
        this.checkState();
        return this.pathParameters;
    }

    public String getId() {
        return this.id;
    }

    public Map<String, Object> getUserProperties() {
        this.checkState();
        return this.userProperties;
    }

    public Endpoint getLocal() {
        return this.localEndpoint;
    }

    public String getHttpSessionId() {
        return this.httpSessionId;
    }

    protected MessageHandler getTextMessageHandler() {
        return this.textMessageHandler;
    }

    protected MessageHandler getBinaryMessageHandler() {
        return this.binaryMessageHandler;
    }

    protected MessageHandler.Whole<PongMessage> getPongMessageHandler() {
        return this.pongMessageHandler;
    }

    protected void updateLastActiveRead() {
        this.lastActiveRead = System.currentTimeMillis();
    }

    protected void updateLastActiveWrite() {
        this.lastActiveWrite = System.currentTimeMillis();
    }

    protected void checkExpiration() {
        long l = this.maxIdleTimeout;
        long l2 = this.getMaxIdleTimeoutRead();
        long l3 = this.getMaxIdleTimeoutWrite();
        long l4 = System.currentTimeMillis();
        String string = null;
        if (l2 > 0L && l4 - this.lastActiveRead > l2) {
            string = "wsSession.timeoutRead";
        } else if (l3 > 0L && l4 - this.lastActiveWrite > l3) {
            string = "wsSession.timeoutWrite";
        } else if (l > 0L && l4 - this.lastActiveRead > l && l4 - this.lastActiveWrite > l) {
            string = "wsSession.timeout";
        }
        if (string != null) {
            String string2 = sm.getString(string, new Object[]{this.getId()});
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)string2);
            }
            this.doClose(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.GOING_AWAY, string2), new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.CLOSED_ABNORMALLY, string2));
        }
    }

    private long getMaxIdleTimeoutRead() {
        Object object = this.userProperties.get("org.apache.tomcat.websocket.READ_IDLE_TIMEOUT_MS");
        if (object instanceof Long) {
            return (Long)object;
        }
        return 0L;
    }

    private long getMaxIdleTimeoutWrite() {
        Object object = this.userProperties.get("org.apache.tomcat.websocket.WRITE_IDLE_TIMEOUT_MS");
        if (object instanceof Long) {
            return (Long)object;
        }
        return 0L;
    }

    private void checkState() {
        if (this.isClosed()) {
            throw new IllegalStateException(sm.getString("wsSession.closed", new Object[]{this.id}));
        }
    }

    void setWsFrame(WsFrameBase wsFrameBase) {
        this.wsFrame = wsFrameBase;
    }

    public void suspend() {
        this.wsFrame.suspend();
    }

    public void resume() {
        this.wsFrame.resume();
    }

    static {
        ids = new AtomicLong(0L);
        ServerEndpointConfig.Builder builder = ServerEndpointConfig.Builder.create(Object.class, (String)"/");
        ServerEndpointConfig serverEndpointConfig = builder.build();
        SEC_CONFIGURATOR_USES_IMPL_DEFAULT = serverEndpointConfig.getConfigurator().getClass().equals(DefaultServerEndpointConfigurator.class);
    }

    private static enum State {
        OPEN,
        OUTPUT_CLOSING,
        OUTPUT_CLOSED,
        CLOSING,
        CLOSED;

    }
}

