/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.http;

import jakarta.servlet.http.HttpServletRequest;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.util.BitSet;
import java.util.Date;
import java.util.Map;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.http.CookieProcessorBase;
import org.apache.tomcat.util.http.MimeHeaders;
import org.apache.tomcat.util.http.SameSiteCookies;
import org.apache.tomcat.util.http.ServerCookies;
import org.apache.tomcat.util.http.parser.Cookie;
import org.apache.tomcat.util.http.parser.HttpParser;
import org.apache.tomcat.util.res.StringManager;

public class Rfc6265CookieProcessor
extends CookieProcessorBase {
    private static final Log log;
    private static final StringManager sm;
    private static final BitSet domainValid;

    @Override
    public Charset getCharset() {
        return StandardCharsets.UTF_8;
    }

    @Override
    public void parseCookieHeader(MimeHeaders mimeHeaders, ServerCookies serverCookies) {
        if (mimeHeaders == null) {
            return;
        }
        int n = mimeHeaders.findHeader("Cookie", 0);
        while (n >= 0) {
            MessageBytes messageBytes = mimeHeaders.getValue(n);
            if (messageBytes != null && !messageBytes.isNull()) {
                Object object;
                if (messageBytes.getType() != 2) {
                    if (log.isDebugEnabled()) {
                        object = new Exception();
                        log.debug((Object)sm.getString("rfc6265CookieProcessor.expectedBytes"), (Throwable)object);
                    }
                    messageBytes.toBytes();
                }
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Cookies: Parsing b[]: " + messageBytes.toString()));
                }
                object = messageBytes.getByteChunk();
                Cookie.parseCookie(object.getBytes(), object.getOffset(), object.getLength(), serverCookies);
            }
            ++n;
            n = mimeHeaders.findHeader("Cookie", n);
        }
    }

    @Override
    public String generateHeader(jakarta.servlet.http.Cookie cookie, HttpServletRequest httpServletRequest) {
        Object object;
        String string;
        String string2;
        String string3;
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(cookie.getName());
        stringBuffer.append('=');
        String string4 = cookie.getValue();
        if (string4 != null && string4.length() > 0) {
            this.validateCookieValue(string4);
            stringBuffer.append(string4);
        }
        if ((n = cookie.getMaxAge()) > -1) {
            stringBuffer.append("; Max-Age=");
            stringBuffer.append(n);
            stringBuffer.append("; Expires=");
            if (n == 0) {
                stringBuffer.append(ANCIENT_DATE);
            } else {
                ((DateFormat)COOKIE_DATE_FORMAT.get()).format(new Date(System.currentTimeMillis() + (long)n * 1000L), stringBuffer, new FieldPosition(0));
            }
        }
        if ((string3 = cookie.getDomain()) != null && string3.length() > 0) {
            this.validateDomain(string3);
            stringBuffer.append("; Domain=");
            stringBuffer.append(string3);
        }
        if ((string2 = cookie.getPath()) != null && string2.length() > 0) {
            this.validatePath(string2);
            stringBuffer.append("; Path=");
            stringBuffer.append(string2);
        }
        if (cookie.getSecure()) {
            stringBuffer.append("; Secure");
        }
        if (cookie.isHttpOnly()) {
            stringBuffer.append("; HttpOnly");
        }
        if ((string = cookie.getAttribute("SameSite")) == null) {
            object = this.getSameSiteCookies();
            if (!object.equals((Object)SameSiteCookies.UNSET)) {
                stringBuffer.append("; SameSite=");
                stringBuffer.append(object.getValue());
            }
        } else {
            stringBuffer.append("; SameSite=");
            stringBuffer.append(string);
        }
        object = cookie.getAttribute("Partitioned");
        if (object == null) {
            if (this.getPartitioned()) {
                stringBuffer.append("; Partitioned");
            }
        } else if (Boolean.parseBoolean((String)object)) {
            stringBuffer.append("; Partitioned");
        }
        block13: for (Map.Entry entry : cookie.getAttributes().entrySet()) {
            switch ((String)entry.getKey()) {
                case "Comment": 
                case "Domain": 
                case "Max-Age": 
                case "Path": 
                case "Secure": 
                case "HttpOnly": 
                case "SameSite": 
                case "Partitioned": {
                    continue block13;
                }
            }
            this.validateAttribute((String)entry.getKey(), (String)entry.getValue());
            stringBuffer.append("; ");
            stringBuffer.append((String)entry.getKey());
            stringBuffer.append('=');
            stringBuffer.append((String)entry.getValue());
        }
        return stringBuffer.toString();
    }

    private void validateCookieValue(String string) {
        int n = 0;
        int n2 = string.length();
        if (n2 > 1 && string.charAt(0) == '\"' && string.charAt(n2 - 1) == '\"') {
            n = 1;
            --n2;
        }
        char[] cArray = string.toCharArray();
        for (int i = n; i < n2; ++i) {
            char c = cArray[i];
            if (c >= '!' && c != '\"' && c != ',' && c != ';' && c != '\\' && c != '\u007f') continue;
            throw new IllegalArgumentException(sm.getString("rfc6265CookieProcessor.invalidCharInValue", new Object[]{Integer.toString(c)}));
        }
    }

    private void validateDomain(String string) {
        int n = -1;
        int n2 = -1;
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            n = n2;
            n2 = cArray[i];
            if (!domainValid.get(n2)) {
                throw new IllegalArgumentException(sm.getString("rfc6265CookieProcessor.invalidDomain", new Object[]{string}));
            }
            if (!(n != 46 && n != -1 || n2 != 46 && n2 != 45)) {
                throw new IllegalArgumentException(sm.getString("rfc6265CookieProcessor.invalidDomain", new Object[]{string}));
            }
            if (n != 45 || n2 != 46) continue;
            throw new IllegalArgumentException(sm.getString("rfc6265CookieProcessor.invalidDomain", new Object[]{string}));
        }
        if (n2 == 46 || n2 == 45) {
            throw new IllegalArgumentException(sm.getString("rfc6265CookieProcessor.invalidDomain", new Object[]{string}));
        }
    }

    private void validatePath(String string) {
        char[] cArray;
        for (char c : cArray = string.toCharArray()) {
            if (c >= ' ' && c <= '~' && c != ';') continue;
            throw new IllegalArgumentException(sm.getString("rfc6265CookieProcessor.invalidPath", new Object[]{string}));
        }
    }

    private void validateAttribute(String string, String string2) {
        char[] cArray;
        if (!HttpParser.isToken(string)) {
            throw new IllegalArgumentException(sm.getString("rfc6265CookieProcessor.invalidAttributeName", new Object[]{string}));
        }
        for (char c : cArray = string2.toCharArray()) {
            if (c >= ' ' && c <= '~' && c != ';') continue;
            throw new IllegalArgumentException(sm.getString("rfc6265CookieProcessor.invalidAttributeValue", new Object[]{string, string2}));
        }
    }

    static {
        int n;
        log = LogFactory.getLog(Rfc6265CookieProcessor.class);
        sm = StringManager.getManager((String)Rfc6265CookieProcessor.class.getPackage().getName());
        domainValid = new BitSet(128);
        for (n = 48; n <= 57; n = (int)((char)(n + 1))) {
            domainValid.set(n);
        }
        for (n = 97; n <= 122; n = (int)((char)(n + 1))) {
            domainValid.set(n);
        }
        for (n = 65; n <= 90; n = (int)((char)(n + 1))) {
            domainValid.set(n);
        }
        domainValid.set(46);
        domainValid.set(45);
    }
}

