/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.jfr.views.gc;

import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.Icon;
import org.graalvm.visualvm.jfr.model.JFREvent;
import org.graalvm.visualvm.jfr.model.JFREventVisitor;
import org.graalvm.visualvm.jfr.model.JFRPropertyNotAvailableException;
import org.graalvm.visualvm.jfr.views.gc.GcViewSupport;
import org.graalvm.visualvm.lib.jfluid.results.CCTNode;
import org.graalvm.visualvm.lib.profiler.api.icons.Icons;

abstract class GcNode
extends CCTNode {
    private static final GcNode[] NO_NODES = new GcNode[0];
    private final GcNode parent;
    private final List<GcNode> children;
    final String name;
    final Icon icon;
    String cause;
    long gcid = -1L;
    long count = 0L;
    Duration sumOfPauses;
    Duration longestPause;

    GcNode(String name, Icon icon, GcNode parent, List<GcNode> children) {
        this.parent = parent;
        this.children = children;
        this.name = name;
        this.icon = icon;
    }

    final void processData(Duration _sumOfPauses, Duration _longestPause, JFREvent event) throws JFRPropertyNotAvailableException {
        if (this.parent != null) {
            this.processDataImpl(event);
            this.sumOfPauses = this.sumOfPauses == null ? _sumOfPauses : this.sumOfPauses.plus(_sumOfPauses);
            if (this.longestPause == null || this.longestPause.compareTo(_longestPause) < 0) {
                this.longestPause = _longestPause;
            }
            this.parent.processData(_sumOfPauses, _longestPause, event);
        }
    }

    protected void processDataImpl(JFREvent event) throws JFRPropertyNotAvailableException {
    }

    GcNode getChild(String name) {
        if (this.children != null) {
            for (GcNode child : this.children) {
                if (!Objects.equals(name, child.name)) continue;
                return child;
            }
        }
        return null;
    }

    public GcNode getChild(int index) {
        return this.children == null ? null : this.children.get(index);
    }

    public GcNode[] getChildren() {
        return this.children == null ? NO_NODES : this.children.toArray(NO_NODES);
    }

    public int getIndexOfChild(Object child) {
        return this.children == null ? -1 : this.children.indexOf(child);
    }

    public int getNChildren() {
        return this.children == null ? 0 : this.children.size();
    }

    public boolean isLeaf() {
        return this.children == null ? true : this.children.isEmpty();
    }

    public GcNode getParent() {
        return this.parent;
    }

    protected void addChild(GcNode child) {
        if (this.children != null) {
            this.children.add(child);
        }
    }

    protected void removeAllChildren() {
        if (this.children != null) {
            this.children.clear();
        }
    }

    public int hashCode() {
        return Objects.hash(this.name, this.gcid);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GcNode)) {
            return false;
        }
        if (this.gcid == -1L && ((GcNode)((Object)o)).gcid == -1L) {
            return Objects.equals(this.name, ((GcNode)((Object)o)).name);
        }
        return this.gcid == ((GcNode)((Object)o)).gcid && Objects.equals(this.name, ((GcNode)((Object)o)).name);
    }

    public String toString() {
        return this.name;
    }

    static final class Root
    extends GcNode
    implements JFREventVisitor {
        private final GcViewSupport.Aggregation primary;
        private final GcViewSupport.Aggregation secondary;
        private List<Event> events;
        private Map<Long, List<PhaseRecord>> records;

        Root() {
            this(null, null);
        }

        Root(GcViewSupport.Aggregation primary, GcViewSupport.Aggregation secondary) {
            super(null, null, null, (List<GcNode>)(primary == null && secondary == null ? null : new ArrayList<GcNode>()));
            this.primary = primary;
            this.secondary = secondary;
        }

        @Override
        public void init() {
            if (GcViewSupport.Aggregation.PHASE.equals((Object)this.secondary)) {
                this.events = new ArrayList<Event>();
                this.records = new HashMap<Long, List<PhaseRecord>>();
            }
        }

        @Override
        public boolean visit(String typeName, JFREvent event) {
            if ("jdk.GarbageCollection".equals(typeName)) {
                String primaryName = Root.getName(this.primary, event);
                if (primaryName == null) {
                    primaryName = "<unknown>";
                }
                if (GcViewSupport.Aggregation.NONE.equals((Object)this.primary)) {
                    Event node = new Event(primaryName, this, this.events == null);
                    this.addChild(node);
                    if (this.events != null) {
                        this.events.add(node);
                    }
                    try {
                        node.processData(event.getDuration("sumOfPauses"), event.getDuration("longestPause"), event);
                    }
                    catch (JFRPropertyNotAvailableException jFRPropertyNotAvailableException) {}
                } else {
                    String secondaryName;
                    GcNode primaryNode = this.getChild(primaryName);
                    if (primaryNode == null) {
                        primaryNode = this.createNode(primaryName, this.primary, this, false);
                        this.addChild(primaryNode);
                    }
                    if ((secondaryName = Root.getName(GcViewSupport.Aggregation.NONE, event)) == null) {
                        secondaryName = "<unknown>";
                    }
                    Event secondaryNode = new Event(secondaryName, primaryNode, this.events == null);
                    primaryNode.addChild(secondaryNode);
                    if (this.events != null) {
                        this.events.add(secondaryNode);
                    }
                    try {
                        secondaryNode.processData(event.getDuration("sumOfPauses"), event.getDuration("longestPause"), event);
                    }
                    catch (JFRPropertyNotAvailableException jFRPropertyNotAvailableException) {}
                }
            } else if (this.records != null && typeName != null && typeName.startsWith("jdk.GCPhase")) {
                try {
                    long gcId = event.getLong("gcId");
                    List<PhaseRecord> prlist = this.records.get(gcId);
                    if (prlist == null) {
                        prlist = new ArrayList<PhaseRecord>();
                        this.records.put(gcId, prlist);
                    }
                    Instant ptime = event.getInstant("eventTime");
                    String pname = PhaseRecord.phaseName(typeName) + " - " + event.getString("name");
                    Duration pduration = event.getDuration("eventDuration");
                    prlist.add(new PhaseRecord(ptime, pname, pduration));
                }
                catch (JFRPropertyNotAvailableException jFRPropertyNotAvailableException) {
                    // empty catch block
                }
            }
            return false;
        }

        @Override
        public void done() {
            if (this.records != null) {
                for (Event event : this.events) {
                    List<PhaseRecord> precords = this.records.get(event.gcid);
                    if (precords == null) continue;
                    precords.sort(new Comparator<PhaseRecord>(){

                        @Override
                        public int compare(PhaseRecord pr1, PhaseRecord pr2) {
                            return pr1.time.compareTo(pr2.time);
                        }
                    });
                    int idx = 0;
                    for (PhaseRecord precord : precords) {
                        event.addChild(new Phase(precord.name, precord.duration, idx++, event));
                    }
                }
                this.events.clear();
                this.events = null;
                this.records.clear();
                this.records = null;
            }
        }

        @Override
        public int hashCode() {
            return 37;
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof Root;
        }

        private static String getName(GcViewSupport.Aggregation aggregation, JFREvent event) {
            try {
                if (GcViewSupport.Aggregation.NONE.equals((Object)aggregation)) {
                    return event.getString("name") + " - " + event.getString("cause");
                }
                if (GcViewSupport.Aggregation.NAME.equals((Object)aggregation)) {
                    return event.getString("name");
                }
                if (GcViewSupport.Aggregation.CAUSE.equals((Object)aggregation)) {
                    return event.getString("cause");
                }
            }
            catch (JFRPropertyNotAvailableException jFRPropertyNotAvailableException) {
                // empty catch block
            }
            return null;
        }

        private GcNode createNode(String name, GcViewSupport.Aggregation aggregation, GcNode parent, boolean terminal) {
            if (GcViewSupport.Aggregation.NONE.equals((Object)aggregation)) {
                return new Event(name, parent, terminal);
            }
            if (GcViewSupport.Aggregation.NAME.equals((Object)aggregation)) {
                return new Name(name, parent, terminal);
            }
            if (GcViewSupport.Aggregation.CAUSE.equals((Object)aggregation)) {
                return new Cause(name, parent, terminal);
            }
            return null;
        }

        private static class PhaseRecord {
            final Instant time;
            final String name;
            final Duration duration;

            PhaseRecord(Instant time, String name, Duration duration) {
                this.time = time;
                this.name = name;
                this.duration = duration;
            }

            static String phaseName(String typeName) {
                if ("jdk.GCPhaseConcurrent".equals(typeName)) {
                    return "[concurrent]";
                }
                if ("jdk.GCPhaseParallel".equals(typeName)) {
                    return "[parallel]";
                }
                if ("jdk.GCPhasePause".equals(typeName)) {
                    return "[pause]";
                }
                if ("jdk.GCPhasePauseLevel1".equals(typeName)) {
                    return "[pause level 1]";
                }
                if ("jdk.GCPhasePauseLevel2".equals(typeName)) {
                    return "[pause level 2]";
                }
                if ("jdk.GCPhasePauseLevel3".equals(typeName)) {
                    return "[pause level 3]";
                }
                if ("jdk.GCPhasePauseLevel4".equals(typeName)) {
                    return "[pause level 4]";
                }
                return "[unknown phase]";
            }
        }
    }

    static final class Label
    extends GcNode {
        Label(String label, GcNode parent) {
            super(label, null, parent, null);
        }

        static Label createNoData(GcNode parent) {
            return new Label("<no data>", parent);
        }
    }

    static final class Phase
    extends GcNode {
        private final int idx;

        Phase(String name, Duration duration, int idx, GcNode parent) {
            super(name, null, parent, null);
            this.sumOfPauses = duration;
            this.idx = idx;
        }

        @Override
        public int hashCode() {
            return this.idx;
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Phase)) {
                return false;
            }
            return this.idx == ((Phase)((Object)o)).idx;
        }
    }

    static final class Event
    extends GcNode {
        Event(String name, GcNode parent, boolean terminal) {
            super(name, Icons.getIcon((String)"ProfilerIcons.RunGC"), parent, terminal ? null : new ArrayList());
        }

        @Override
        protected void processDataImpl(JFREvent event) throws JFRPropertyNotAvailableException {
            this.cause = event.getString("cause");
            this.gcid = event.getLong("gcId");
        }
    }

    static final class Cause
    extends GcNode {
        Cause(String cause, GcNode parent, boolean terminal) {
            super(cause, null, parent, terminal ? null : new ArrayList());
        }

        @Override
        protected void processDataImpl(JFREvent event) throws JFRPropertyNotAvailableException {
            ++this.count;
        }
    }

    static final class Name
    extends GcNode {
        Name(String name, GcNode parent, boolean terminal) {
            super(name, null, parent, terminal ? null : new ArrayList());
        }

        @Override
        protected void processDataImpl(JFREvent event) throws JFRPropertyNotAvailableException {
            ++this.count;
        }
    }
}

