/*
 * Decompiled with CFR 0.152.
 */
package org.openide.windows;

import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.WeakHashMap;
import javax.swing.Action;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.openide.nodes.Node;
import org.openide.util.Utilities;
import org.openide.util.actions.SystemAction;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.TopComponentGroup;
import org.openide.windows.WindowManager;
import org.openide.windows.Workspace;

final class DummyWindowManager
extends WindowManager {
    private static final boolean VISIBLE = Boolean.parseBoolean(System.getProperty("org.openide.windows.DummyWindowManager.VISIBLE", "true"));
    private static final long serialVersionUID = 1L;
    private static Action[] DEFAULT_ACTIONS_CLONEABLE;
    private static Action[] DEFAULT_ACTIONS_NOT_CLONEABLE;
    private final Map<String, Workspace> workspaces = new TreeMap<String, Workspace>();
    private transient Frame mw;
    private transient PropertyChangeSupport pcs;

    public DummyWindowManager() {
        this.createWorkspace("default", null).createMode("editor", "editor", null);
    }

    @Override
    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.pcs == null) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    @Override
    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(propertyChangeListener);
        }
    }

    @Override
    protected TopComponent.Registry componentRegistry() {
        return new R();
    }

    private R registry() {
        return (R)this.getRegistry();
    }

    @Override
    protected WindowManager.Component createTopComponentManager(TopComponent topComponent) {
        return null;
    }

    @Override
    public synchronized Workspace createWorkspace(String string, String string2) {
        W w = new W(string);
        this.workspaces.put(string, w);
        if (this.pcs != null) {
            this.pcs.firePropertyChange("workspaces", null, null);
            this.pcs.firePropertyChange("currentWorkspace", null, null);
        }
        return w;
    }

    synchronized void delete(Workspace workspace) {
        this.workspaces.remove(workspace.getName());
        if (this.workspaces.isEmpty()) {
            this.createWorkspace("default", null);
        }
        if (this.pcs != null) {
            this.pcs.firePropertyChange("workspaces", null, null);
            this.pcs.firePropertyChange("currentWorkspace", null, null);
        }
    }

    @Override
    public synchronized Workspace findWorkspace(String string) {
        return this.workspaces.get(string);
    }

    @Override
    public synchronized Workspace getCurrentWorkspace() {
        return this.workspaces.values().iterator().next();
    }

    @Override
    public synchronized Workspace[] getWorkspaces() {
        return this.workspaces.values().toArray(new Workspace[0]);
    }

    @Override
    public synchronized void setWorkspaces(Workspace[] workspaceArray) {
        if (workspaceArray.length == 0) {
            throw new IllegalArgumentException();
        }
        this.workspaces.clear();
        for (int i = 0; i < workspaceArray.length; ++i) {
            this.workspaces.put(workspaceArray[i].getName(), workspaceArray[i]);
        }
        if (this.pcs != null) {
            this.pcs.firePropertyChange("workspaces", null, null);
            this.pcs.firePropertyChange("currentWorkspace", null, null);
        }
    }

    @Override
    public synchronized Frame getMainWindow() {
        if (this.mw == null) {
            this.mw = new JFrame("dummy");
        }
        return this.mw;
    }

    @Override
    public void updateUI() {
    }

    public Set<Mode> getModes() {
        HashSet<Mode> hashSet = new HashSet<Mode>();
        for (Workspace workspace : new HashSet<Workspace>(this.workspaces.values())) {
            hashSet.addAll(workspace.getModes());
        }
        return hashSet;
    }

    @Override
    public Mode findMode(TopComponent topComponent) {
        for (Mode mode : this.getModes()) {
            if (!Arrays.asList(mode.getTopComponents()).contains(topComponent)) continue;
            return mode;
        }
        return null;
    }

    @Override
    public Mode findMode(String string) {
        if (string == null) {
            return null;
        }
        for (Mode mode : this.getModes()) {
            if (!string.equals(mode.getName())) continue;
            return mode;
        }
        return null;
    }

    @Override
    public TopComponentGroup findTopComponentGroup(String string) {
        return null;
    }

    @Override
    public TopComponent findTopComponent(String string) {
        return null;
    }

    @Override
    protected String topComponentID(TopComponent topComponent, String string) {
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Action[] topComponentDefaultActions(TopComponent topComponent) {
        Class<DummyWindowManager> clazz = DummyWindowManager.class;
        synchronized (DummyWindowManager.class) {
            if (topComponent instanceof TopComponent.Cloneable) {
                if (DEFAULT_ACTIONS_CLONEABLE == null) {
                    DEFAULT_ACTIONS_CLONEABLE = DummyWindowManager.loadActions(new String[]{"Save", "CloneView", null, "CloseView"});
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return DEFAULT_ACTIONS_CLONEABLE;
            }
            if (DEFAULT_ACTIONS_NOT_CLONEABLE == null) {
                DEFAULT_ACTIONS_NOT_CLONEABLE = DummyWindowManager.loadActions(new String[]{"Save", null, "CloseView"});
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return DEFAULT_ACTIONS_NOT_CLONEABLE;
        }
    }

    private static Action[] loadActions(String[] stringArray) {
        ArrayList<SystemAction> arrayList = new ArrayList<SystemAction>();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null) {
                arrayList.add(null);
                continue;
            }
            try {
                Class<SystemAction> clazz = Class.forName("org.openide.actions." + stringArray[i] + "Action", true, classLoader).asSubclass(SystemAction.class);
                arrayList.add(SystemAction.get(clazz));
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return arrayList.toArray(new Action[0]);
    }

    @Override
    protected boolean topComponentIsOpened(TopComponent topComponent) {
        return topComponent.isShowing() || this.registry().opened.contains(topComponent);
    }

    @Override
    protected void topComponentActivatedNodesChanged(TopComponent topComponent, Node[] nodeArray) {
        this.registry().setActivatedNodes(topComponent, nodeArray);
    }

    @Override
    protected void topComponentIconChanged(TopComponent topComponent, Image image) {
        JFrame jFrame = (JFrame)SwingUtilities.getAncestorOfClass(JFrame.class, topComponent);
        if (jFrame != null) {
            jFrame.setIconImage(image);
        }
    }

    @Override
    protected void topComponentToolTipChanged(TopComponent topComponent, String string) {
    }

    @Override
    protected void topComponentDisplayNameChanged(TopComponent topComponent, String string) {
        JFrame jFrame = (JFrame)SwingUtilities.getAncestorOfClass(JFrame.class, topComponent);
        if (jFrame != null) {
            jFrame.setTitle(string);
        }
    }

    @Override
    protected void topComponentHtmlDisplayNameChanged(TopComponent topComponent, String string) {
    }

    @Override
    protected void topComponentOpen(TopComponent topComponent) {
        if (GraphicsEnvironment.isHeadless()) {
            return;
        }
        JFrame jFrame = (JFrame)SwingUtilities.getAncestorOfClass(JFrame.class, topComponent);
        if (jFrame == null) {
            jFrame = new JFrame(topComponent.getName());
            Image image = topComponent.getIcon();
            if (image != null) {
                jFrame.setIconImage(image);
            }
            jFrame.getContentPane().add(topComponent);
            jFrame.pack();
            final WeakReference<TopComponent> weakReference = new WeakReference<TopComponent>(topComponent);
            jFrame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent windowEvent) {
                    TopComponent topComponent = (TopComponent)weakReference.get();
                    if (topComponent == null) {
                        return;
                    }
                    topComponent.close();
                }

                @Override
                public void windowActivated(WindowEvent windowEvent) {
                    TopComponent topComponent = (TopComponent)weakReference.get();
                    if (topComponent == null) {
                        return;
                    }
                    topComponent.requestActive();
                }
            });
        }
        if (!topComponent.isShowing()) {
            this.componentOpenNotify(topComponent);
            this.componentShowing(topComponent);
            if (VISIBLE) {
                jFrame.setVisible(true);
            }
            this.registry().open(topComponent);
        }
    }

    @Override
    protected void topComponentClose(TopComponent topComponent) {
        if (!topComponent.canClose()) {
            return;
        }
        this.componentHidden(topComponent);
        this.componentCloseNotify(topComponent);
        JFrame jFrame = (JFrame)SwingUtilities.getAncestorOfClass(JFrame.class, topComponent);
        if (jFrame != null) {
            if (VISIBLE) {
                jFrame.setVisible(false);
            }
            topComponent.getParent().remove(topComponent);
        }
        this.registry().close(topComponent);
        for (W w : this.workspaces.values()) {
            w.close(topComponent);
        }
    }

    @Override
    protected void topComponentRequestVisible(TopComponent topComponent) {
        JFrame jFrame = (JFrame)SwingUtilities.getAncestorOfClass(JFrame.class, topComponent);
        if (jFrame != null && VISIBLE) {
            jFrame.setVisible(true);
        }
    }

    @Override
    protected void topComponentRequestActive(TopComponent topComponent) {
        JFrame jFrame = (JFrame)SwingUtilities.getAncestorOfClass(JFrame.class, topComponent);
        if (jFrame != null) {
            jFrame.toFront();
        }
        this.registry().setActive(topComponent);
        this.activateComponent(topComponent);
    }

    @Override
    protected void topComponentRequestAttention(TopComponent topComponent) {
    }

    @Override
    protected void topComponentCancelRequestAttention(TopComponent topComponent) {
    }

    @Override
    public boolean isEditorTopComponent(TopComponent topComponent) {
        Mode mode = this.findMode(topComponent);
        return mode != null && this.isEditorMode(mode);
    }

    @Override
    public boolean isOpenedEditorTopComponent(TopComponent topComponent) {
        Mode mode = this.findMode(topComponent);
        if (mode != null && this.isEditorMode(mode)) {
            return topComponent.isOpened();
        }
        return super.isOpenedEditorTopComponent(topComponent);
    }

    @Override
    public boolean isEditorMode(Mode mode) {
        if (null == mode) {
            return false;
        }
        return "editor".equals(mode.getName());
    }

    private static final class R
    implements TopComponent.Registry {
        private Reference<TopComponent> active = new WeakReference<Object>(null);
        private final Set<TopComponent> opened = new HashSet<TopComponent>(){

            @Override
            public Iterator<TopComponent> iterator() {
                HashSet<TopComponent> hashSet = new HashSet<TopComponent>();
                Iterator iterator = super.iterator();
                while (iterator.hasNext()) {
                    TopComponent topComponent = (TopComponent)iterator.next();
                    hashSet.add(topComponent);
                }
                return hashSet.iterator();
            }
        };
        private Node[] nodes = new Node[0];
        private PropertyChangeSupport pcs;

        @Override
        public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            if (this.pcs == null) {
                this.pcs = new PropertyChangeSupport(this);
            }
            this.pcs.addPropertyChangeListener(propertyChangeListener);
        }

        @Override
        public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            if (this.pcs != null) {
                this.pcs.removePropertyChangeListener(propertyChangeListener);
            }
        }

        synchronized void open(TopComponent topComponent) {
            this.opened.add(topComponent);
            if (this.pcs != null) {
                this.pcs.firePropertyChange("tcOpened", null, topComponent);
                this.pcs.firePropertyChange("opened", null, null);
            }
        }

        synchronized void close(TopComponent topComponent) {
            this.opened.remove(topComponent);
            if (this.pcs != null) {
                this.pcs.firePropertyChange("tcClosed", null, topComponent);
                this.pcs.firePropertyChange("opened", null, null);
            }
            if (this.getActive() == topComponent) {
                this.setActive(null);
            }
        }

        @Override
        public synchronized Set<TopComponent> getOpened() {
            return Collections.unmodifiableSet(this.opened);
        }

        synchronized void setActive(TopComponent topComponent) {
            Node[] nodeArray;
            this.active = new WeakReference<TopComponent>(topComponent);
            Node[] nodeArray2 = nodeArray = topComponent == null ? new Node[]{} : topComponent.getActivatedNodes();
            if (nodeArray != null) {
                this.nodes = nodeArray;
                if (this.pcs != null) {
                    this.pcs.firePropertyChange("activatedNodes", null, null);
                }
            }
            if (this.pcs != null) {
                this.pcs.firePropertyChange("activated", null, null);
                this.pcs.firePropertyChange("currentNodes", null, null);
            }
        }

        synchronized void setActivatedNodes(TopComponent topComponent, Node[] nodeArray) {
            if (topComponent == this.getActive()) {
                if (nodeArray != null) {
                    this.nodes = nodeArray;
                    if (this.pcs != null) {
                        this.pcs.firePropertyChange("activatedNodes", null, null);
                    }
                }
                if (this.pcs != null) {
                    this.pcs.firePropertyChange("currentNodes", null, null);
                }
            }
        }

        @Override
        public TopComponent getActivated() {
            return this.getActive();
        }

        @Override
        public Node[] getActivatedNodes() {
            return this.nodes;
        }

        @Override
        public synchronized Node[] getCurrentNodes() {
            if (this.getActive() != null) {
                return this.getActive().getActivatedNodes();
            }
            return null;
        }

        private TopComponent getActive() {
            return this.active.get();
        }
    }

    private final class W
    implements Workspace {
        private static final long serialVersionUID = 1L;
        private final String name;
        private final Map<String, Mode> modes = new HashMap<String, Mode>();
        private final Map<TopComponent, Mode> modesByComponent = new WeakHashMap<TopComponent, Mode>();
        private transient PropertyChangeSupport pcs;

        public W(String string) {
            this.name = string;
        }

        @Override
        public void activate() {
        }

        @Override
        public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            if (this.pcs == null) {
                this.pcs = new PropertyChangeSupport(this);
            }
            this.pcs.addPropertyChangeListener(propertyChangeListener);
        }

        @Override
        public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            if (this.pcs != null) {
                this.pcs.removePropertyChangeListener(propertyChangeListener);
            }
        }

        @Override
        public void remove() {
            DummyWindowManager.this.delete(this);
        }

        @Override
        public synchronized Mode createMode(String string, String string2, URL uRL) {
            M m = new M(string);
            this.modes.put(string, m);
            if (this.pcs != null) {
                this.pcs.firePropertyChange("modes", null, null);
            }
            return m;
        }

        public synchronized Set<Mode> getModes() {
            return new HashSet<Mode>(this.modes.values());
        }

        @Override
        public synchronized Mode findMode(String string) {
            return this.modes.get(string);
        }

        @Override
        public synchronized Mode findMode(TopComponent topComponent) {
            return this.modesByComponent.get(topComponent);
        }

        synchronized void dock(Mode mode, TopComponent topComponent) {
            this.modesByComponent.put(topComponent, mode);
        }

        @Override
        public Rectangle getBounds() {
            return Utilities.getUsableScreenBounds();
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getDisplayName() {
            return this.getName();
        }

        public void close(TopComponent topComponent) {
            for (M m : this.modes.values()) {
                m.close(topComponent);
            }
        }

        private final class M
        implements Mode {
            private static final long serialVersionUID = 1L;
            private final String name;
            private final Set<TopComponent> components = new HashSet<TopComponent>();

            public M(String string) {
                this.name = string;
            }

            public void close(TopComponent topComponent) {
                this.components.remove(topComponent);
            }

            @Override
            public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            }

            @Override
            public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            }

            @Override
            public boolean canDock(TopComponent topComponent) {
                return true;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public synchronized boolean dockInto(TopComponent topComponent) {
                if (this.components.add(topComponent)) {
                    Mode mode = W.this.findMode(topComponent);
                    if (mode != null && mode != this && mode instanceof M) {
                        Mode mode2 = mode;
                        synchronized (mode2) {
                            ((M)mode).components.remove(topComponent);
                        }
                    }
                    W.this.dock(this, topComponent);
                }
                return true;
            }

            @Override
            public String getName() {
                return this.name;
            }

            @Override
            public String getDisplayName() {
                return this.getName();
            }

            @Override
            public Image getIcon() {
                return null;
            }

            @Override
            public synchronized TopComponent[] getTopComponents() {
                return this.components.toArray(new TopComponent[0]);
            }

            @Override
            public Workspace getWorkspace() {
                return W.this;
            }

            @Override
            public synchronized Rectangle getBounds() {
                return W.this.getBounds();
            }

            @Override
            public void setBounds(Rectangle rectangle) {
            }

            @Override
            public TopComponent getSelectedTopComponent() {
                TopComponent[] topComponentArray = this.components.toArray(new TopComponent[0]);
                return topComponentArray.length > 0 ? topComponentArray[0] : null;
            }
        }
    }
}

