/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.sampler.truffle;

import java.io.IOException;
import java.util.Map;
import javax.management.Attribute;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;

public class ProxyTruffleMBean {
    private static final String TRUFFLE_OBJECT_NAME = "com.truffle:type=Threading";
    private final ObjectName truffleObjectName;
    private final MBeanServerConnection conn;

    public ProxyTruffleMBean(MBeanServerConnection c) {
        this.conn = c;
        this.truffleObjectName = ProxyTruffleMBean.getTruffleName();
    }

    public Map<String, Object>[] dumpAllThreads() throws InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        return (Map[])this.conn.invoke(this.truffleObjectName, "dumpAllThreads", null, null);
    }

    public boolean isStackTracesEnabled() throws InstanceNotFoundException, MBeanException, IOException, ReflectionException, AttributeNotFoundException {
        return (Boolean)this.conn.getAttribute(this.truffleObjectName, "StackTracesEnabled");
    }

    public Map<String, Object>[] heapHistogram() throws InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        return (Map[])this.conn.invoke(this.truffleObjectName, "heapHistogram", null, null);
    }

    public boolean isHeapHistogramEnabled() throws InstanceNotFoundException, MBeanException, IOException, ReflectionException, AttributeNotFoundException {
        return (Boolean)this.conn.getAttribute(this.truffleObjectName, "HeapHistogramEnabled");
    }

    public void setTrackFlags(boolean trackFlags) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException, IOException {
        this.conn.setAttribute(this.truffleObjectName, new Attribute("TrackFlags", trackFlags));
    }

    public void setMode(String mode) throws InstanceNotFoundException, MBeanException, ReflectionException, IOException, AttributeNotFoundException, InvalidAttributeValueException {
        this.conn.setAttribute(this.truffleObjectName, new Attribute("Mode", mode));
    }

    public boolean isModeAvailable() throws InstanceNotFoundException, MBeanException, IOException, ReflectionException, AttributeNotFoundException {
        return (Boolean)this.conn.getAttribute(this.truffleObjectName, "ModeAvailable");
    }

    public boolean isRegistered() throws IOException {
        return this.conn.isRegistered(this.truffleObjectName);
    }

    private static ObjectName getTruffleName() {
        try {
            return new ObjectName(TRUFFLE_OBJECT_NAME);
        }
        catch (MalformedObjectNameException ex) {
            throw new RuntimeException(ex);
        }
    }
}

